<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package activewin
 */

get_header('404');
?>

		<main id="main" class="content">
			<section class="error-404 not-found">
                <div class="container">
                    <div class="row">
                        <div class="col">
                                <h2><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'activewin' ); ?></h2>

                            <div class="page-content">
                                <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'activewin' ); ?></p>
                                <p><a href="/">Return to home page</a> or <a href="/blog/">visit our blog.</a></p>
                            </div><!-- .page-content -->
                        </div>
                    </div>
                </div>
			</section><!-- .error-404 -->

		</main><!-- #main -->

<?php
get_footer();
