<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package activewin
 */

$globalEmail = get_field('global_email','option');
$globalPhone = get_field('global_phone','option');
$globalFacebook = get_field('global_facebook','option');
$globalTwitter = get_field('global_twitter','option');
$globalTiktok = get_field('global_tik_tok','option');
$globalLinkedin = get_field('global_linkedin','option');
$globalOfficeAdd1 = get_field('global_office_1','option');
$globalOfficeAdd2 = get_field('global_office_2','option');
$globalOfficeMap1 = get_field('global_directions_1','option');
$globalOfficeMap2 = get_field('global_directions_2','option');
?>
<!-- Footer -->
<section id="footerSection">
    <div class="container">
        <div class="row">
            <!-- bg shape -->
            <img class="footer-active-shape" src="<?php echo get_template_directory_uri().'/img/logo-motif-blue.svg';?>" alt="logo-motif-blue"></a>
            <div class="col-12">
                <h2 class="footer-header">LIKE WHAT YOU SEE?</h2>
            </div>
            <!-- desktop column view -->
            <div class="col-12 col-md-6 col-lg-4 order-1 order-md-1 order-lg-1">
                <p class="footer-sub-header">Give us a call</p>
	            <?php $phoneReplace = str_replace(' ','', $globalPhone); ?>
                <a href="tel:<?php echo $phoneReplace;?>" class="footer-main-link"><?php echo $globalPhone;?></a>
            </div>
            <div class="col-12 col-md-6 col-lg-4 order-4 order-md-2 order-lg-4">
                <p class="footer-directions"><?php echo $globalOfficeAdd1; ?></p>
                <a href="<?php echo $globalOfficeMap1; ?>" class="footer-main-link exit-directions">Get
                    directions
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                         width="24" height="24" viewBox="0 0 24 24">
                        <defs>
                            <path id="c" d="M7.79 13.29c.39.39 1.02.39 1.41 0l3.59-3.59a.996.996 0 0 0 0-1.41L9.2 4.7a.996.996 0 1 0-1.41 1.41L9.67 8H1c-.55 0-1 .45-1 1s.45 1 1 1h8.67l-1.88 1.88c-.39.39-.38 1.03 0 1.41zM16 0H2a2 2 0 0 0-2 2v3c0 .55.45 1 1 1s1-.45 1-1V3c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1H3c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1v3c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2z" />
                        </defs>
                        <g fill="none" fill-rule="evenodd">
                            <path d="M0 0h24v24H0z" />
                            <g transform="translate(3 3)">
                                <mask id="d" fill="#fff">
                                    <use xlink:href="#c" />
                                </mask>
                                <use class="hoverFill" fill="#FF2E51" fill-rule="nonzero" xlink:href="#c" />
                                <g class="hoverFill" fill="#ff5757" mask="url(#d)">
                                    <path d="M-3-3h24v24H-3z" />
                                </g>
                            </g>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="col-12 col-md-6 col-lg-4 order-2 order-md-3 order-lg-2">
                <p class="footer-sub-header footer-col-pos">Send us an email</p>
                <a href="mailto:<?php echo $globalEmail;?>?subject=ActiveWin Website Request" class="footer-main-link footer-col-pos"><?php echo $globalEmail;?></a>
            </div>
<!--            <div class="col-12 col-md-6 col-lg-4 order-5 order-md-4 order-lg-5">-->
<!--                <p class="footer-directions">--><?php //echo $globalOfficeAdd2; ?><!--</p>-->
<!--                <a href="--><?php //echo $globalOfficeMap2; ?><!--" class="footer-main-link exit-directions">Get-->
<!--                    directions-->
<!--                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"-->
<!--                         width="24" height="24" viewBox="0 0 24 24">-->
<!--                        <defs>-->
<!--                            <path id="c2"-->
<!--                                  d="M7.79 13.29c.39.39 1.02.39 1.41 0l3.59-3.59a.996.996 0 0 0 0-1.41L9.2 4.7a.996.996 0 1 0-1.41 1.41L9.67 8H1c-.55 0-1 .45-1 1s.45 1 1 1h8.67l-1.88 1.88c-.39.39-.38 1.03 0 1.41zM16 0H2a2 2 0 0 0-2 2v3c0 .55.45 1 1 1s1-.45 1-1V3c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1H3c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1v3c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2z"/>-->
<!--                        </defs>-->
<!--                        <g fill="none" fill-rule="evenodd">-->
<!--                            <path d="M0 0h24v24H0z" />-->
<!--                            <g transform="translate(3 3)">-->
<!--                                <mask id="d2" fill="#fff">-->
<!--                                    <use xlink:href="#c2"/>-->
<!--                                </mask>-->
<!--                                <use class="hoverFill" fill="#FF2E51" fill-rule="nonzero" xlink:href="#c2"/>-->
<!--                                <g class="hoverFill" fill="#FF2E51" mask="url(#d2)">-->
<!--                                    <path d="M-3-3h24v24H-3z" />-->
<!--                                </g>-->
<!--                            </g>-->
<!--                        </g>-->
<!--                    </svg>-->
<!--                </a>-->
<!--            </div>-->
            <div class="col-12 col-md-6 col-lg-4 offset-md-6 offset-lg-0 order-6 order-md-7 order-lg-6 footer-social-desktop">
                <p class="footer-sub-header footer-col-pos3">Follow us on social</p>
                <div class="socialIcons footer-col-pos3">
                    <?php if($globalFacebook) : ?>
                    <a href="<?php echo $globalFacebook; ?>" target="_blank" rel="noreferrer"
                       aria-label="ActiveWin Facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <?php endif; ?>
                    <?php if($globalLinkedin) : ?>
                        <a href="<?php echo $globalLinkedin; ?>" target="_blank" rel="noreferrer"
                           aria-label="ActiveWin LinkedIn">
                            <i class="fab fa-linkedin-in"></i>

                        </a>
                    <?php endif; ?>
                    <?php if ($globalTwitter) : ?>
                        <a href="<?php echo $globalTwitter; ?>" target="_blank" rel="noreferrer"
                           aria-label="ActiveWin Twitter">
                            <i class="fab fa-twitter"></i>
                        </a>
                    <?php endif; ?>

                    <?php if ($globalTiktok) : ?>
                        <a href="<?php echo $globalTiktok; ?>" target="_blank" rel="noreferrer"
                           aria-label="ActiveWin Tik Tok">
                            <i class="fab fa-tiktok"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4 order-3 order-md-5 order-lg-3">
                <p class="footer-sub-header footer-col-pos2">Join us at ActiveWin</p>
                <a href="<?php echo esc_url(get_page_link(47)); ?>" class="footer-main-link footer-col-pos2">View latest
                    roles</a>
            </div>

            <!-- bottom of footer -->
            <div class="col-sm-12 col-md-6 col-lg-4 offset-lg-2 order-6 order-md-8 footer-links">
                <a href="/cookies-policy/" class="footer-small-link">Cookies</a>
                <a href="/privacy-policy/" class="footer-small-link">Privacy</a>
                <a href="/site-map/" class="footer-small-link">Site map</a>
            </div>
            <div class="col-sm-12 col-md-6 col-lg-6 order-7 footer-copyright">
                <img src="<?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-prolific-north.jpg'; ?>" srcset="<?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-prolific-north@2x.jpg'; ?> 2x, <?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-prolific-north@3x.jpg'; ?> 3x" alt="ISO 9001 British Assessment Bureau">
                <img src="<?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-microsoft.jpg'; ?>" srcset="<?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-microsoft@2x.jpg'; ?> 2x, <?php echo get_stylesheet_directory_uri().'/img/footer/logo-partner-microsoft@3x.jpg'; ?> 3x" alt="ISO 9001 British Assessment Bureau">
                <p>© <?php echo date("Y"); ?> ActiveWin Media</p>
            </div>
        </div>
    </div>
</section>
<!-- End Footer -->
</div><!-- #page -->
<script src="https://kit.fontawesome.com/5dd9b0e793.js" crossorigin="anonymous"></script>

<?php wp_footer(); ?>
<?php live_chat(); ?>
</body>
</html>
