<?php
/**
 * activewin functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package activewin
 */

if ( ! function_exists( 'activewin_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function activewin_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on activewin, use a find and replace
		 * to change 'activewin' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'activewin', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'activewin' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'activewin_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'width'       => 233,
			'flex-width'  => false,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'activewin_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function activewin_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'activewin_content_width', 640 );
}
add_action( 'after_setup_theme', 'activewin_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function activewin_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'activewin' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'activewin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'activewin_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function activewin_scripts() {
	wp_deregister_script( 'jquery' );

	wp_enqueue_script( 'activewin-jquery', get_template_directory_uri() . '/js/jquery-3.4.1.min.js', array(), null, true );

	/* wp_enqueue_script( 'activewin-navigation', get_template_directory_uri() . '/js/navigation.js', array( 'activewin-jquery' ), '20151215', true ); */

	wp_enqueue_script( 'activewin-bootstrap-bundle', get_template_directory_uri() . '/js/bootstrap.bundle.min.js', array( 'activewin-jquery' ), null, true );

	wp_enqueue_script( 'activewin-bootstrapjs', get_template_directory_uri() . '/js/bootstrap.min.js', array(), null, true );

	wp_enqueue_script( 'activewin-slick', get_template_directory_uri() . '/js/slick.min.js', array( 'activewin-jquery' ), null, true );

	wp_enqueue_script( 'activewin-lazy', get_template_directory_uri() . '/js/lazyload.min.js', array( 'activewin-jquery' ), null, true );

	wp_enqueue_script( 'activewin-script', get_template_directory_uri() . '/js/scripts.js', array( 'activewin-jquery' ), null, true );

	wp_localize_script('activewin-script', 'activewin_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));

	wp_enqueue_script( 'activewin-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

    wp_enqueue_style('activewin-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');

    wp_enqueue_style('activewin-bootstrapgrid', get_template_directory_uri() . '/css/bootstrap-grid.min.css');

    wp_enqueue_style('activewin-bootstrapreboot', get_template_directory_uri() . '/css/bootstrap-reboot.css');

    wp_enqueue_style('activewin-slick', get_template_directory_uri() . '/css/slick.css');

    wp_enqueue_style('activewin-style', get_stylesheet_uri() . "?v=1.0", null, true);


	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'activewin_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
/**
 * Register Custom Posts
 */
    require_once( get_template_directory() . '/inc/custom-posts.php' );
/**
 * Register Custom Blocks
 */
    require_once( get_template_directory() . '/inc/custom-blocks.php' );

function aw_acf_add_local_field_groups() {
include(get_template_directory().'/inc/custom-fields.php');
}
add_action('acf/init', 'aw_acf_add_local_field_groups');

function enqueue_lightbox() {
    wp_enqueue_style( 'activewin-lightbox', get_template_directory_uri().'/css/lity.min.css' );
    wp_enqueue_script( 'activewin-lightboxjs', get_template_directory_uri() . '/js/lity.min.js', array(), null, true );
}

function lightbox_load($id){
    if (get_field('video_lightbox', $id) && get_field('local_video',$id) != null){
        add_action( 'wp_enqueue_scripts', 'enqueue_lightbox' );
    }
}


function limit_excerpt($text, $limit) {
    if (str_word_count($text, 0) > $limit) {
        $words = str_word_count($text, 2);
        $pos = array_keys($words);
        $text = substr($text, 0, $pos[$limit]) . '...';
    }
    return $text;
}

add_post_type_support( 'page', 'excerpt' );
add_filter( 'get_custom_logo', 'change_logo_class' );


function change_logo_class( $html ) {
    $html = str_replace( 'custom-logo', 'activewin-logo', $html );
    return $html;
}

if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title' 	=> 'Theme General Settings',
        'menu_title'	=> 'Theme Settings',
        'menu_slug' 	=> 'theme-general-settings',
        'capability'	=> 'edit_posts',
        'redirect'		=> false
    ));
}

add_filter( 'render_block', function( $block_content, $block ) {
	// Target core/* and core-embed/* blocks.
	if ( preg_match( '~^core/|core-embed/~', $block['blockName'] ) ) {
		$block_content = sprintf( '<div class="container">%s</div>', $block_content );
	}
	return $block_content;
}, PHP_INT_MAX - 1, 2 );

add_action('wp_ajax_load_posts', 'load_posts');
add_action('wp_ajax_nopriv_load_posts', 'load_posts');
function load_posts() {
	check_ajax_referer('load_more_posts', 'security');
	$paged = $_POST['page'];

	if (is_home()) {
		$cat_id = 0;
	} else {
		$cat_id = $_POST[ 'cat' ];
    }

	if ($paged == 2){
		$offset = '11';
	} else if ($paged > 2){
		$offset = ($paged*6)-1 ;
	}
	$args = array(
		'post_type' => 'post',
		'post_status' => 'publish',
		'posts_per_page' => 6,
		'paged' => $paged,
		'offset' => $offset,
		'cat' => $cat_id,
		'orderby'   => 'date',
		'order'   => 'DESC'
	);
	$posts = new WP_Query( $args );
	if ( $posts->have_posts() ) :  ?>

		<?php while ( $posts->have_posts() ) : ?>

			<?php $posts->the_post(); ?>
            <?php $categories = get_the_category();
            $post_date = get_the_date( 'F j Y' );
            ?>
            <div class="col-12 col-md-12 col-lg-4">
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="row">
                        <div class="col-12 col-md-6 col-lg-12">
                            <a href="<?php echo esc_url( get_permalink() ); ?>">
                                <div class="zoom-wrap">
                                    <div class="blog-image-box" style="background-image:url('<?php echo get_the_post_thumbnail_url();?>');">
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="col-12 col-md-6 col-lg-12 blog-post-content">
							<?php if ( ! empty( $categories ) ) {
								$category_link = get_category_link( $categories[0]->term_id );
								echo '<a class="blog-post-link" href="'.esc_html( $category_link ).'" title="'.esc_html( $categories[0]->name ).'">'.esc_html( $categories[0]->name ).'</a>';
							} ?><p class="blog-post-date">&nbsp; <?php echo $post_date; ?></p>
                            <a class="blog-links" href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title();?>"><h3 class="blog-post-header"><?php the_title();?></h3></a>
                        </div>
                    </div>
                </div>
            </div>
		<?php endwhile; ?>
		<?php
		$current_page = $posts->get( 'paged' );
		if ( $current_page == ($posts->max_num_pages-1) ) {
		    echo '<div id="endPosts"></div>';
		}
	endif;
	wp_die();
}

function send_contact_form() {
	$globalEmail = get_field('global_email','option');
	$fname = $_POST['fname'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $org = $_POST['org'];
    $message = $_POST['message'];
    if ($_POST['team']) :
        $team = $_POST['team'];
    else :
	    $team = "";
    endif;

	if (!$org) :
        $organisation = "<span style=\"font-style:italic;\">left blank</span>";
	else :
		$organisation = $org;
	endif;

	if ($team != "") :
        $member = "<p style=\"margin: 0 0 10px;\">This form was sent by clicking through from $team's CTA</p>";
	else :
		$member = null;
	endif;

	date_default_timezone_set("Europe/London");
	$date = date("d/m/Y h:i:sa");

	$emailTo = $globalEmail;
	$subject = 'Contact form message from ActiveWin Website';
	$content = "<tr>
                <td style=\"background-color: #ffffff;\">
                    <table role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">
                        <tr>
                            <td style=\"padding: 20px; font-family: sans-serif; font-size: 15px; line-height: 20px; color: #555555;\">
                                <h1 style=\"margin: 0 0 10px; font-size: 25px; line-height: 30px; color: #333333; font-weight: normal;\">Website contact form message</h1>
                                <p style=\"margin: 0 0 10px;\">A user on the <a href=\"https://www.activewin.co.uk\" style=\"color:#ff5757; text-decoration:underline;\">ActiveWin website</a> has sent the following message:</p>
                                <ul style=\"padding: 0; margin: 0; list-style-type: disc;\">
									<li style=\"margin:0 0 10px 20px;\" class=\"list-item-first\">Name: $fname</li>
									<li style=\"margin:0 0 10px 20px;\">Email: <a href=\"mailto:$email\" style=\"color:#ff5757; text-decoration:underline;\">$email</a></li>
									<li style=\"margin:0 0 10px 20px;\">Phone: <a href=\"tel:$phone\" style=\"color:#ff5757; text-decoration:underline;\">$phone</a></li>									
									<li style=\"margin:0 0 10px 20px;\" class=\"list-item-last\">Organisation: $organisation</li>
								</ul>								
								<p style=\"margin: 25px 0 10px;font-weight:bold;\">Message:</p>
								<p style=\"margin: 0 0 10px 20px;\">$message</p>
								<hr style=\"margin-top:20px;\">								
								<p style=\"margin: 20px 0 10px;\">This contact form was submitted at $date</p>
								$member
                            </td>
                        </tr>
                        <tr>
                            <td style=\"padding: 0 20px 20px;\">
                                <!-- Button : BEGIN -->
                                <table align=\"center\" role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"margin: auto;\">
                                    <tr>
                                        <td class=\"button-td button-td-primary\" style=\"border-radius: 4px; background: #ff5757;\">
											<a class=\"button-a button-a-primary\" href=\"mailto:$email\" style=\"background: #ff5757; border: 1px solid #ff5757; font-family: sans-serif; font-size: 15px; line-height: 15px; text-decoration: none; padding: 13px 50px; color: #ffffff; display: block; border-radius: 4px;\">Reply</a>
										</td>
                                    </tr>
                                </table>
                                <!-- Button : END -->
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>";
	$image = get_field('contact_form_email_header_image','option');
	$image = $image['url'];
	$attachments = "";
	send_email($image,$subject, $content, $emailTo, $attachments);

}

add_action( 'wp_ajax_send_contact_form', 'send_contact_form' );
add_action( 'wp_ajax_nopriv_send_contact_form', 'send_contact_form' );

function send_ppc_form() {
	$globalEmail = get_field('global_email','option');
    $fname = $_POST['fname'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $org = $_POST['org'];
    $url = $_POST['url'];
    $adSpend = $_POST['adSpend'];
    $message = $_POST['message'];
    /* $googleAds = $_POST['googleAds'];
    $googleAnalytics = $_POST['googleAnalytics']; */

	if (!$org) :
		$organisation = "<span style=\"font-style:italic;\">left blank</span>";
	else :
		$organisation = $org;
	endif;

	date_default_timezone_set("Europe/London");
	$date = date("d/m/Y h:i:sa");
	$emailTo = $globalEmail;
	$image = get_field('ppc_audit_email_header_image','option');
	$image = $image['url'];

	$content = "<tr>
                <td style=\"background-color: #ffffff;\">
                    <table role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">
                        <tr>
                            <td style=\"padding: 20px; font-family: sans-serif; font-size: 15px; line-height: 20px; color: #555555;\">
                                <h1 style=\"margin: 0 0 10px; font-size: 25px; line-height: 30px; color: #333333; font-weight: normal;\">PPC Audit Request</h1>
                                <p style=\"margin: 0 0 10px;\">A user on the <a href=\"https://www.activewin.co.uk\" style=\"color:#ff5757; text-decoration:underline;\">ActiveWin website</a> has sent the following information for a PPC audit:</p>
                                <ul style=\"padding: 0; margin: 0; list-style-type: disc;\">
									<li style=\"margin:0 0 10px 20px;\" class=\"list-item-first\">Name: $fname</li>
									<li style=\"margin:0 0 10px 20px;\">Email: <a href=\"mailto:$email\" style=\"color:#ff5757; text-decoration:underline;\">$email</a></li>
									<li style=\"margin:0 0 10px 20px;\">Phone: <a href=\"tel:$phone\" style=\"color:#ff5757; text-decoration:underline;\">$phone</a></li>
									<li style=\"margin:0 0 10px 20px;\">URL: <a href=\"$url\" style=\"color:#ff5757; text-decoration:underline;\">$url</a></li>
									<li style=\"margin:0 0 10px 20px;\">Monthly Ad spend: $adSpend</li>
									"/*<li style=\"margin:0 0 10px 20px;\">Google Ads access: $googleAds</li>
									<li style=\"margin:0 0 10px 20px;\">Google Analytics access: $googleAnalytics</li>*/
									."<li style=\"margin:0 0 10px 20px;\" class=\"list-item-last\">Organisation: $organisation</li>		
								</ul>								
								<p style=\"margin: 25px 0 10px;font-weight:bold;\">Message:</p>
								<p style=\"margin: 0 0 10px 20px;\">$message</p>
								<hr style=\"margin-top:20px;\">								
								<p style=\"margin: 20px 0 10px;\">This PPC audit form was submitted at $date</p>								
                            </td>
                        </tr>
                        <tr>
                            <td style=\"padding: 0 20px 20px;\">
                                <!-- Button : BEGIN -->
                                <table align=\"center\" role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"margin: auto;\">
                                    <tr>
                                        <td class=\"button-td button-td-primary\" style=\"border-radius: 4px; background: #ff5757;\">
											<a class=\"button-a button-a-primary\" href=\"mailto:$email\" style=\"background: #ff5757; border: 1px solid #ff5757; font-family: sans-serif; font-size: 15px; line-height: 15px; text-decoration: none; padding: 13px 50px; color: #ffffff; display: block; border-radius: 4px;\">Reply</a>
										</td>
                                    </tr>
                                </table>
                                <!-- Button : END -->
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>";
	$subject = 'PPC Audit Request from the ActiveWin Website';
	$attachments = "";
	send_email($image,$subject, $content, $emailTo, $attachments);

}

add_action( 'wp_ajax_send_ppc_form', 'send_ppc_form' );
add_action( 'wp_ajax_nopriv_send_ppc_form', 'send_ppc_form' );

function send_brochure_form() {
	$globalEmail = get_field('global_email','option');
    $email = $_POST['email'];
	date_default_timezone_set("Europe/London");
	$date = date("d/m/Y h:i:sa");

	$headers = array(
		'Content-Type: text/html; charset=UTF-8',
		'From: ActiveWin Website <website@activewin.co.uk>',
		'BCC : '
	);

	$emailTo = $globalEmail;
	$subject = 'ActiveWin Website Brochure Request';
	$message = "ActiveWin Website Brochure Request for $email<br><br>Requested on $date";
	wp_mail($emailTo, $subject, $message, $headers);
}

add_action( 'wp_ajax_send_brochure_form', 'send_brochure_form' );
add_action( 'wp_ajax_nopriv_send_brochure_form', 'send_brochure_form' );

function send_application_form() {
	$globalJobs = get_field('global_jobs','option');
    $name = $_POST['fname'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $salary = $_POST['salary'];
    $additionalInfo = $_POST['additionalInfo'];
    if ($_POST['futureJobs']) :
        $futureJobs = $_POST['futureJobs'];
    else :
	    $futureJobs = null;
    endif;
    $position = $_POST['position'];
    $positionUrl = $_POST['job-link'];
	$uploadedfile = $_FILES['cv'];
	date_default_timezone_set("Europe/London");
	$date = date("d/m/Y h:i:sa");

		if (!function_exists('wp_handle_upload')) {
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}
		$upload_overrides = array('test_form' => false);
		$movefile = wp_handle_upload($uploadedfile, $upload_overrides);
		$attachments = $movefile['file'];

	$emailTo = $globalJobs;
	$subject = "Application for $position from the ActiveWin Website";
	$image = get_field('career_email_header_image','option');
	$image = $image['url'];
    if ($futureJobs) :
        if ($futureJobs != null && $futureJobs === "Contact me for future jobs") :
            $futureJob = "<li style=\"margin:0 0 10px 20px;\">Please do contact me regarding alternative roles in the future</li>";
        else :
            $futureJob = null;
        endif;
    else:
	    $futureJob = null;
    endif;

	$content = "<tr>
                <td style=\"background-color: #ffffff;\">
                    <table role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">
                        <tr>
                            <td style=\"padding: 20px; font-family: sans-serif; font-size: 15px; line-height: 20px; color: #555555;\">
                                <h1 style=\"margin: 0 0 10px; font-size: 25px; line-height: 30px; color: #333333; font-weight: normal;\">Career Application for $position</h1>
                                <p style=\"margin: 0 0 10px;\">A user on the <a href=\"https://www.activewin.co.uk\" style=\"color:#ff5757; text-decoration:underline;\">ActiveWin website</a> has submitted the following career application:</p>
                                <ul style=\"padding: 0; margin: 0; list-style-type: disc;\">
									<li style=\"margin:0 0 10px 20px;\" class=\"list-item-first\">Name: $name</li>
									<li style=\"margin:0 0 10px 20px;\">Email: <a href=\"mailto:$email\" style=\"color:#ff5757; text-decoration:underline;\">$email</a></li>
									<li style=\"margin:0 0 10px 20px;\">Phone: <a href=\"tel:$phone\" style=\"color:#ff5757; text-decoration:underline;\">$phone</a></li>
									<li style=\"margin:0 0 10px 20px;\">Salary expectation: $salary</li>
									<li style=\"margin:0 0 10px 20px;\">Additional Information: $additionalInfo</li>
									$futureJob
									<li style=\"margin:0 0 10px 20px;\" class=\"list-item-last\">Position: <a href=\"$positionUrl\" style=\"color:#ff5757; text-decoration:underline;\">$position</a></li>									
								</ul>								
								<hr style=\"margin-top:20px;\">								
								<p style=\"margin: 20px 0 10px;\">This career application form was submitted at $date</p>								
                            </td>
                        </tr>
                        <tr>
                            <td style=\"padding: 0 20px 20px;\">
                                <!-- Button : BEGIN -->
                                <table align=\"center\" role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"margin: auto;\">
                                    <tr>
                                        <td class=\"button-td button-td-primary\" style=\"border-radius: 4px; background: #ff5757;\">
											<a class=\"button-a button-a-primary\" href=\"mailto:$email\" style=\"background: #ff5757; border: 1px solid #ff5757; font-family: sans-serif; font-size: 15px; line-height: 15px; text-decoration: none; padding: 13px 50px; color: #ffffff; display: block; border-radius: 4px;\">Reply</a>
										</td>
                                    </tr>
                                </table>
                                <!-- Button : END -->
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>";

	send_email($image,$subject, $content, $emailTo, $attachments);
	unlink($movefile['file']);
}
add_action( 'wp_ajax_send_application_form', 'send_application_form' );
add_action( 'wp_ajax_nopriv_send_application_form', 'send_application_form' );

function remove_active_class($class) {
	return ( $class == 'current_page_parent' ) ? FALSE : TRUE;
}

function add_class_to_wp_nav_menu($classes) {

	if( is_singular( 'careers' ) ) {
		$classes = array_filter( $classes, 'remove_active_class' );
		if( in_array( 'menu-item-53', $classes) ) {
			$classes[] = 'current_page_parent';
		}
	}

	if( is_singular( 'case_study' ) ) {
		$classes = array_filter( $classes, 'remove_active_class' );
		if( in_array( 'menu-item-49', $classes) ) {
			$classes[] = 'current_page_parent';
		}
	}

	if( is_post_type_archive( 'case_study' )) {
		$classes = array_filter( $classes, 'remove_active_class' );
		if( in_array( 'menu-item-5731', $classes) ) {
			$classes[] = 'current_page_parent';
		}
	}

	if( is_tax( 'case_study_categories' )) {
		$classes = array_filter( $classes, 'remove_active_class' );
		if( in_array( 'menu-item-5731', $classes) ) {
			$classes[] = 'current_page_parent';
		}
	}


	return $classes;
}
add_filter('nav_menu_css_class', 'add_class_to_wp_nav_menu');


function header_fav_meta() {
    ?>
    <link rel="icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/favicon.ico" />
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/favicon-16x16.png">
    <link rel="manifest" href="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo get_stylesheet_directory_uri(); ?>/img/icons/ms-icon-144x144.png">
    <meta name="theme-color" content="#002933">
    <script>(function (e, t, n) {
            var r = e.querySelectorAll("html")[0];
            r.className = r.className.replace(/(^|\s)no-js(\s|$)/, "$1js$2")
        })(document, window, 0);</script>
    <!-- Facebook Pixel Code -->
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '2623228407898733');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
                   src="https://www.facebook.com/tr?id=2623228407898733&ev=PageView&noscript=1"
        /></noscript>
    <!-- End Facebook Pixel Code -->
	<?php
}
add_action('wp_head', 'header_fav_meta');

function pre_connect() {
	echo '<link rel="preconnect" href="https://www.google-analytics.com">';
	echo '<link rel="preconnect" href="https://www.google.com">';
	echo '<link rel="preconnect" href="https://www.google.co.uk">';
	echo '<link rel="preconnect" href="https://googleads.g.doubleclick.net">';
	echo '<link rel="preconnect" href="https://www.googletagmanager.com">';
	echo '<link rel="preconnect" href="https://www.googleadservices.com">';
	echo '<link rel="preconnect" href="https://www.gstatic.com">';
}

add_action( 'wp_head', 'pre_connect' );

function tracking_codes() {
    $gtm = get_field('tracking_gtm','option');
    echo $gtm;
}
add_action('wp_head', 'tracking_codes');

function live_chat() {
	echo get_field( 'live_chat_gtm', 'option' );
}

//add_action( 'wp_footer', 'live_chat', 10 );

// Move Yoast to bottom
function yoasttobottom() {
	return 'low';
}
add_filter( 'wpseo_metabox_prio', 'yoasttobottom');

function send_email($image, $subject, $message, $to, $attachments){
	$logo = get_field( 'contact_form_email_logo', 'option' );
	$logo = $logo['url'];
	$msgHeader = '<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
    <meta charset="utf-8"> <!-- utf-8 works for most cases -->
    <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn\'t be necessary -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
    <meta name="x-apple-disable-message-reformatting">  <!-- Disable auto-scale in iOS 10 Mail entirely -->
    <meta name="format-detection" content="telephone=no,address=no,email=no,date=no,url=no"> <!-- Tell iOS not to automatically link certain text strings. -->
    <title></title> <!-- The title tag shows in email notifications, like Android 4.4. -->

    <!-- Desktop Outlook chokes on web font references and defaults to Times New Roman, so we force a safe fallback font. -->
    <!--[if mso]>
        <style>
            * {
                font-family: sans-serif !important;
            }
        </style>
    <![endif]-->
    <!-- CSS Reset : BEGIN -->
    <style>
        html,
        body {
            margin: 0 auto !important;
            padding: 0 !important;
            height: 100% !important;
            width: 100% !important;
        }

        * {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        div[style*="margin: 16px 0"] {
            margin: 0 !important;
        }

        #MessageViewBody, #MessageWebViewDiv{
            width: 100% !important;
        }

        table,
        td {
            mso-table-lspace: 0pt !important;
            mso-table-rspace: 0pt !important;
        }

        th {
        	font-weight: normal;
        }

        table {
            border-spacing: 0 !important;
            border-collapse: collapse !important;
            table-layout: fixed !important;
            margin: 0 auto !important;
        }

        a {
            text-decoration: none;
        }

        img {
            -ms-interpolation-mode:bicubic;
        }

        a[x-apple-data-detectors],  /* iOS */
        .unstyle-auto-detected-links a,
        .aBn {
            border-bottom: 0 !important;
            cursor: default !important;
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        .im {
            color: inherit !important;
        }

        .a6S {
           display: none !important;
           opacity: 0.01 !important;
		}
		img.g-img + div {
		   display: none !important;
		}

        @media only screen and (min-device-width: 320px) and (max-device-width: 374px) {
            u ~ div .email-container {
                min-width: 320px !important;
            }
        }
        @media only screen and (min-device-width: 375px) and (max-device-width: 413px) {
            u ~ div .email-container {
                min-width: 375px !important;
            }
        }
        @media only screen and (min-device-width: 414px) {
            u ~ div .email-container {
                min-width: 414px !important;
            }
        }

    </style>

    <!--[if gte mso 9]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->

    <!-- CSS Reset : END -->
    <style>

        .button-td,
        .button-a {
            transition: all 100ms ease-in;
        }
	    .button-td-primary:hover,
	    .button-a-primary:hover {
	        background: #ad0e28 !important;
	        border-color: #ad0e28 !important;
	    }

        @media screen and (max-width: 600px) {

            .email-container {
                width: 100% !important;
                margin: auto !important;
            }

            .stack-column,
            .stack-column-center {
                display: block !important;
                width: 100% !important;
                max-width: 100% !important;
                direction: ltr !important;
            }
            .stack-column-center {
                text-align: center !important;
            }

            .center-on-narrow {
                text-align: center !important;
                display: block !important;
                margin-left: auto !important;
                margin-right: auto !important;
                float: none !important;
            }
            table.center-on-narrow {
                display: inline-block !important;
            }

            .email-container p {
                font-size: 17px !important;
            }
        }

    </style>

</head>
<body width="100%" style="margin: 0; padding: 0 !important; mso-line-height-rule: exactly; background-color: #002933;">
	<center style="width: 100%; background-color: #002933;">
    <!--[if mso | IE]>
    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%" style="background-color: #002933;">
    <tr>
    <td>
    <![endif]-->
        <div style="display: none; font-size: 1px; line-height: 1px; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden; mso-hide: all; font-family: sans-serif;">
            &zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;
        </div>
        

        <!-- Email Body : BEGIN -->
        <table align="center" role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" style="margin: auto;" class="email-container">
	        <!-- Email Header : BEGIN -->
            <tr>
                <td style="padding: 20px 0; text-align: center">
                    <img src="'.$logo.'" width="468" height="85" alt="alt_text" border="0" style="height: auto; font-family: sans-serif; font-size: 15px; line-height: 15px; color: #555555;">
                </td>
            </tr>
	        <!-- Email Header : END -->

            <!-- Hero Image, Flush : BEGIN -->
            <tr>
                <td style="background-color: #ffffff;">
                    <img src="'.$image.'" width="600" height="" alt="alt_text" border="0" style="width: 100%; max-width: 600px; height: auto; font-family: sans-serif; font-size: 15px; line-height: 15px; color: #555555; margin: auto; display: block;" class="g-img">
                </td>
            </tr>
            <!-- Hero Image, Flush : END -->';

    $msgFooter = '<tr>
                <!-- Bulletproof Background Images c/o https://backgrounds.cm -->
                <td valign="middle" style="text-align: center; background-color: #ff5757;">
	                <div>
	                    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
	                        <tr>
	                            <td valign="middle" style="text-align: center; padding: 40px; font-family: sans-serif; font-size: 15px; line-height: 20px; color: #ffffff;">
	                                <p style="margin: 0;">This email was automatically generated from a user of the ActiveWin website submitting a form.</p>
	                            </td>
	                        </tr>
	                    </table>
	                </div>
	                <!--[if gte mso 9]>
	                </v:textbox>
	                </v:rect>
	                <![endif]-->
	            </td>
	        </tr>
	        <!-- Background Image with Text : END -->
	    </table>
	    <!-- Email Body : END -->
	    <!-- Email Footer : BEGIN -->
        <table align="center" role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" style="margin: auto;" class="email-container">
	        <tr>
	            <td style="padding: 20px; font-family: sans-serif; font-size: 12px; line-height: 15px; text-align: center; color: #888888;">
	                <br><br>
	                ActiveWin Media<br><span class="unstyle-auto-detected-links">72-76 Cross Street, Manchester, M2 4JG<br>0161 359 3593</span>
	                <br><br>	                
	            </td>
	        </tr>
	    </table>
	    <!-- Email Footer : END -->
    <!--[if mso | IE]>
    </td>
    </tr>
    </table>
    <![endif]-->
    </center>
</body>
</html>';

	$headers = array(
		'Content-Type: text/html; charset=UTF-8',
		'From: ActiveWin Website <website@activewin.co.uk>',
		'BCC : '
	);

    $msgEmail = $msgHeader.$message.$msgFooter;
	wp_mail($to, $subject, $msgEmail, $headers, $attachments);

}

remove_action( 'wp_head', 'rsd_link' );
function aw_remove_version() {
	return '';
}

add_filter( 'the_generator', 'aw_remove_version' );
remove_action( 'wp_head', 'wlwmanifest_link' );
remove_action( 'wp_head', 'wp_shortlink_wp_head' );
function aw_cleanup_query_string( $src ) {
	$parts = explode( '?', $src );

	return $parts[0];
}

add_filter( 'script_loader_src', 'aw_cleanup_query_string', 15, 1 );
add_filter( 'style_loader_src', 'aw_cleanup_query_string', 15, 1 );
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
remove_action( 'template_redirect', 'rest_output_link_header', 11, 0 );

function disable_emojis() {
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );

	// Remove from TinyMCE
	add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
}

add_action( 'init', 'disable_emojis' );

/**
 * Filter out the tinymce emoji plugin.
 */
function disable_emojis_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

/* Disable Search */
function fb_filter_query( $query, $error = true ) {

	if ( is_search() ) {
		$query->is_search       = false;
		$query->query_vars[ 's' ] = false;
		$query->query[ 's' ]      = false;

// to error
		if ( $error == true ) {
			$query->is_404 = true;
		}
	}
}

add_action( 'parse_query', 'fb_filter_query' );
add_filter( 'xmlrpc_enabled', '__return_false' );