<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

    <?php lightbox_load(get_the_id());?>
	<?php wp_head(); ?>
	<?php if (is_home()) :
		$og = get_field('hero_image', get_option('page_for_posts'));
        if ($og != null) :
            $og = $og['url'];
        endif;
		if (!$og) :
			$og = get_the_post_thumbnail_url();
		endif;
		if (!$og) :
			$og = get_field('global_op_image','option');
            if ($og != null) :
                $og = $og['url'];
            endif;
		endif;
    elseif (is_single()) :
		$og = get_field('hero_image');
        if ($og != null) :
            $og = $og['url'];
        endif;
		if (!$og) :
			$og = get_the_post_thumbnail_url();
		endif;
		if (!$og) :
			$og = get_field('global_op_image','option');
            if ($og != null) :
                $og = $og['url'];
            endif;
		endif;
    elseif (is_archive()) :
		$term = get_queried_object();
		$og = get_field('category_image', $term);
        if ($og != null) :
            $og = $og['url'];
        endif;
		if (!$og) :
			$og = get_field('global_op_image','option');
            if ($og != null) :
                $og = $og['url'];
            endif;
		endif;
	else :
		$og = get_field('hero_image');
        if ($og != null) :
            $og = $og['url'];
        endif;
		if (!$og) :
			$og = get_the_post_thumbnail_url();
		endif;
		if (!$og) :
			$og = get_field('global_op_image','option');
            if ($og != null) :
                $og = $og['url'];
            endif;
		endif;
	endif;
	?>
    <meta property="og:image" content="<?php echo $og;?>" />
</head>
<?php
/* Gather globals and hero info */
$globalEmail = get_field('global_email','option');
$globalPhone = get_field('global_phone','option');
$globalFacebook = get_field('global_facebook','option');
$globalTwitter = get_field('global_twitter','option');
$globalLinkedin = get_field('global_linkedin','option');
$slideDirection = get_field('slide_direction');

$hero = get_field('hero_image',get_the_ID());
if ($hero) :
    $hero = $hero['url'];
endif;
$intro = get_field('intro_text');
    if ($slideDirection) :
        $slideID = "heroSlider".ucfirst($slideDirection);
    else :
        $slideID = "heroSliderLeft";
        $slideDirection = "left";
    endif;

$custom_logo_id = get_theme_mod('custom_logo');
$image = wp_get_attachment_image_src($custom_logo_id, 'full');
?>
<body <?php body_class(); ?>>
    <!-- Preloader -->
    <div id="load">
        <div id="contents"></div>
        <div id="loading-text"></div>
    </div>
<div id="wrap">
    <header class="contact-page">
    <div class="bg-slider-new-top"></div>

        <div id="heroImgBg" class="hero-image-contact" style="background-image: url('<?php echo get_template_directory_uri().'/img/img-hero-home-1920@2x.jpg'; ?>');"></div>
		<nav>
            <div class="container navigation">
                <div class="Nav">
                    <?php the_custom_logo(); ?>
                    <div id="navLinks">
                        <a href="<?php echo get_home_url(); ?>" aria-label="Activewin Homepage">
                            <img class="mobileLogo activewin-logo" src="<?php echo $image[0];?>"
                                 alt="ActiveWin Media">
                        </a>
                        <div href="javascript:void(0)" class="closebtnMobile">
                            <img src="<?php echo get_template_directory_uri() . '/img/close.svg'; ?>" alt="Close menu">
                        </div>
                            <?php
                            wp_nav_menu( array(
                                'theme_location' => 'menu-1',
                                'menu_id'        => 'desktopNav',
                                'menu_class'     => 'homepageNav',
                                'container'      => '',
                            ) );
                            ?>
                        <div class="navContactContainer">
                            <div class="navContact">
                                <p>Give us call</p>
	                            <?php $phoneReplace = str_replace(' ','', $globalPhone); ?>
                                <a href="tel:<?php echo $phoneReplace; ?>" title="call us <?php echo $globalPhone; ?>"><?php echo $globalPhone; ?></a>
                            </div>
                            <div class="navContact">
                                <p>Send us an email</p>
                                <a href="mailto:<?php echo $globalEmail; ?>?subject=ActiveWin Website Request" title="<?php echo $globalEmail; ?>"><?php echo $globalEmail; ?></a>
                            </div>
<!--                            <div class="navContact">-->
<!--                                <p>Follow us on social</p>-->
<!--                                <div class="socialIcons">-->
<!--                                    <a href="--><?php //echo $globalFacebook; ?><!--" target="_blank" rel="noreferrer"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/facebook.svg'; ?><!--"-->
<!--                                                alt="facebook"></a>-->
<!--                                    <a href="--><?php //echo $globalLinkedin; ?><!--" target="_blank" rel="noreferrer"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/linkedin.svg'; ?><!--"-->
<!--                                                alt="linkedIn"></a>-->
<!--                                    <a href="--><?php //echo $globalTwitter; ?><!--" target="_blank" rel="noreferrer"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/twitter.svg'; ?><!--"-->
<!--                                                alt="twitter"></a>-->
<!--                                </div>-->
<!--                            </div>-->
                        </div>
                    </div>
                    <div class="burger">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="48"
                             height="48" viewBox="0 0 48 48">
                            <defs>
                                <path id="a" d="M2 24h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zm0-10h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zM0 2c0 1.1.9 2 2 2h32c1.1 0 2-.9 2-2s-.9-2-2-2H2C.9 0 0 .9 0 2z" />
                            </defs>
                            <g fill="none" fill-rule="evenodd">
                                <path d="M0 0h48v48H0z" />
                                <g transform="translate(6 12)">
                                    <mask id="b" fill="#fff">
                                        <use xlink:href="#a" />
                                    </mask>
                                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#a" />
                                    <g fill="#FFF" mask="url(#b)">
                                        <path d="M-6-12h48v48H-6z" />
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
		</nav><!-- #site-navigation -->
        <div id="hero">
            <div class="container">
                <h1>404</h1>
                <p>Page not found</p>
            </div>
        </div>
	</header><!-- #masthead -->
