<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package activewin
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
    <?php lightbox_load(get_the_id());?>
	<?php wp_head(); ?>

    <?php
            $og = get_field('hero_image');
	        $og = $og['url'];
            if (!$og) :
                $og = get_the_post_thumbnail_url();
            endif;
            if (!$og) :
	            $og = get_field('global_op_image','option');
	            $og = $og['url'];
            endif;
	?>
    <meta property="og:image" content="<?php echo $og;?>" />

</head>
<?php
/* Gather globals and hero info */
$globalEmail = get_field('global_email','option');
$globalPhone = get_field('global_phone','option');
$globalFacebook = get_field('global_facebook','option');
$globalTwitter = get_field('global_twitter','option');
$globalLinkedin = get_field('global_linkedin','option');
$slideDirection = get_field('slide_direction');
$heroShapes = get_field('hero_shapes');
$backgroundColor = get_field('header_background');
    if ($slideDirection) :
        $slideID = "heroSlider".ucfirst($slideDirection);
    else :
        $slideID = "heroSliderLeft";
        $slideDirection = "left";
    endif;

        $hero = get_field('hero_image');
        $hero = $hero['url'];
	    $mobilehero = get_field('hero_image_mobile');
	    $mobilehero = $mobilehero['url'];

        $heroVideo = get_field('video_header');  // returns an array if a file is set
        $heroVideoUrl = $heroVideo['url'] ?? ''; // safely get the URL if it exists

        $title = get_field('page_title');
        $intro = get_field('intro_text');
        $primaryCTA = get_field('primary_cta');
        $secondaryCTA = get_field('secondary_cta');
        if (!get_field('secondary_cta') || get_field('video_lightbox')) :
            if (get_field('local_video')) :
                $video = get_field('local_video');
            elseif (get_field('hosted_video')) :
                $video = get_field('hosted_video');
            else :
                $video = null;
            endif;
        endif;
$custom_logo_id = get_theme_mod('custom_logo');
$image = wp_get_attachment_image_src($custom_logo_id, 'full');
?>
<body <?php body_class(); ?>>
    <!-- Preloader -->
    <div id="load">
        <div id="contents"></div>
        <div id="loading-text"></div>
    </div>
    <div <?php if ( is_single() ): echo 'itemscope itemtype="http://schema.org/Article"'; endif; ?>id="wrap">
    <header>
        <div class="bg-slider-new-left"></div>
        <?php if ( ! $heroVideoUrl ) : ?>
            <style>
                <?php if ( $hero ) : ?>
                .hero-image-home {
                    background-image: url('<?php echo esc_url($hero); ?>');
                }
                <?php endif; ?>

                <?php if ( $mobilehero ) : ?>
                @media (max-width: 1023px) {
                    .hero-image-home {
                        background-image: url('<?php echo esc_url($mobilehero); ?>');
                    }
                }
                <?php endif; ?>

                <?php if ( $backgroundColor ) : ?>
                #heroImgBg {
                    background-blend-mode: unset !important;
                }
                <?php endif; ?>
            </style>
        <?php endif; ?>

        <?php
        // ========== HERO BACKGROUND OUTPUT ==========

        // If we have a hero video, output <video>:
        if ( $heroVideoUrl ) : ?>
            <div id="heroVideoBg" class="hero-video-container">
                <video
                        autoplay
                        muted
                        loop
                        playsinline
                        poster="<?php echo esc_url($hero); /* fallback poster image */ ?>"
                >
                    <source src="<?php echo esc_url($heroVideoUrl); ?>" type="video/mp4" />
                    <!-- Fallback text / alternate source goes here -->
                </video>
            </div>

        <?php
        // Otherwise, use existing background image markup:
        else : ?>
            <div id="heroImgBg" class="hero-image-home">
                <meta itemprop="image" content="<?php echo esc_url($hero); ?>">
            </div>
        <?php endif; ?>
        <!-- / End Hero Background -->
        <?php if ($heroShapes):
            switch($heroShapes) {
                case "floating" :
                    echo '<div id="heroShapes">';
	                    echo '<img class="careers-arrow-up" src="'.get_template_directory_uri().'/img/careers-full-arrow.svg" alt="full-arrow">';
	                    echo '<img class="careers-halfarrow-up" src="'.get_template_directory_uri().'/img/careers-half-arrow.svg" alt="half-arrow">';
	                echo '</div>';
	                break;
                case "triangles" :
	                echo '<div id="heroShapes">';
	                    echo '<img class="arrow-up-hero" src="'.get_template_directory_uri().'/img/red-arrow.svg" alt="full-arrow">';
	                    echo '<img class="halfarrow-up-hero" src="'.get_template_directory_uri().'/img/half-arrow.svg" alt="half-arrow">';
	                echo '</div>';
	                break;
                case "chevron" :
	                echo '<div id="heroShapes">';
	                    echo '<img class="services-red-shape" src="'.get_template_directory_uri().'/img/services-half-arrow.svg" alt="half-arrow">';
	                    echo '<img class="services-white-shape" src="'.get_template_directory_uri().'/img/contact-white-diamond.svg" alt="white-arrow">';
	                echo '</div>';
	                break;
                case "largechev" :
	                echo '<div id="heroShapes">';
	                    echo '<img class="blog-arrow-up" src="'.get_template_directory_uri().'/img/blog-arrow.svg" alt="full-arrow">';
	                    echo '<img class="blog-halfarrow-up" src="'.get_template_directory_uri().'/img/blog-halfarrow.svg" alt="half-arrow">';
	                echo '</div>';
	                break;
                case "corners" :
	                echo '<div id="heroShapes">';
	                    echo '<img class="about-red-shape" src="'.get_template_directory_uri().'/img/red-angled-shape.svg" alt="red-angle">';
	                    echo '<img class="about-white-shape" src="'.get_template_directory_uri().'/img/triangle.svg" alt="white-angle">';
	                echo '</div>';
	                break;
                case "box" :
	                echo '<div id="heroShapes">';
	                    echo '<img class="hero-white-shape" src="'.get_template_directory_uri().'/img/contact-white-diamond.svg" alt="white diamond">';
	                    echo '<img class="hero-red-shape" src="'.get_template_directory_uri().'/img/contact-red-shape.svg" alt="red shape">';
	                echo '</div>';
	                break;
                default :
            }
        endif; ?>
		<nav>
            <div class="container navigation">
                <div class="Nav">
                    <?php the_custom_logo(); ?>
                    <div id="navLinks">
                        <a href="<?php echo get_home_url(); ?>" aria-label="Activewin Homepage">
                            <img class="mobileLogo activewin-logo" src="<?php echo $image[0];?>"
                                 alt="ActiveWin Media">
                        </a>
                        <div href="javascript:void(0)" class="closebtnMobile">
                            <img src="<?php echo get_template_directory_uri() . '/img/close.svg'; ?>" alt="Close menu">
                        </div>
                            <?php
                            wp_nav_menu( array(
                                'theme_location' => 'menu-1',
                                'menu_id'        => 'desktopNav',
                                'menu_class'     => 'homepageNav',
                                'container'      => '',
                            ) );
                            ?>
                        <div class="navContactContainer">
                            <div class="navContact">
                                <p>Give us call</p>
	                            <?php $phoneReplace = str_replace(' ','', $globalPhone); ?>
                                <a href="tel:<?php echo $phoneReplace; ?>" title="call us <?php echo $globalPhone; ?>"><?php echo $globalPhone; ?></a>
                            </div>
                            <div class="navContact">
                                <p>Send us an email</p>
                                <a href="mailto:<?php echo $globalEmail; ?>?subject=ActiveWin Website Request" title="<?php echo $globalEmail; ?>"><?php echo $globalEmail; ?></a>
                            </div>
<!--                            <div class="navContact">-->
<!--                                <p>Follow us on social</p>-->
<!--                                <div class="socialIcons">-->
<!--                                    <a href="--><?php //echo $globalFacebook; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin Facebook"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/facebook.svg'; ?><!--"-->
<!--                                                alt="facebook"></a>-->
<!--                                    <a href="--><?php //echo $globalLinkedin; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin LinkedIn"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/linkedin.svg'; ?><!--"-->
<!--                                                alt="linkedIn"></a>-->
<!--                                    <a href="--><?php //echo $globalTwitter; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin Twitter"><img-->
<!--                                                src="--><?php //echo get_template_directory_uri() . '/img/twitter.svg'; ?><!--"-->
<!--                                                alt="twitter"></a>-->
<!--                                </div>-->
<!--                            </div>-->
                        </div>
                    </div>
                    <div class="burger">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="48"
                             height="48" viewBox="0 0 48 48">
                            <defs>
                                <path id="a" d="M2 24h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zm0-10h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zM0 2c0 1.1.9 2 2 2h32c1.1 0 2-.9 2-2s-.9-2-2-2H2C.9 0 0 .9 0 2z" />
                            </defs>
                            <g fill="none" fill-rule="evenodd">
                                <path d="M0 0h48v48H0z" />
                                <g transform="translate(6 12)">
                                    <mask id="b" fill="#fff">
                                        <use xlink:href="#a" />
                                    </mask>
                                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#a" />
                                    <g fill="#FFF" mask="url(#b)">
                                        <path d="M-6-12h48v48H-6z" />
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
		</nav><!-- #site-navigation -->
        <div id="hero" class="homepage-hero">
            <div class="container">
                    <?php
                    if ($title) :
	                    echo "<h1 itemprop=\"name mainEntityOfPage headline\">$title</h1>";
                    else :
	                    the_title( '<h1 itemprop="name mainEntityOfPage headline">', '</h1>' );
                    endif;
                ?>

                <?php if ($intro) :
                    echo "<p>$intro</p>";
                endif;
                ?>

                <?php
                if( $primaryCTA ):
                    $link_url = $primaryCTA['url'];
                    $link_title = $primaryCTA['title'];
                    $link_target = $primaryCTA['target'] ? $primaryCTA['target'] : '_self';
                    ?>
                    <a class="button" href="<?php echo esc_url( $link_url ); ?>"
                       aria-label="<?php echo esc_html( $link_title ); ?>"
                       target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php endif;
                if( $secondaryCTA ):
                    $link_url = $secondaryCTA['url'];
                    $link_title = $secondaryCTA['title'];
                    $link_target = $secondaryCTA['target'] ? $secondaryCTA['target'] : '_self';
                    ?>
                    <a class="button ml-md-5" href="<?php echo esc_url( $link_url ); ?>"
                       aria-label="<?php echo esc_html( $link_title ); ?>"
                       target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php
                elseif( $video && get_field('video_lightbox')):
                    $link_url = $video['url'];
                    $button_text = get_field('video_text');
                    ?>
                    <a class="button button-ghost" href="<?php echo esc_url($link_url); ?>"
                       data-lity><?php echo $button_text; ?></a>
                <?php endif; ?>
            </div>
        </div>
	</header><!-- #masthead -->