<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php lightbox_load(get_the_id());?>
    <?php wp_head(); ?>
    <?php if (is_home()) :
        $og = get_field('hero_image', get_option('page_for_posts'));
        if ($og != null) :
            $og = $og['url'];
            if (!$og) :
                $og = get_the_post_thumbnail_url();
            endif;
            if (!$og) :
                $og = get_field('global_op_image','option');
                $og = $og['url'];
            endif;
        endif;
    elseif (is_single()) :
        $og = get_field('hero_image');
        if ($og != null ) :
            $og = $og['url'];
        endif;
        if (!$og) :
            $og = get_the_post_thumbnail_url();
        endif;
        if (!$og) :
            $og = get_field('global_op_image','option');
            $og = $og['url'];
        endif;
    elseif (is_archive()) :
        $term = get_queried_object();
        $og = get_field('category_image', $term);
        if ($og) :
			$og = $og['url'];
		endif;	
        if (!$og) :
            $og = get_field('global_op_image','option');
            $og = $og['url'];
        endif;
    else :
        $og = get_field('hero_image');
        $og = $og['url'];
        if (!$og) :
            $og = get_the_post_thumbnail_url();
        endif;
        if (!$og) :
            $og = get_field('global_op_image','option');
            $og = $og['url'];
        endif;
    endif;
    ?>
    <meta property="og:image" content="<?php echo $og;?>" />
</head>
<?php
/* Gather globals and hero info */
$globalEmail = get_field('global_email','option');
$globalPhone = get_field('global_phone','option');
$globalFacebook = get_field('global_facebook','option');
$globalTwitter = get_field('global_twitter','option');
$globalLinkedin = get_field('global_linkedin','option');
$slideDirection = get_field('slide_direction');
$heroShapes = get_field('hero_shapes');
$backgroundColor = get_field('header_background');

if ($slideDirection) :
    $slideID = "heroSlider".ucfirst($slideDirection);
else :
    $slideID = "heroSliderLeft";
    $slideDirection = "left";
endif;
if (is_home()) :
    $hero = get_field('hero_image', get_option('page_for_posts'));
    $mobilehero = get_field('hero_image_mobile', get_option('page_for_posts'));
    $hero = $hero['url'];
    $mobilehero = $mobilehero['url'];
    $heroVideo = get_field('video_header');  // returns an array if a file is set
    $heroVideoUrl = $heroVideo['url'] ?? ''; // safely get the URL if it exists
    $heroShapes = get_field('hero_shapes', get_option('page_for_posts'));
    $title = get_field('page_title', get_option('page_for_posts'));
    $intro = get_field('intro_text', get_option('page_for_posts'));
    $primaryCTA = get_field('primary_cta', get_option('page_for_posts'));
    $secondaryCTA = get_field('secondary_cta', get_option('page_for_posts'));
    if (!get_field('secondary_cta', get_option('page_for_posts')) || get_field('video_lightbox', 'page_for_posts')) :
        if (get_field('local_video', get_option('page_for_posts'))) :
            $video = get_field('local_video', get_option('page_for_posts'));
        elseif (get_field('hosted_video', get_option('page_for_posts'))) :
            $video = get_field('hosted_video', get_option('page_for_posts'));
        else :
            $video = null;
        endif;
    endif;
elseif (is_single()) :
    $hero = get_the_post_thumbnail_url();
    $mobilehero = get_field('mobile_hero_image');
    if ($mobilehero != null) :
        $mobilehero = $mobilehero['url'];
    endif;
    if (!get_field('intro_text')):
        $intro = '';
    else :
        $intro = get_field('intro_text');
    endif;
    $primaryCTA = '';
    $secondaryCTA = '';
    $video = '';
else :
    $hero = get_field('hero_image');
	if ($hero) :
		$hero = $hero['url'];
	endif;
    $mobilehero = get_field('hero_image_mobile');
	if ($mobilehero) :
		$mobilehero = $mobilehero['url'];
	endif;
    $title = get_field('page_title');
    $intro = get_field('intro_text');
    $primaryCTA = get_field('primary_cta');
    $secondaryCTA = get_field('secondary_cta');
    if (!get_field('secondary_cta') || get_field('video_lightbox')) :
        if (get_field('local_video')) :
            $video = get_field('local_video');
        elseif (get_field('hosted_video')) :
            $video = get_field('hosted_video');
        else :
            $video = null;
        endif;
    endif;
endif;
if (is_archive()) :
    $term = get_queried_object();
    if (get_field('category_image', $term)) :
        $hero = get_field('category_image', $term);
        $hero = $hero['url'];
    else :
        $mobilehero = get_field('hero_image_mobile', get_option('page_for_posts'));
        $mobilehero = $mobilehero['url'];
    endif;
endif;

$custom_logo_id = get_theme_mod('custom_logo');
$image = wp_get_attachment_image_src($custom_logo_id, 'full');
?>
<body <?php body_class(); ?>>
<!-- Preloader -->
<div id="load">
    <div id="contents"></div>
    <div id="loading-text"></div>
</div>
<div <?php if ( is_single() ): echo 'itemscope itemtype="http://schema.org/Article"'; endif; ?>id="wrap">
    <header>
        <div class="bg-slider-new-left"></div>
        <?php if (is_archive()) :
            if (!$hero) :
                $hero = get_field('hero_image', get_option('page_for_posts'));
                $hero = $hero['url'];
            endif;

        endif; ?>
        <?php if ( ! $heroVideoUrl ) : ?>
            <style>
                <?php if ( $hero ) : ?>
                .hero-image-home {
                    background-image: url('<?php echo esc_url($hero); ?>');
                }
                <?php endif; ?>

                <?php if ( $mobilehero ) : ?>
                @media (max-width: 1023px) {
                    .hero-image-home {
                        background-image: url('<?php echo esc_url($mobilehero); ?>');
                    }
                }
                <?php endif; ?>

                <?php if ( $backgroundColor ) : ?>
                #heroImgBg {
                    background-blend-mode: unset !important;
                }
                <?php endif; ?>
            </style>
        <?php endif; ?>

        <?php
        // ========== HERO BACKGROUND OUTPUT ==========

        // If we have a hero video, output <video>:
        if ( $heroVideoUrl ) : ?>
            <div id="heroVideoBg" class="hero-video-container">
                <video
                        autoplay
                        muted
                        loop
                        playsinline
                        poster="<?php echo esc_url($hero); /* fallback poster image */ ?>"
                >
                    <source src="<?php echo esc_url($heroVideoUrl); ?>" type="video/mp4" />
                    <!-- Fallback text / alternate source goes here -->
                </video>
            </div>

        <?php
        // Otherwise, use existing background image markup:
        else : ?>
            <div id="heroImgBg" class="hero-image-home">
                <meta itemprop="image" content="<?php echo esc_url($hero); ?>">
            </div>
        <?php endif; ?>
        <!-- / End Hero Background -->
        <?php if ($heroShapes):
            switch($heroShapes) {
                case "floating" :
                    echo '<div id="heroShapes">';
                    echo '<img class="careers-arrow-up" src="'.get_template_directory_uri().'/img/careers-full-arrow.svg" alt="full-arrow">';
                    echo '<img class="careers-halfarrow-up" src="'.get_template_directory_uri().'/img/careers-half-arrow.svg" alt="half-arrow">';
                    echo '</div>';
                    break;
                case "triangles" :
                    echo '<div id="heroShapes">';
                    echo '<img class="arrow-up-hero" src="'.get_template_directory_uri().'/img/red-arrow.svg" alt="full-arrow">';
                    echo '<img class="halfarrow-up-hero" src="'.get_template_directory_uri().'/img/half-arrow.svg" alt="half-arrow">';
                    echo '</div>';
                    break;
                case "chevron" :
                    echo '<div id="heroShapes">';
                    echo '<img class="services-red-shape" src="'.get_template_directory_uri().'/img/services-half-arrow.svg" alt="half-arrow">';
                    echo '<img class="services-white-shape" src="'.get_template_directory_uri().'/img/contact-white-diamond.svg" alt="white-arrow">';
                    echo '</div>';
                    break;
                case "largechev" :
                    echo '<div id="heroShapes">';
                    echo '<img class="blog-arrow-up" src="'.get_template_directory_uri().'/img/blog-arrow.svg" alt="full-arrow">';
                    echo '<img class="blog-halfarrow-up" src="'.get_template_directory_uri().'/img/blog-halfarrow.svg" alt="half-arrow">';
                    echo '</div>';
                    break;
                case "corners" :
                    echo '<div id="heroShapes">';
                    echo '<img class="about-red-shape" src="'.get_template_directory_uri().'/img/red-angled-shape.svg" alt="red-angle">';
                    echo '<img class="about-white-shape" src="'.get_template_directory_uri().'/img/triangle.svg" alt="white-angle">';
                    echo '</div>';
                    break;
                case "box" :
                    echo '<div id="heroShapes">';
                    echo '<img class="hero-white-shape" src="'.get_template_directory_uri().'/img/contact-white-diamond.svg" alt="white diamond">';
                    echo '<img class="hero-red-shape" src="'.get_template_directory_uri().'/img/contact-red-shape.svg" alt="red shape">';
                    echo '</div>';
                    break;
                default :
            }
        endif; ?>
        <nav>
            <div class="container navigation">
                <div class="Nav">
                    <?php the_custom_logo(); ?>
                    <div id="navLinks">
                        <a href="<?php echo get_home_url(); ?>" aria-label="Activewin Homepage">
                            <img class="mobileLogo activewin-logo" src="<?php echo $image[0];?>"
                                 alt="ActiveWin Media">
                        </a>
                        <div href="javascript:void(0)" class="closebtnMobile">
                            <img src="<?php echo get_template_directory_uri() . '/img/close.svg'; ?>" alt="Close menu">
                        </div>
                        <?php
                        wp_nav_menu( array(
                            'theme_location' => 'menu-1',
                            'menu_id'        => 'desktopNav',
                            'menu_class'     => 'homepageNav',
                            'container'      => '',
                        ) );
                        ?>
                        <div class="navContactContainer">
                            <div class="navContact">
                                <p>Give us call</p>
                                <?php $phoneReplace = str_replace(' ','', $globalPhone); ?>
                                <a href="tel:<?php echo $phoneReplace; ?>" title="call us <?php echo $globalPhone; ?>"><?php echo $globalPhone; ?></a>
                            </div>
                            <div class="navContact">
                                <p>Send us an email</p>
                                <a href="mailto:<?php echo $globalEmail; ?>?subject=ActiveWin Website Request" title="<?php echo $globalEmail; ?>"><?php echo $globalEmail; ?></a>
                            </div>
<!--                            <div class="navContact">-->
<!--                                <p>Follow us on social</p>-->
<!--                                <div class="socialIcons">-->
<!--                                    <a href="--><?php //echo $globalFacebook; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin Facebook"><img-->
<!--                                            src="--><?php //echo get_template_directory_uri() . '/img/facebook.svg'; ?><!--"-->
<!--                                            alt="facebook"></a>-->
<!--                                    <a href="--><?php //echo $globalLinkedin; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin LinkedIn"><img-->
<!--                                            src="--><?php //echo get_template_directory_uri() . '/img/linkedin.svg'; ?><!--"-->
<!--                                            alt="linkedIn"></a>-->
<!--                                    <a href="--><?php //echo $globalTwitter; ?><!--" target="_blank" rel="noreferrer"-->
<!--                                       aria-label="ActiveWin Twitter"><img-->
<!--                                            src="--><?php //echo get_template_directory_uri() . '/img/twitter.svg'; ?><!--"-->
<!--                                            alt="twitter"></a>-->
<!--                                </div>-->
<!--                            </div>-->
                        </div>
                    </div>
                    <div class="burger">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="48"
                             height="48" viewBox="0 0 48 48">
                            <defs>
                                <path id="a" d="M2 24h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zm0-10h32c1.1 0 2-.9 2-2s-.9-2-2-2H2c-1.1 0-2 .9-2 2s.9 2 2 2zM0 2c0 1.1.9 2 2 2h32c1.1 0 2-.9 2-2s-.9-2-2-2H2C.9 0 0 .9 0 2z" />
                            </defs>
                            <g fill="none" fill-rule="evenodd">
                                <path d="M0 0h48v48H0z" />
                                <g transform="translate(6 12)">
                                    <mask id="b" fill="#fff">
                                        <use xlink:href="#a" />
                                    </mask>
                                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#a" />
                                    <g fill="#FFF" mask="url(#b)">
                                        <path d="M-6-12h48v48H-6z" />
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
        </nav><!-- #site-navigation -->
        <div id="hero" class="homepage-hero">
            <div <?php if ( is_single() && 'post' == get_post_type() ) { echo 'id="blogArticleHero" '; } ?>class="container">
                <?php
                if ( is_single() && 'post' == get_post_type() ) {
                    $categories = get_the_category();
                    $post_date = get_the_date( 'F j Y' );
                    if ( ! empty( $categories ) ) {
                        echo '<a class="blog-article-link" href="'.esc_html( get_term_link( $categories[0]->term_id )).'" title="'.esc_html( $categories[0]->name ).'">'.esc_html( $categories[0]->name ).'</a>';
                    } ?><p itemprop="datePublished" content="<?php echo $post_date; ?>" class="blog-article-date">
                    &nbsp; <?php echo $post_date; ?></p>
                    <?php
                }
                ?>
                <?php if (is_archive()) :
                    $current_term = single_term_title( "", false );
                    echo '<p>&nbsp;Category:</p>';
                    echo '<h1 itemprop="name mainEntityOfPage headline">' . $current_term . '</h1>';
                else :
                    if ($title) :
                        echo "<h1 itemprop=\"name mainEntityOfPage headline\">$title</h1>";
                    else :
                        the_title( '<h1 itemprop="name mainEntityOfPage headline">', '</h1>' );
                    endif;
                endif;
                ?>

                <?php if ( is_single() && 'post' == get_post_type() ) { ?>
                    <div class="socialIcons">
                        <p class="social-header">Share article: &nbsp;</p>
<!--                        <a href="https://www.facebook.com/sharer/sharer.php?u=--><?php //the_permalink(); ?><!--" target="_blank"-->
<!--                           aria-label="Share to Facebook">-->
<!--                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="56" height="36" viewBox="0 0 56 36">-->
<!--                                <defs>-->
<!--                                    <path id="i" d="M18.587.003L56.25.051 43.598 32.123C42.681 34.449 40.272 36 37.573 36H0L12.567 4.12c.802-2.398 3.35-4.21 6.02-4.117zm13.27 9.747h-2.494c-2.354 0-3.399 1.042-3.399 3.038v2.229H24v2.633h1.964v7.9h3.274v-7.9h2.384l.234-2.633h-2.618v-1.098c0-.628.125-.877.73-.877h1.888V9.75z"/>-->
<!--                                </defs>-->
<!--                                <g fill="none" fill-rule="evenodd">-->
<!--                                    <mask id="j" fill="#fff">-->
<!--                                        <use xlink:href="#i"/>-->
<!--                                    </mask>-->
<!--                                    <use class="hoverFill" fill="#ff5757" xlink:href="#i"/>-->
<!--                                    <g class="hoverFill" fill="#ff5757" mask="url(#j)">-->
<!--                                        <path d="M0 0h56v36H0z"/>-->
<!--                                    </g>-->
<!--                                </g>-->
<!--                            </svg>-->
<!--                        </a>-->
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&source=<?php the_permalink(); ?>"
                           target="_blank" aria-label="Share to LinkedIn">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="56" height="36" viewBox="0 0 56 36">
                                <defs>
                                    <path id="k" d="M18.587.003L56.25.051 43.598 32.123C42.681 34.449 40.272 36 37.573 36H0L12.567 4.12c.802-2.398 3.35-4.21 6.02-4.117zm5.189 14.99H20.51v10.558h3.266V14.994zm8.303-.26c-1.586 0-2.652.873-3.089 1.703h-.044v-1.442h-3.128V25.55h3.26v-5.224c0-1.378.26-2.711 1.96-2.711 1.67 0 1.694 1.575 1.694 2.8v5.135h3.26v-5.787c0-2.844-.614-5.032-3.913-5.032zM22.14 9.75c-1.045 0-1.89.854-1.89 1.901 0 1.047.845 1.901 1.89 1.901 1.046 0 1.89-.85 1.89-1.901a1.9 1.9 0 0 0-1.89-1.901z"/>
                                </defs>
                                <g fill="none" fill-rule="evenodd">
                                    <mask id="l" fill="#fff">
                                        <use xlink:href="#k"/>
                                    </mask>
                                    <use class="hoverFill" fill="#ff5757" xlink:href="#k"/>
                                    <g class="hoverFill" fill="#ff5757" mask="url(#l)">
                                        <path d="M0 0h56v36H0z"/>
                                    </g>
                                </g>
                            </svg>
                        </a>
<!--                        <a href="#" target="_blank" title="Twitter" class="twitter-share" aria-label="Share to Twitter">-->
<!--                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="56" height="36" viewBox="0 0 56 36">-->
<!--                                <defs>-->
<!--                                    <path id="m" d="M18.587.003L56.25.051 43.598 32.123C42.681 34.449 40.272 36 37.573 36H0L12.567 4.12c.802-2.398 3.35-4.21 6.02-4.117zM32.104 9.75c-2.189 0-3.964 1.784-3.964 3.983 0 .316.036.62.102.91-3.295-.156-6.216-1.747-8.17-4.152a3.922 3.922 0 0 0-.537 2.005c0 1.385.7 2.602 1.763 3.318a3.936 3.936 0 0 1-1.795-.5v.05a3.982 3.982 0 0 0 3.179 3.91 4.006 4.006 0 0 1-1.782.069 3.98 3.98 0 0 0 3.71 2.768 7.925 7.925 0 0 1-4.917 1.705 8.37 8.37 0 0 1-.943-.054 11.234 11.234 0 0 0 6.089 1.789c7.295 0 11.28-6.072 11.28-11.329 0-.17 0-.34-.013-.51a8.03 8.03 0 0 0 1.983-2.064l-.038-.016a8.025 8.025 0 0 1-2.276.627 4.012 4.012 0 0 0 1.742-2.205 8.162 8.162 0 0 1-2.52.959 3.938 3.938 0 0 0-2.893-1.263z"/>-->
<!--                                </defs>-->
<!--                                <g fill="none" fill-rule="evenodd">-->
<!--                                    <mask id="n" fill="#fff">-->
<!--                                        <use xlink:href="#m"/>-->
<!--                                    </mask>-->
<!--                                    <use class="hoverFill" fill="#ff5757" xlink:href="#m"/>-->
<!--                                    <g class="hoverFill" fill="#ff5757" mask="url(#n)">-->
<!--                                        <path d="M0 0h56v36H0z"/>-->
<!--                                    </g>-->
<!--                                </g>-->
<!--                            </svg>-->
<!--                        </a>-->
                    </div>
                <?php } ?>

                <?php if ($intro) :
                    echo "<p>$intro</p>";
                endif;
                ?>

                <?php
                if( $primaryCTA ):
                    $link_url = $primaryCTA['url'];
                    $link_title = $primaryCTA['title'];
                    $link_target = $primaryCTA['target'] ? $primaryCTA['target'] : '_self';
                    ?>
                    <a class="button" href="<?php echo esc_url( $link_url ); ?>"
                       aria-label="<?php echo esc_html( $link_title ); ?>"
                       target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php endif;
                if( $secondaryCTA ):
                    $link_url = $secondaryCTA['url'];
                    $link_title = $secondaryCTA['title'];
                    $link_target = $secondaryCTA['target'] ? $secondaryCTA['target'] : '_self';
                    ?>
                    <a class="button button-ghost" href="<?php echo esc_url( $link_url ); ?>"
                       aria-label="<?php echo esc_html( $link_title ); ?>"
                       target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php
                elseif( $video && get_field('video_lightbox')):
                    $link_url = $video['url'];
                    $button_text = get_field('video_text');
                    ?>
                    <a class="button button-ghost" href="<?php echo esc_url($link_url); ?>"
                       data-lity><?php echo $button_text; ?></a>
                <?php endif; ?>
            </div>
        </div>
    </header><!-- #masthead -->
