<?php
add_action('acf/init', 'my_acf_init');

function my_acf_init() {

    // check function exists
    if( function_exists('acf_register_block') ) {
        // register a services block.
        acf_register_block_type(array(
            'name'              => 'services',
            'title'             => __('Services'),
            'description'       => __('Add a services section'),
            'render_callback'	=> 'services_block_render_callback',
            'category'          => 'widgets',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'services' ),
            'mode' => 'edit',
        ));

        // register case studies block.
        acf_register_block_type(array(
	        'name'            => 'case-studies',
	        'title'           => __('Case Studies'),
	        'description'     => __('Add a case studies slider'),
	        'render_callback' => 'case_study_block_render_callback',
	        'category'        => 'widgets',
	        'icon'            => 'portfolio',
	        'keywords'        => array( 'case studies', 'case', 'studies' ),
	        'mode'            => 'edit',
        ));

        // register clients block.
        acf_register_block_type(array(
	        'name'            => 'clients',
	        'title'           => __('Clients'),
	        'description'     => __('Add a clients block'),
	        'render_callback' => 'clients_block_render_callback',
	        'category'        => 'widgets',
	        'icon'            => 'admin-users',
	        'keywords'        => array( 'clients' ),
	        'mode'            => 'edit',
        ));

        // register clients block.
        acf_register_block_type(array(
	        'name'            => 'blogs',
	        'title'           => __('Blog'),
	        'description'     => __('Add a section to display the latest 3 blog posts'),
	        'render_callback' => 'blog_block_render_callback',
	        'category'        => 'widgets',
	        'icon'            => 'admin-post',
	        'keywords'        => array( 'blog','latest' ),
	        'mode'            => 'edit',
        ));

        // register text left block.
        acf_register_block_type(array(
            'name'              => 'text-left',
            'title'             => __('Text Left'),
            'description'       => __('Add a section of text with an image on the right'),
            'render_callback'	=> 'text_left_block_render_callback',
            'category'          => 'formatting',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'text left', 'left', 'text', 'image' ),
            'mode' => 'edit',
        ));

        // register text right block.
        acf_register_block_type(array(
            'name'              => 'text-right',
            'title'             => __('Text Right'),
            'description'       => __('Add a section of text with an image on the left'),
            'render_callback'	=> 'text_right_block_render_callback',
            'category'          => 'formatting',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'text right', 'right', 'text', 'image' ),
            'mode' => 'edit',
        ));

        // register text right block.
        acf_register_block_type(array(
            'name'              => 'cta',
            'title'             => __('CTA'),
            'description'       => __('Add a CTA section with a title, text and button'),
            'render_callback'	=> 'cta_block_render_callback',
            'category'          => 'widgets',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'cta' ),
            'mode' => 'edit',
        ));

        // register text right block.
        acf_register_block_type(array(
            'name'              => 'meet-the-team',
            'title'             => __('Meet the team'),
            'description'       => __('Add a meet the team slider'),
            'render_callback'	=> 'team_block_render_callback',
            'category'          => 'widgets',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'team', 'meet the team' ),
            'mode' => 'edit',
        ));

        // register text right block.
        acf_register_block_type(array(
            'name'              => 'team-cta',
            'title'             => __('Team member CTA'),
            'description'       => __('Add a CTA that features a team member'),
            'render_callback'	=> 'team_cta_block_render_callback',
            'category'          => 'widgets',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'team', 'cta', 'team member' ),
            'mode' => 'edit',
        ));

        // register benefits block.
        acf_register_block_type(array(
            'name'              => 'benefits',
            'title'             => __('Benefits / USP'),
            'description'       => __('Add a benefits block - can also be used as a USP block'),
            'render_callback'	=> 'benefits_block_render_callback',
            'category'          => 'widgets',
            'icon'              => 'admin-comments',
            'keywords'          => array( 'benefits', 'usp'),
            'mode' => 'edit',
        ));

	    // register testimonial block.
	    acf_register_block_type(array(
		    'name'              => 'testimonial',
		    'title'             => __('Testimonial'),
		    'description'       => __('Add a testimonial section'),
		    'render_callback'	=> 'testimonial_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'testimonial' ),
		    'mode' => 'edit',
	    ));

	    // register carousel block.
	    acf_register_block_type(array(
		    'name'              => 'carousel',
		    'title'             => __('Carousel'),
		    'description'       => __('Add a carousel section'),
		    'render_callback'	=> 'carousel_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'carousel', 'slider', 'image' ),
		    'mode' => 'edit',
	    ));

	    // register careers block.
	    acf_register_block_type(array(
		    'name'              => 'careers',
		    'title'             => __('Careers'),
		    'description'       => __('Add a careers section'),
		    'render_callback'	=> 'careers_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'careers', 'jobs', 'vacancy', 'vacancies' ),
		    'mode' => 'edit',
	    ));

	    // register stats block.
	    acf_register_block_type(array(
		    'name'              => 'stats',
		    'title'             => __('Stats'),
		    'description'       => __('Add a stats section'),
		    'render_callback'	=> 'stats_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'stats', 'counter' ),
		    'mode' => 'edit',
	    ));

	    // register sshare block.
	    acf_register_block_type(array(
		    'name'              => 'share',
		    'title'             => __('Share'),
		    'description'       => __('Add social media share links'),
		    'render_callback'	=> 'share_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'share', 'social' ),
		    'mode' => 'edit',
        ));
        
        // register accordion block.
	    acf_register_block_type(array(
		    'name'              => 'accordion',
		    'title'             => __('accordion'),
		    'description'       => __('Add an accordion component. Commonly used for FAQs, general info.'),
		    'render_callback'	=> 'accordion_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'accordion', 'faq' ),
		    'mode' => 'edit',
        ));
        
        // register ratings block.
	    acf_register_block_type(array(
		    'name'              => 'ratings',
		    'title'             => __('Ratings'),
		    'description'       => __('Add a ratings component. Used for Facebook, Google and Glassdoor ratings.'),
		    'render_callback'	=> 'ratings_block_render_callback',
		    'category'          => 'widgets',
		    'icon'              => 'admin-comments',
		    'keywords'          => array( 'ratings', 'rate' ),
		    'mode' => 'edit',
	    ));

    }
}

function services_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function case_study_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function clients_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function blog_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function cta_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function text_left_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/formatting/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/formatting/block-{$slug}.php") );
    }
}

function text_right_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/formatting/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/formatting/block-{$slug}.php") );
    }
}

function team_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function team_cta_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function benefits_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function testimonial_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function carousel_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function careers_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function stats_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function share_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function accordion_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}

function ratings_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);
    if( file_exists( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/blocks/block-{$slug}.php") );
    }
}