<?php

if( function_exists('acf_add_local_field_group') ):
    acf_add_local_field_group(array(
        'key' => 'group_qwbXBYEIJMSTYjS',
        'title' => 'Page Hero',
        'fields' => array (
            array (
                'key' => 'field_eSOhLukzn1gC7r8',
                'label' => 'Slide Direction',
                'name' => 'slide_direction',
                'type' => 'select',
                'required'  => 0,
                'choices' => array(
                    'top' => 'Top',
                    'right' => 'Right',
                    'bottom' => 'Bottom',
                    'left' => 'Left',
                ),
            ),
            array (
                'key' => 'field_FeWphbyVeSjoiNw',
                'label' => 'Hero Image',
                'name' => 'hero_image',
                'type' => 'image',
                'instructions'   => 'Background image for the page header hero. Recommended size: 1920x1080px',
                'required'  => 0,
            ),
            array(
                'key' => 'field_67b48cfc28e9d',
                'label' => 'video header',
                'name' => 'video_header',
                'aria-label' => '',
                'type' => 'file',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'array',
                'library' => 'all',
                'min_size' => '',
                'max_size' => '',
                'mime_types' => '',
                'allow_in_bindings' => 0,
            ),
            array (
                'key' => 'field_LzifEuFW84PGFZh',
                'label' => 'Hero Image Mobile / Tablet',
                'name' => 'hero_image_mobile',
                'type' => 'image',
                'instructions'   => 'Background image for the page header hero on mobile and tablets. Recommended size: 768x768px',
                'required'  => 0,
            ),
            array (
                'key' => 'field_T0jJLVwzpwsf1hl',
                'label' => 'Hero Shapes',
                'name' => 'hero_shapes',
                'type' => 'select',
                'instructions'   => 'Add shapes with animation over the hero image',
                'choices' => array(
	                'triangles' => 'Triangle and Curve',
	                'chevron'   => 'Chevron and Triangle',
	                'largechev'   => 'Large Chevron and Triangle',
	                'corners'   => 'Triangle in corners',
	                'floating'  => 'Floating triangles',
	                'box'  => 'Box with triangle cutout',
                ),
                'allow_null' => 1,
                'default_value' => array(
                ),
            ),

            array(
                'key' => 'field_6nS9s1B3247HG',
                'label' => 'Background Colour',
                'name' => 'header_background',
                'type' => 'true_false',
                'instructions' => 'Check here to remove the background colour overlay',
                'wrapper' => array(
                    'width' => '70%',
                ),
            ),
            array (
                'key' => 'field_M9YMOgaUFxrZak3',
                'label' => 'Title',
                'name' => 'page_title',
                'type' => 'text',
                'instructions'   => 'The title of the page to display on the hero (defaults to page title if left blank)',
                'required'  => 0,
            ),
            array (
                'key' => 'field_u7JL1DAHMaomKsS',
                'label' => 'Intro Text',
                'name' => 'intro_text',
                'type' => 'textarea',
                'instructions'   => 'Short introduction text for the page to to on the hero',
                'required'  => 0,
            ),
            array (
                'key' => 'field_BvMh046yAgFZTsN',
                'label' => 'Primary CTA',
                'name' => 'primary_cta',
                'type' => 'link',
                'required'  => 0,
            ),
            array (
                'key' => 'field_rWGyqjlGUWDOtAD',
                'label' => 'Secondary CTA',
                'name' => 'secondary_cta',
                'type' => 'link',
                'required'  => 0,
                'wrapper' => array(
                    'width' => '30%',
                ),
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_6nS9s1BHCpXVDmg',
                            'operator' => '!=',
                            'value' => '1',
                        ),
                    ),
                ),
            ),
            array(
                'key' => 'field_6nS9s1BHCpXVDmg',
                'label' => 'Make secondary CTA a video lightbox',
                'name' => 'video_lightbox',
                'type' => 'true_false',
                'instructions' => 'Check the box to make the secondary CTA show a lightbox with video content instead of a link',
                'wrapper' => array(
                    'width' => '70%',
                ),
            ),
            array (
                'key' => 'field_7Uf9L855HaKR4vX',
                'label' => 'Choose Video',
                'name' => 'local_video',
                'type' => 'file',
                'required'  => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_6nS9s1BHCpXVDmg',
                            'operator' => '==',
                            'value' => '1',
                        ),
                    ),
                ),
            ),
            array (
                'key' => 'field_6FeAknjcZxgGrWX',
                'label' => 'Youtube or Vimeo URL',
                'name' => 'hosted_video',
                'type' => 'text',
                'required'  => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_6nS9s1BHCpXVDmg',
                            'operator' => '==',
                            'value' => '1',
                        ),
                    ),
                ),
            ),
            array (
                'key' => 'field_VIVxMX05cly8YTs',
                'label' => 'Button Text',
                'name' => 'video_text',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Play Showreel',
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_6nS9s1BHCpXVDmg',
                            'operator' => '==',
                            'value' => '1',
                        ),
                    ),
                ),
            ),
            array (
                'key' => 'field_9O33Jlg3sLkqO6N',
                'label' => 'Animated Shapes',
                'name' => 'animated_shapes',
                'type' => 'select',
                'required'  => 0,
                'allow_null' => 1,
                'choices' => array(
                    'bottomRight' => 'Bottom Right Triangles',
                    'rightSide' => 'Right Side Triangles'
                ),
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                ),
            ),
	        array(
		        array(
			        'param' => 'post_type',
			        'operator' => '==',
			        'value' => 'careers',
		        ),
	        ),
        ),
    ));
    acf_add_local_field_group(array(
        'key' => 'group_BaPMy2wHLPuWd3K',
        'title' => 'Page Intro',
        'fields' => array (
            array (
                'key' => 'field_llCtNyx9XctlNM8',
                'label' => 'Intro Text',
                'name' => 'intro_text',
                'type' => 'textarea',
                'instructions'   => 'Short introduction text for the page to to on the hero',
                'required'  => 0,
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'case_study',
                ),
            ),
        ),
    ));

        acf_add_local_field_group( array(
            'key' => 'group_67b4a12825e8e',
            'title' => 'Case Study: Overlay',
            'fields' => array(
                array(
                    'key' => 'field_67b4a127a78a7',
                    'label' => 'Disable Overlay',
                    'name' => 'disable_overlay',
                    'aria-label' => '',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => 'Disable the background overlay',
                    'default_value' => 0,
                    'allow_in_bindings' => 0,
                    'ui' => 0,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_67b4a2cee8987',
                    'label' => 'Overlay Colour',
                    'name' => 'overlay_colour',
                    'aria-label' => '',
                    'type' => 'color_picker',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => 0,
                    'return_format' => 'string',
                    'allow_in_bindings' => 0,
                ),
                array(
                    'key' => 'field_3345345sdfys',
                    'label' => 'Text Colour',
                    'name' => 'text_colour',
                    'aria-label' => '',
                    'type' => 'color_picker',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => 0,
                    'return_format' => 'string',
                    'allow_in_bindings' => 0,
                ),
                array(
                    'key' => 'field_6F3242dfgsd344',
                    'label' => 'Link Colour',
                    'name' => 'link_colour',
                    'aria-label' => '',
                    'type' => 'color_picker',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => 0,
                    'return_format' => 'string',
                    'allow_in_bindings' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'case_study',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'side',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );




    acf_add_local_field_group(array(
        'key' => 'group_2T2WBHFh2XfdZQv',
        'title' => 'Service',
        'fields' => array (
            array (
                'key' => 'field_OJ9zO91o8nOioXq',
                'label' => 'Short Description',
                'name' => 'short_description',
                'type' => 'textarea',
                'instructions'   => 'Short description of the service, will appear on service lists',
                'required'  => 1,
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-service.php',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_FAoB0GPDAFoVPbL',
        'title' => 'Service',
        'fields' => array (
            array (
                'key' => 'field_mRhNxIkTfXHRxZb',
                'label' => 'Limit',
                'name' => 'services_limit',
                'type' => 'number',
                'instructions'   => 'Number of services to show, leave as empty or 0 to show all',
            ),
            array (
                'key' => 'field_OT8mYzbxYCG5ZiY',
                'label' => 'Title',
                'name' => 'services_title',
                'type' => 'text',
                'instructions'   => 'Service section title',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/services',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_A5sHQLm10Qc4Yp2',
        'title' => 'Case Studies',
        'fields' => array (
            array (
                'key' => 'field_wQBn0tkpKJZ5UY2',
                'label' => 'URL',
                'name' => 'case_studies_url',
                'type' => 'link',
                'instructions'   => 'Case Studies url',
                'required'  => 1,
            ),
            array (
                'key' => 'field_6tbSxGVMb66Vh3i',
                'label' => 'Amount to show',
                'name' => 'case_studies_limit',
                'type' => 'number',
                'instructions'   => 'Amount of case studies to show on the slider, if empty then all will be shown',
                'required'  => 0,
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/case-studies',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_fyonQ1hVx1KJF7x',
        'title' => 'Clients',
        'fields' => array (
            array (
                'key' => 'field_wDjRxbKDgGLJ24t',
                'label' => 'Title',
                'name' => 'clients_title',
                'type' => 'text',
                'instructions'   => 'Title for the section',
                'required'  => 1,
            ),
            array (
                'key' => 'field_cpzLJh0bSqT4Ynq',
                'label' => 'Limit',
                'name' => 'clients_limit',
                'type' => 'number',
                'instructions'   => 'Select how many clients to show',
                'default_value' => 0,
                'required'  => 0,
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/clients',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_9YJPU0fZNuq2UzR',
        'title' => 'Blog',
        'fields' => array (
            array (
                'key' => 'field_MkRAHbAeBcKgIEc',
                'label' => 'Title',
                'name' => 'blog_title',
                'type' => 'text',
                'instructions'   => 'Title for the blog section',
                'required'  => 1,
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/blogs',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_JGtVAbSnD0gF1QP',
        'title' => 'Contact Information',
        'fields' => array (
            array(
                'key' => 'field_If9jBATS64IJNFD9F',
                'label' => 'Imagery',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
	        array(
		        'key' => 'field_63b0aad306f2f',
		        'label' => 'Image',
		        'name' => 'fallback_header_image',
		        'type' => 'image',
		        'instructions' => '',
		        'required' => 0,
		        'conditional_logic' => 0,
		        'wrapper' => array(
			        'width' => '',
			        'class' => '',
			        'id' => '',
		        ),
		        'return_format' => 'array',
		        'preview_size' => 'medium',
		        'library' => 'all',
		        'min_width' => '',
		        'min_height' => '',
		        'min_size' => '',
		        'max_width' => '',
		        'max_height' => '',
		        'max_size' => '',
		        'mime_types' => '',
	        ),
            array(
                'key' => 'field_If9jBATS64I5q1y',
                'label' => 'Contact Information',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array (
                'key' => 'field_Balv9xTnnnxX46q',
                'label' => 'Phone Number',
                'name' => 'global_phone',
                'type' => 'text',
                'instructions'   => 'ActiveWin phone number',
                'required'  => 1,
            ),
            array (
                'key' => 'field_D8PFLzP6RHT92lu',
                'label' => 'Email Address',
                'name' => 'global_email',
                'type' => 'text',
                'instructions'   => 'ActiveWin email address',
                'required'  => 1,
            ),
            array (
                'key' => 'field_wneDMlJwxaqJr1W',
                'label' => 'Jobs Email Address',
                'name' => 'global_jobs',
                'type' => 'text',
                'instructions'   => 'Email address Job applications will be sent to',
                'required'  => 1,
            ),
	        array(
			        'key' => 'field_jypT5y44pKjBS0e',
			        'label' => 'Office address 1',
			        'name' => 'global_office_1',
			        'type' => 'textarea',
			        'new_lines' => 'br',
		        ),
	        array (
			        'key' => 'field_jh5TNyOskRladRW',
			        'label' => 'Google Maps Directions',
			        'name' => 'global_directions_1',
			        'type' => 'text',
			        'instructions'   => 'URL to the google maps directions to office 1',
			        'required'  => 1,
		        ),
	        array(
			        'key' => 'field_Dg0hxrzU8YrDIiv',
			        'label' => 'Office address 2',
			        'name' => 'global_office_2',
			        'type' => 'textarea',
			        'new_lines' => 'br',
		        ),
	        array (
			        'key' => 'field_CnFXBeagPRFsyRP',
			        'label' => 'Google Maps Directions',
			        'name' => 'global_directions_2',
			        'type' => 'text',
			        'instructions'   => 'URL to the google maps directions to office 2',
			        'required'  => 1,
		        ),

            array(
                'key' => 'field_iRrdukqoaBnSfqF',
                'label' => 'Social Media',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array (
                'key' => 'field_LuAxOt935wm3lVi',
                'label' => 'Facebook',
                'name' => 'global_facebook',
                'type' => 'text',
                'instructions'   => 'ActiveWin Facebook profile',
                'required'  => 0,
            ),
            array (
                'key' => 'field_xd4B5V65VnctDAi',
                'label' => 'LinkedIn',
                'name' => 'global_linkedin',
                'type' => 'text',
                'instructions'   => 'ActiveWin LinkedIn profile',
                'required'  => 0,
            ),
            array (
                'key' => 'field_sqaOSp7uTjVyHUv',
                'label' => 'Twitter',
                'name' => 'global_twitter',
                'type' => 'text',
                'instructions'   => 'ActiveWin Twitter profile',
                'required'  => 0,
            ),
            array (
                'key' => 'field_sqaOSp734hkjGUd8',
                'label' => 'Tik Tok',
                'name' => 'global_tik_tok',
                'type' => 'text',
                'instructions'   => 'ActiveWin Tik Tok profile',
                'required'  => 0,
            ),
            array (
                'key' => 'field_f4X1ZSVNo36JQ0z',
                'label' => 'Open Graph Image',
                'name' => 'global_op_image',
                'type' => 'image',
                'instructions'   => 'Fallback Open Graph image for pages missing a hero and featured image',
                'required'  => 1,
            ),
	        array(
		        'key' => 'field_lHahxBmMsVLJCrn',
		        'label' => 'Tracking',
		        'name' => '',
		        'type' => 'tab',
		        'placement' => 'top',
		        'endpoint' => 0,
	        ),
	        array (
		        'key' => 'field_IqKq9oZvvJVA5Gh',
		        'label' => 'Google Tag Manager',
		        'name' => 'tracking_gtm',
		        'type' => 'textarea',
		        'instructions'   => 'Google Tag manager code snippet',
		        'required'  => 0,
	        ),
	        array(
		        'key' => 'field_5ufGJRTA22hwoZt',
		        'label' => 'Live Chat',
		        'name' => '',
		        'type' => 'tab',
		        'placement' => 'top',
		        'endpoint' => 0,
	        ),
	        array (
		        'key' => 'field_DrY7JaATH8sbNP9',
		        'label' => 'Live Chat',
		        'name' => 'live_chat_gtm',
		        'type' => 'textarea',
		        'instructions'   => 'Live Chat code snippet',
		        'required'  => 0,
	        ),
	        array(
		        'key' => 'field_GrXMQe9Fgj50y0O',
		        'label' => 'HTML Emails',
		        'name' => '',
		        'type' => 'tab',
		        'placement' => 'top',
		        'endpoint' => 0,
	        ),
	        array (
		        'key' => 'field_HsJ41Ic2LwjmpWI',
		        'label' => 'Contact form Logo',
		        'name' => 'contact_form_email_logo',
		        'type' => 'image',
		        'instructions'   => '',
		        'required'  => 0,
	        ),
	        array (
		        'key' => 'field_ewxsfAv3yLHDRsl',
		        'label' => 'Contact form header image',
		        'name' => 'contact_form_email_header_image',
		        'type' => 'image',
		        'instructions'   => '',
		        'required'  => 0,
	        ),
	        array (
		        'key' => 'field_nYoyiwrGqoBESGI',
		        'label' => 'PPC Audit form header image',
		        'name' => 'ppc_audit_email_header_image',
		        'type' => 'image',
		        'instructions'   => '',
		        'required'  => 0,
	        ),
	        array (
		        'key' => 'field_PqwP5rWoTgDVgO2',
		        'label' => 'Career form header image',
		        'name' => 'career_email_header_image',
		        'type' => 'image',
		        'instructions'   => '',
		        'required'  => 0,
	        ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'theme-general-settings',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_PjJLR3KuTkPuDlf',
        'title' => 'Text left with image',
        'fields' => array (
	        array (
		        'key' => 'field_qrhH6t2pr3CIAR3',
		        'label' => 'Heading',
		        'name' => 'heading_size_left',
		        'type' => 'select',
		        'instructions'   => 'Heading size',
		        'required' => 1,
		        'wrapper' => array(
			        'width' => '20',
			        'class' => '',
			        'id' => '',
		        ),
		        'choices' => array(
			        'h1' => 'H1',
			        'h2' => 'H2',
			        'h3' => 'H3',
			        'h4' => 'H4',
			        'h5' => 'H5',
			        'h6' => 'H6',
		        ),
		        'default_value' => array(
			        0 => 'h2',
		        ),
		        'return_format' => 'value',
	        ),
            array (
                'key' => 'field_MJiLiWVpLAVWiIJ',
                'label' => 'Title',
                'name' => 'text_left_title',
                'type' => 'text',
                'instructions'   => 'Title',
                'wrapper' => array(
	                'width' => '80',
	                'class' => '',
	                'id' => '',
                ),
            ),
            array (
                'key' => 'field_Ai3Ld1r2zSjbiPc',
                'label' => 'Content',
                'name' => 'text_left_content',
                'type' => 'wysiwyg',
                'instructions'   => 'The content',
            ),
            array (
                'key' => 'field_Mm0YX5h4VkDtSdf',
                'label' => 'Image',
                'name' => 'text_left_image',
                'type' => 'image',
                'instructions'   => 'Select an image',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/text-left',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_LRUdkElo0mOYvqK',
        'title' => 'Text right with image',
        'fields' => array (
            array (
                'key' => 'field_PLfEqolFcKR1ynJ',
                'label' => 'Heading',
                'name' => 'heading_size',
                'type' => 'select',
                'instructions'   => 'Heading size',
                'required' => 1,
                'wrapper' => array(
	                'width' => '20',
	                'class' => '',
	                'id' => '',
                ),
                'choices' => array(
	                'h1' => 'H1',
	                'h2' => 'H2',
	                'h3' => 'H3',
	                'h4' => 'H4',
	                'h5' => 'H5',
	                'h6' => 'H6',
                ),
                'default_value' => array(
	                0 => 'h2',
                ),
                'return_format' => 'value',
            ),
            array (
                'key' => 'field_dniMH3RRBKgfxdH',
                'label' => 'Title',
                'name' => 'text_right_title',
                'type' => 'text',
                'instructions'   => 'Title',
                'wrapper' => array(
	                'width' => '80',
	                'class' => '',
	                'id' => '',
                ),
            ),
            array (
                'key' => 'field_WUfs8moeizNJdz6',
                'label' => 'Content',
                'name' => 'text_right_content',
                'type' => 'wysiwyg',
                'instructions'   => 'The content',
            ),
            array (
                'key' => 'field_mzO9HRDSAsR8zZR',
                'label' => 'Image',
                'name' => 'text_right_image',
                'type' => 'image',
                'instructions'   => 'Select an image',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/text-right',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_Ju4mNburY7a8ndC',
        'title' => 'CTA',
        'fields' => array (
            array (
                'key' => 'field_eWH5QBT0SPRApkn',
                'label' => 'Title',
                'name' => 'cta_title',
                'type' => 'text',
                'instructions'   => 'Title',
            ),
            array (
                'key' => 'field_gFUVhMcOO0osNO8',
                'label' => 'Content',
                'name' => 'cta_content',
                'type' => 'wysiwyg',
                'instructions'   => 'The content',
            ),
            array (
                'key' => 'field_FUYNQKSBByjKvac',
                'label' => 'Link',
                'name' => 'cta_link',
                'type' => 'link',
                'instructions'   => 'Select a link',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/cta',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_IfAbAPTghxazXqU',
        'title' => 'Team Member',
        'fields' => array (
	        array(
		        'key' => 'field_ohUROUoxclg3MIJ',
		        'label' => 'Include in meet the team',
		        'name' => 'include_meet_the_team',
		        'type' => 'checkbox',
		        'required' => 0,
		        'conditional_logic' => 0,
		        'wrapper' => array(
			        'width' => '',
			        'class' => '',
			        'id' => '',
		        ),
		        'choices' => array(
			        1 => 'Show team member on Meet the Team slider',
		        ),
	        ),
        ),
        'location' => array (
	        array (
		        array (
			        'param' => 'post_type',
			        'operator' => '==',
			        'value' => 'team',
		        ),
	        ),
        ),
        'position' => 'side',
        'style' => 'default',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_SQZXcqXNvK8eJ2Z',
        'title' => 'Team Member',
        'fields' => array (
            array (
                'key' => 'field_2yNsOIO62Osq54J',
                'label' => 'Job title',
                'name' => 'team_title',
                'type' => 'text',
                'instructions'   => 'Team members job title',
            ),
            array (
                'key' => 'field_rvRnrm2NiUHqIEE',
                'label' => 'Bio',
                'name' => 'team_bio',
                'type' => 'textarea',
                'instructions'   => 'Short bio of team member',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'team',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_SO8nJvSwYRep2NL',
        'title' => 'Team Member Lead Gen',
        'fields' => array (
            array (
                'key' => 'field_bKW9pxAXzVafyxn',
                'label' => 'Image',
                'name' => 'team_lead_gen_image',
                'type' => 'image',
                'instructions'   => 'Image to be shown on the lead gen components',
            ),
            array (
                'key' => 'field_kvsOd2NdUaxvVzW',
                'label' => 'Lead Gen Text',
                'name' => 'team_lead_gen_text',
                'type' => 'textarea',
                'instructions'   => 'Team member specific lead gen text',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'team',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_msz8BurYMn4NaHh',
        'title' => 'Meet the team',
        'fields' => array (
            array (
                'key' => 'field_mXLVABEDNewZiDN',
                'label' => 'Title',
                'name' => 'team_block_title',
                'type' => 'text',
                'instructions'   => 'Title',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/meet-the-team',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
	    'key'    => 'group_R2aSpYccwcTqRiq',
	    'title'  => 'Team member lead gen',
	    'fields' => array (
            array (
                'key' => 'field_RU90CECh7JHGJ3I',
                'label' => 'Title',
                'name' => 'team_cta_title',
                'type' => 'text',
                'instructions'   => 'Title',
            ),
            array (
                'key' => 'field_IeSpgelHF72j8pe',
                'label' => 'Content',
                'name' => 'team_cta_content',
                'type' => 'textarea',
                'instructions'   => 'If left blank, will default to lead gen text set in the team member',
            ),
            array (
                'key' => 'field_ZvsuSdWQSr1Sf4A',
                'label' => 'CTA Link',
                'name' => 'team_cta_link',
                'type' => 'link',
                'instructions'   => 'Chose where the CTA links to and the CTA button text',
            ),
            array (
                'key' => 'field_8A2Hfd95wIdsauN',
                'label' => 'Team Member',
                'name' => 'team_cta_team_member',
                'type' => 'post_object',
                'instructions'   => 'Chose which team member to feature on the CTA',
                'post_type' => array(
                    0 => 'team',
                ),
            ),
        ),
	    'location' => array (
            array (
                array (
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/team-cta',
                ),
            ),
        ),
    ));

    acf_add_local_field_group(array(
        'key' => 'group_d3hxGYlBSHgAhrb',
        'title' => 'Testimonial',
        'fields' => array(
            array(
                'key' => 'field_CmZVy624BNiFSWO',
                'label' => 'Testimonial',
                'name' => 'testimonial',
                'type' => 'post_object',
                'instructions' => 'Select a testimonial, random testimonial will be shown if one isn\'t selected',
                'return_format' => 'object',
                'post_type' => array(
	                0 => 'testimonial',
                ),
            ),
	        array(
		        'key' => 'field_7WQqPC7d4RE9wnj',
		        'label' => 'Testimonial Type',
		        'name' => 'testimonial_types',
		        'type' => 'select',
		        'instructions' => 'Select type of testimonial to show if random',
		        'required' => 1,
		        'conditional_logic' => 0,
		        'wrapper' => array(
			        'width' => '',
			        'class' => '',
			        'id' => '',
		        ),
		        'choices' => array(
			        'staff' => 'Staff',
			        'client' => 'Client',
		        ),
		        'default_value' => array(
		        ),
		        'allow_null' => 0,
		        'multiple' => 0,
		        'ui' => 0,
		        'return_format' => 'value',
		        'ajax' => 0,
		        'placeholder' => '',
	        ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/testimonial',
                ),
            ),
        ),
    ));

	acf_add_local_field_group(array(
		'key' => 'group_61Pp20FxgEPGwel',
		'title' => 'Carousel',
		'fields' => array(
			array(
				'key' => 'field_vVz7krYlfNHe5tK',
				'label' => 'Carousel',
				'name' => 'carousel_images',
				'type' => 'repeater',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'collapsed' => 'field_YIdfP1O6WCuZWil',
				'min' => 0,
				'max' => 0,
				'layout' => 'block',
				'button_label' => 'Add Slide',
				'sub_fields' => array(
					array(
						'key' => 'field_YIdfP1O6WCuZWil',
						'label' => 'Slide',
						'name' => 'slide',
						'type' => 'image',
						'instructions' => '',
						'required' => 1,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/carousel',
				),
			),
		),
	));

	acf_add_local_field_group(array(
		'key' => 'group_pHEgi5BQYpKwIrD',
		'title' => 'Careers',
		'fields' => array(
			array(
				'key' => 'field_pmLvdlQr8h7AKYu',
				'label' => 'Title',
				'name' => 'careers_title',
				'type' => 'text',
				'instructions' => '',
				'required' => 1,
			),
			array(
				'key' => 'field_TJYP2iAUC7wLsyf',
				'label' => 'Text',
				'name' => 'careers_text',
				'type' => 'wysiwyg',
				'instructions' => '',
				'required' => 1,
			),
			array(
				'key' => 'field_sqSOVx7sCBDP2qR',
				'label' => 'No listings',
				'name' => 'careers_alternate',
				'type' => 'wysiwyg',
				'instructions' => 'Text to display should there be no current positions open',
				'required' => 1,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/careers',
				),
			),
		),
	));

	acf_add_local_field_group(array(
		'key' => 'group_ZxcjDofioWMYXkH',
		'title' => 'Career',
		'fields' => array(
			array(
				'key' => 'field_gxlppYMtlChb4Ve',
				'label' => 'Department',
				'name' => 'job_department',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
			),
			array(
				'key' => 'field_iTgzqJrkWyFfiiD',
				'label' => 'Type',
				'name' => 'job_type',
				'type' => 'text',
				'instructions' => 'Is this job Permanent, Temporary, Part time, full time etc',
				'required' => 1,
			),
			array(
				'key' => 'field_kAWPbEBqiDkzzkx',
				'label' => 'Location',
				'name' => 'job_location',
				'type' => 'text',
				'instructions' => 'Where is this job based?',
				'required' => 1,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'careers',
				),
			),
		),
		'position' => 'acf_after_title',
	));

	acf_add_local_field_group(array(
		'key' => 'group_jovP4kroLa4qJqH',
		'title' => 'Image',
		'fields' => array(
			array(
				'key' => 'field_W7YGzuiHSdZpLYy',
				'label' => 'Image',
				'name' => 'category_image',
				'type' => 'image',
				'instructions' => 'Background image for the page header hero on Desktop and large displays. Recommended size: 1920x1080px',
				'required' => 0,
			),
			array(
				'key' => 'field_kkeMnk9EIftb0Ga',
				'label' => 'Mobile Image',
				'name' => 'category_image_mobile',
				'type' => 'image',
				'instructions' => 'Background image for the page header hero on mobile and tablets. Recommended size: 768x768px',
				'required' => 0,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'taxonomy',
					'operator' => '==',
					'value' => 'category',
				),
			),
			array(
				array(
					'param' => 'taxonomy',
					'operator' => '==',
					'value' => 'case_study_categories',
				),
			),
		),
	));

	acf_add_local_field_group(array(
		'key' => 'group_K4BW39llafYWd1r',
		'title' => 'Benefits',
		'fields' => array(
			array(
				'key' => 'field_RVrfOWUqM8Rl86E',
				'label' => 'Title',
				'name' => 'benefits_title',
				'type' => 'text',
				'instructions' => 'A title for the section',
				'required' => 1,
			),
			array(
				'key' => 'field_9PvRl9MefTnMDIz',
				'label' => 'Benefits',
				'name' => 'benefits',
				'type' => 'repeater',
				'instructions' => '',
				'required' => 0,
				'collapsed' => 'field_7tNFe3LaGeyUW3W',
				'min' => 0,
				'max' => 0,
				'layout' => 'block',
				'button_label' => 'Add benefit',
				'sub_fields' => array(
					array(
						'key' => 'field_fo8af9SzbNYUfwY',
						'label' => 'Image',
						'name' => 'benefit_image',
						'type' => 'image',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'array',
						'preview_size' => 'medium',
						'library' => 'all',
						'min_width' => '',
						'min_height' => '',
						'min_size' => '',
						'max_width' => '',
						'max_height' => '',
						'max_size' => '',
						'mime_types' => '',
					),
					array(
						'key' => 'field_7tNFe3LaGeyUW3W',
						'label' => 'Title',
						'name' => 'benefit_title',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
					array(
						'key' => 'field_wSF8ky0CejWksGo',
						'label' => 'Description',
						'name' => 'benefit_description',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/benefits',
				),
			),
		),
	));

	acf_add_local_field_group(array(
		'key' => 'group_NQBh68GqD0w40Ki',
		'title' => 'Stats',
		'fields' => array(
			array(
				'key'               => 'field_ZCb2xXxYJA0Zvwm',
				'label'             => 'General',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement'         => 'top',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_mzuWn4Whm69SBNa',
				'label'             => 'Animation',
				'name'              => 'stat_counter_animation',
				'type'              => 'true_false',
				'instructions'      => 'Tick to disable the animation effect',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'message'           => '',
				'default_value'     => 0,
				'ui'                => 0,
				'ui_on_text'        => '',
				'ui_off_text'       => '',
			),
			array(
				'key'               => 'field_3tbQTKgsdGfXVjN',
				'label'             => 'Stat 1',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'top',
				'endpoint'          => 0,
			),
			array(
				'key'      => 'field_IGelkbn2k4iLyBc',
				'label'    => 'First stat #',
				'name'     => 'stat_counter_1',
				'type'     => 'number',
				'required' => 1,
			),
			array(
				'key'      => 'field_GizndcyhhMGAX9T',
				'label'    => 'Suffix (% etc)',
				'name'     => 'stat_counter_1_suffix',
				'type'     => 'text',
				'required' => 0,
			),
			array(
				'key'      => 'field_5XZGSxPTDKacLrv',
				'label'    => 'Description',
				'name'     => 'stat_counter_1_description',
				'type'     => 'text',
				'required' => 1,
			),
			array(
				'key'          => 'field_Yjm3ZY33QU85MSE',
				'label'        => 'Arrow',
				'name'         => 'stat_counter_1_arrow',
				'type'         => 'select',
				'required'     => 1,
				'instructions' => 'Choose a complimentary arrow for the stat (or none)',
				'choices'      => array(
					'no-arrow' => 'None',
					'down'     => 'Down',
					'up'       => 'Up'
				),
			),
			array(
				'key' => 'field_gN1zXLN9jNajCGS',
				'label' => 'Stat 2',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key'      => 'field_R1lld2SYUAsqgf7',
				'label'    => 'Second stat #',
				'name'     => 'stat_counter_2',
				'type'     => 'number',
				'required' => 1,
			),
			array(
				'key'      => 'field_u9Pb9LYnspWUU4k',
				'label'    => 'Suffix (% etc)',
				'name'     => 'stat_counter_2_suffix',
				'type'     => 'text',
				'required' => 0,
			),
			array(
				'key'      => 'field_Rki6ZpekRnjJqWr',
				'label'    => 'Description',
				'name'     => 'stat_counter_2_description',
				'type'     => 'text',
				'required' => 1,
			),
			array(
				'key'          => 'field_gk9fX8pm8ScKoRu',
				'label'        => 'Arrow',
				'name'         => 'stat_counter_2_arrow',
				'type'         => 'select',
				'instructions' => 'Choose a complimentary arrow for the stat (or none)',
				'required'     => 1,
				'choices'      => array(
					'no-arrow' => 'None',
					'down'     => 'Down',
					'up'       => 'Up'
				),
			),

			array(
				'key' => 'field_9LpuvjATIJmAfoX',
				'label' => 'Stat 3',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key'      => 'field_LNJJE12M4OZXtdP',
				'label'    => 'Third stat #',
				'name'     => 'stat_counter_3',
				'type'     => 'number',
				'required' => 1,
			),
			array(
				'key'      => 'field_ELfn8SEocZ1Dxq3',
				'label'    => 'Suffix (% etc)',
				'name'     => 'stat_counter_3_suffix',
				'type'     => 'text',
				'required' => 0,
			),
			array(
				'key'      => 'field_kVtvYb7jnuAU0Cf',
				'label'    => 'Description',
				'name'     => 'stat_counter_3_description',
				'type'     => 'text',
				'required' => 1,
			),
			array(
				'key'          => 'field_euQoZXt2qyxqEuh',
				'label'        => 'Arrow',
				'name'         => 'stat_counter_3_arrow',
				'type'         => 'select',
				'instructions' => 'Choose a complimentary arrow for the stat (or none)',
				'required'     => 1,
				'choices'      => array(
					'no-arrow' => 'None',
					'down'     => 'Down',
					'up'       => 'Up'
				),
			),

		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/stats',
				),
			),
		),
	));

	acf_add_local_field_group(array(
		'key' => 'group_V0tulXCGMx3Aym1',
		'title' => 'Testimonials',
		'fields' => array(
			array(
				'key' => 'field_OXxlFnCDwBLDDBC',
				'label' => 'Name',
				'name' => 'testimonial_name',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_5e25c4659648b',
				'label' => 'Title',
				'name' => 'testimonial_title',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_8f5cqejji16at',
				'label' => 'URL',
				'name' => 'testimonial_url',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_UNE8HjOTwAHoxJV',
				'label' => 'Quote',
				'name' => 'testimonial_quote',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => '',
			),
			array(
				'key' => 'field_cZQnwqwHuOnC5gN',
				'label' => 'Testimonial Type',
				'name' => 'testimonial_type',
				'type' => 'select',
				'instructions' => '',
				'required' => 1,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'staff' => 'Staff',
					'client' => 'Client',
				),
				'default_value' => array(
				),
				'allow_null' => 0,
				'multiple' => 0,
				'ui' => 0,
				'return_format' => 'value',
				'ajax' => 0,
				'placeholder' => '',
			),

		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'testimonial',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_wWzgKUcZDfvkxUr',
		'title' => 'PPC Audit Number List',
		'fields' => array(
			array(
				'key' => 'field_KdnDTiRTFrBm4pj',
				'label' => 'Sidebar Content',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_qF7uwP77c3Zy00P',
				'label' => 'Content',
				'name' => 'ppc_audit_content',
				'type' => 'wysiwyg',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'tabs' => 'all',
				'toolbar' => 'full',
				'media_upload' => 1,
				'delay' => 0,
			),
			array(
				'key' => 'field_ppKUHa06aRNcsQX',
				'label' => 'Numbered List',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_mHp6FOvcm2RmlJl',
				'label' => 'Number 1',
				'name' => 'ppc_audit_number_1',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => '',
			),
			array(
				'key' => 'field_pCjjscFm8AC59gu',
				'label' => 'Number 2',
				'name' => 'ppc_audit_number_2',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => '',
			),
			array(
				'key' => 'field_PnvZB9OJp7BC0bI',
				'label' => 'Number 3',
				'name' => 'ppc_audit_number_3',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_template',
					'operator' => '==',
					'value' => 'template-ppc-audit.php',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_kXUbHZ5XPI7Sa2u',
		'title' => 'Hero mobile image',
		'fields' => array(
			array(
				'key' => 'field_cx8ipZTDpOpmhFC',
				'label' => 'Mobile Image',
				'name' => 'mobile_hero_image',
				'type' => 'image',
				'instructions' => 'Background image for the page header hero on mobile and tablets. Recommended size: 768x768px',
				'required' => 0,
				'return_format' => 'array',
				'preview_size' => 'medium',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
				),
			),
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'case_study',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_p1VbBe1biBoidFP',
		'title' => 'Client URL',
		'fields' => array(
			array(
				'key' => 'field_c12ovKp21VvuJn2',
				'label' => 'Client Website',
				'name' => 'client_website',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'client',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	// Accordion
	acf_add_local_field_group(array(
		'key' => 'group_5f6db79fa3853',
		'title' => 'Accordion',
		'fields' => array(
			array(
				'key' => 'field_1f6t1uolrxq8xz2',
				'label' => 'Title',
				'name' => 'accordion_title',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_5f6db7a4e6a2f',
				'label' => 'Accordion',
				'name' => 'accordion',
				'type' => 'repeater',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'collapsed' => 'field_5f6db7b1e6a30',
				'min' => 0,
				'max' => 0,
				'layout' => 'block',
				'button_label' => 'Add item',
				'sub_fields' => array(
					array(
						'key' => 'field_5f6db7b1e6a30',
						'label' => 'Title',
						'name' => 'container_title',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
					array(
						'key' => 'field_5f6db7b8e6a31',
						'label' => 'Content',
						'name' => 'content',
						'type' => 'wysiwyg',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'tabs' => 'all',
						'toolbar' => 'full',
						'media_upload' => 1,
						'delay' => 0,
					),
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/accordion',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	// Ratings
		acf_add_local_field_group(array(
			'key' => 'group_5f96ebe448f75',
			'title' => 'Ratings',
			'fields' => array(
				array(
					'key' => 'field_5f96ec6755068',
					'label' => 'Ratings Title',
					'name' => 'ratings_title',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_5f96ec2455067',
					'label' => 'Facebook Rating',
					'name' => 'ratings_number',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => 5,
					'step' => '',
				),
				array(
					'key' => 'field_5f96ec2455069',
					'label' => 'Glassdoor Rating',
					'name' => 'ratings_number2',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => 5,
					'step' => '',
				),
				array(
					'key' => 'field_5f96ec2455070',
					'label' => 'Google Rating',
					'name' => 'ratings_number3',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => 5,
					'step' => '',
				),
			),
			'location' => array(
				array(
					array(
						'param' => 'block',
						'operator' => '==',
						'value' => 'acf/ratings',
					),
				),
			),
			'menu_order' => 0,
			'position' => 'normal',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => '',
		));
		
endif;
