<?php
/* Register Case Studies */
add_action( 'init', 'register_case_study_type' );
function register_case_study_type() {
    $labels = array(
        'name'               => _x( 'Case Studies', 'Case Studies' ),
        'singular_name'      => _x( 'Case Study', 'case study'),
        'menu_name'          => _x( 'Case Studies', 'Case Studies'),
        'name_admin_bar'     => _x( 'Case Study', 'add new case study'),
        'add_new'            => _x( 'Add New', 'Case Study'),
        'add_new_item'       => __( 'Add New Case Study'),
        'new_item'           => __( 'New Case Study'),
        'edit_item'          => __( 'Edit Case Study'),
        'view_item'          => __( 'View Case Study'),
        'all_items'          => __( 'All Case Studies'),
        'search_items'       => __( 'Search Case Studies'),
        'parent_item_colon'  => __( 'Parent Case Studies:'),
        'not_found'          => __( 'No case studies found.'),
        'not_found_in_trash' => __( 'No case studies found in Bin.')
    );
    $args = array(
        'labels'             => $labels,
        'description'        => __( 'Create a case study listing.'),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'our-work','with_front' => false ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-portfolio',
        'show_in_rest'       => true,
        'taxonomies'          => array( 'case_study_categories' ),
        'supports'           => array( 'title', 'editor' , 'thumbnail', 'excerpt', 'author', 'custom-fields', 'page-attributes')
    );
    register_post_type( 'case_study', $args );
}

function create_case_study_taxonomies() {
    $labels = array(
        'name'              => _x( 'Categories', 'Case Studies' ),
        'singular_name'     => _x( 'Category', 'Case Study' ),
        'search_items'      => __( 'Search Categories' ),
        'all_items'         => __( 'All Categories' ),
        'parent_item'       => __( 'Parent Category' ),
        'parent_item_colon' => __( 'Parent Category:' ),
        'edit_item'         => __( 'Edit Category' ),
        'update_item'       => __( 'Update Category' ),
        'add_new_item'      => __( 'Add New Category' ),
        'new_item_name'     => __( 'New Category Name' ),
        'menu_name'         => __( 'Categories' ),
    );

    $args = array(
        'hierarchical'      => true, // Set this to 'false' for non-hierarchical taxonomy (like tags)
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'our-work/category','with_front' => false ),
	    'show_in_rest'      => true,
    );

    register_taxonomy( 'case_study_categories', array( 'case_study' ), $args );
}
add_action( 'init', 'create_case_study_taxonomies', 0 );

/* Register Careers */
add_action( 'init', 'register_careers_type' );
function register_careers_type() {
    $labels = array(
        'name'               => _x( 'Careers', 'Careers' ),
        'singular_name'      => _x( 'Career', 'career'),
        'menu_name'          => _x( 'Careers', 'Careers'),
        'name_admin_bar'     => _x( 'Career', 'add new career'),
        'add_new'            => _x( 'Add New', 'Careers'),
        'add_new_item'       => __( 'Add New Careers'),
        'new_item'           => __( 'New Career'),
        'edit_item'          => __( 'Edit Career'),
        'view_item'          => __( 'View Career'),
        'all_items'          => __( 'All Careers'),
        'search_items'       => __( 'Search Careers'),
        'parent_item_colon'  => __( 'Parent Careers:'),
        'not_found'          => __( 'No careers found.'),
        'not_found_in_trash' => __( 'No careers found in Bin.')
    );
    $args = array(
        'labels'             => $labels,
        'description'        => __( 'Create a careers listing.'),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'careers', 'with_front' => false ),
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-id',
        'show_in_rest'       => true,
        'supports'           => array( 'title', 'editor' , 'thumbnail', 'excerpt', 'author', 'custom-fields')
    );
    register_post_type( 'careers', $args );
}

/* Register Team Members */
add_action( 'init', 'register_team_type' );
function register_team_type() {
    $labels = array(
        'name'               => _x( 'Team Members', 'Team Members' ),
        'singular_name'      => _x( 'Team Member', 'Team Member'),
        'menu_name'          => _x( 'Team Members', 'Team Members'),
        'name_admin_bar'     => _x( 'Team Member', 'add new Team Member'),
        'add_new'            => _x( 'Add New', 'Team Members'),
        'add_new_item'       => __( 'Add New Team Member'),
        'new_item'           => __( 'New Team Member'),
        'edit_item'          => __( 'Edit Team Member'),
        'view_item'          => __( 'View Team Member'),
        'all_items'          => __( 'All Team Members'),
        'search_items'       => __( 'Search Team Members'),
        'parent_item_colon'  => __( 'Parent Team Members:'),
        'not_found'          => __( 'No Team Members found.'),
        'not_found_in_trash' => __( 'No Team Members found in Bin.')
    );
    $args = array(
        'labels'             => $labels,
        'description'        => __( 'Add a Team Member.'),
        'public'             => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'team-member' ),
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-admin-users',
        'show_in_rest'       => true,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'supports'           => array( 'title', 'thumbnail', 'custom-fields', 'page-attributes')
    );
    register_post_type( 'team', $args );
}

/* Register Clients */
add_action( 'init', 'register_client_type' );
function register_client_type() {
    $labels = array(
        'name'               => _x( 'Clients', 'Clients' ),
        'singular_name'      => _x( 'Client', 'Client'),
        'menu_name'          => _x( 'Clients', 'Clients'),
        'name_admin_bar'     => _x( 'Client', 'Add New Client'),
        'add_new'            => _x( 'Add New', 'Clients'),
        'add_new_item'       => __( 'Add New Client'),
        'new_item'           => __( 'New Client'),
        'edit_item'          => __( 'Edit Client'),
        'view_item'          => __( 'View Clients'),
        'all_items'          => __( 'All Clients'),
        'search_items'       => __( 'Search Clients'),
        'parent_item_colon'  => __( 'Parent Clients:'),
        'not_found'          => __( 'No Clients found.'),
        'not_found_in_trash' => __( 'No Clients found in Bin.')
    );
    $args = array(
        'labels'             => $labels,
        'description'        => __( 'Add a Client.'),
        'public'             => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'client' ),
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-admin-users',
        'show_in_rest'       => true,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'supports'           => array( 'title', 'thumbnail', 'page-attributes')
    );
    register_post_type( 'client', $args );
}

/* Register Testimonial */
add_action( 'init', 'register_testimonial_type' );
function register_testimonial_type() {
    $labels = array(
        'name'               => _x( 'Testimonials', 'Testimonials' ),
        'singular_name'      => _x( 'Testimonial', 'Testimonial'),
        'menu_name'          => _x( 'Testimonials', 'Testimonials'),
        'name_admin_bar'     => _x( 'Testimonial', 'Add New Testimonial'),
        'add_new'            => _x( 'Add New', 'Testimonials'),
        'add_new_item'       => __( 'Add New Testimonial'),
        'new_item'           => __( 'New Testimonial'),
        'edit_item'          => __( 'Edit Testimonial'),
        'view_item'          => __( 'View Testimonials'),
        'all_items'          => __( 'All Testimonials'),
        'search_items'       => __( 'Search Testimonials'),
        'parent_item_colon'  => __( 'Parent Testimonials:'),
        'not_found'          => __( 'No Testimonials found.'),
        'not_found_in_trash' => __( 'No Testimonials found in Bin.')
    );
    $args = array(
        'labels'             => $labels,
        'description'        => __( 'Add a Testimonial.'),
        'public'             => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'testimonial' ),
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-admin-users',
        'show_in_rest'       => true,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'supports'           => array( 'title', 'thumbnail', 'custom-fields', 'page-attributes')
    );
    register_post_type( 'testimonial', $args );
}