<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package activewin
 */

get_header();
?>
    <main id="main" class="content">
        <section class="blog-first-section">
            <div class="container">
                <div class="row category-dropdown">
                    <!-- ourwork dropdown list -->
                    <div class="col-12 text-center">
                        <div class="ourwork-dropdown">
                            <p class="showing-droplist">Showing</p>
                            <div class="dropdown">
                                <div class="select">
                                    <span>all categories</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                        <g fill="none" fill-rule="evenodd">
                                            <path fill="#ff5757" fill-rule="nonzero"
                                                  d="M4.646 10.723l5.64 5.64c.848.85 2.22.85 3.07 0l5.64-5.64C20.365 9.352 19.386 7 17.448 7H6.17c-1.937 0-2.895 2.352-1.523 3.723z"/>
                                            <path d="M0 0h24v24H0z"/>
                                        </g>
                                    </svg>
                                </div>
                                <div class="dropdown-menu">
                                    <?php
                                    if (!is_home()) :
                                        echo '<a href="'.get_permalink( get_option( 'page_for_posts' ) ).'" alt="View all blog posts"><p>All Categories</p></a>';
                                    endif;
                                    $categories = get_categories( array(
                                        'orderby' => 'name',
                                        'order'   => 'ASC'
                                    ) );
                                    foreach( $categories as $category ) {
                                        if ($category->term_id != 1) {
                                            $category_link = sprintf(
                                                '<a href="%1$s" alt="%2$s"><p>%3$s</p></a>',
                                                esc_url( get_category_link( $category->term_id ) ),
                                                esc_attr( sprintf( __( 'View all posts in %s' ), $category->name ) ),
                                                esc_html( $category->name )
                                            );
                                            echo $category_link;
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">

                    <?php
                    $args = array(
                        'post_type' => 'post',
                        'post_status' => 'publish',
                        'orderby'   => 'publish_date',
                        'order'   => 'DESC'
                    );

                    $query = new WP_Query( $args );

                    if ( $query->have_posts() ) :
                        $postCount = 0;

                        /* Start the Loop */
                        while ( $query->have_posts() ) :
                            $query->the_post();
                            ?><script>console.log('<?php echo get_the_date(); ?>');</script>
                        <?php
                            /*
                             * Include the Post-Type-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                             */
                            include(locate_template( 'template-parts/content.php', false, false) );
                            $postCount ++;

                        endwhile; ?>

                    <?php

                    else :

                        get_template_part( 'template-parts/content', 'none' );

                    endif;
                    ?>
                </div>
                <?php if ( $GLOBALS['wp_query']->max_num_pages > 1 ) : ?>
                <div class="row">
                    <div class="col-12">
                        <button class="blog-more-button" id="blog-more">MORE</button>
                        <div id="noMorePosts"></div>
                    </div>
                </div>
                <?php endif; ?>

                <?php
                ?>
                <span id="blogInfo" data-cat="" data-nonce="<?php echo wp_create_nonce("load_more_posts"); ?>"></span>

            </div>
        </section>
    </main>
<?php
get_footer();
