<?php

get_header('work-category');
?>
    <main id="main" class="content">
        <section class="blog-first-section work-section">
            <div class="container">
                <div class="row category-dropdown">
                    <!-- ourwork dropdown list -->
                    <div class="col-12 text-center">
                        <div class="ourwork-dropdown">
                            <p class="showing-droplist">Showing</p>
                            <div class="dropdown">
                                <div class="select">
                                    <span><?php echo single_term_title(); ?></span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                        <g fill="none" fill-rule="evenodd">
                                            <path fill="#ff5757" fill-rule="nonzero"
                                                  d="M4.646 10.723l5.64 5.64c.848.85 2.22.85 3.07 0l5.64-5.64C20.365 9.352 19.386 7 17.448 7H6.17c-1.937 0-2.895 2.352-1.523 3.723z"/>
                                            <path d="M0 0h24v24H0z"/>
                                        </g>
                                    </svg>
                                </div>
                                <div class="dropdown-menu">
                                    <a href="/our-work/" alt="View all of our work"><p>All Categories</p></a>
                                    <?php
                                    $categories = get_terms( 'case_study_categories', array(
                                        'orderby' => 'name',
                                        'order'   => 'ASC',
                                    ) );
                                    foreach( $categories as $category ) {
                                        $category_link = sprintf(
                                            '<a href="%1$s" alt="%2$s"><p>%3$s</p></a>',
                                            esc_url( get_category_link( $category->term_id ) ),
                                            esc_attr( sprintf( __( 'View all posts in %s'), $category->name ) ),
                                            esc_html( $category->name )
                                        );
                                        echo $category_link;
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php

                    if ( have_posts() ) :
                        $postCount = 0;

                        /* Start the Loop */
                        while ( have_posts() ) :
                            the_post();

                            /*
                             * Include the Post-Type-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                             */
                            include(locate_template( 'template-parts/content-work.php', false, false) );
                            $postCount ++;

                        endwhile;

                        the_posts_navigation();

                    else :

                        get_template_part( 'template-parts/content', 'none' );

                    endif;
                    ?>
                </div>

            </div>

	        <?php
	        $limit = '-1';
	        include( locate_template( 'template-parts/blocks/block-clients.php', false, false ) ); ?>

        </section>
    </main>

<?php
get_footer();