<?php
/**
 * Template Name: Contact
 */
get_header('contact');
$globalEmail = get_field('global_email','option');
$globalPhone = get_field('global_phone','option');
$globalOfficeAdd1 = get_field('global_office_1','option');
$globalManchesterMap = get_field('global_manchester_map','option');
$globalOfficeMap1 = get_field('global_directions_1','option');
?>
<main id="main" class="content">
    <div id="contact-page-wrap" class="contact-content">
        <div class="contact-container" >
            <div class="contact-form">
                <h2>get in touch</h2>
                <?php get_template_part('template-parts/form', 'contact'); ?>
            </div>
        </div>

        <div class="map-container" >
            <div class="contact-map">
                <div class="col-md-12">
                    <div class="contact-right">
                        <h3>Find Us</h3>
                        <p><?php echo $globalOfficeAdd1; ?></p>
                        <a href="<?php echo $globalOfficeMap1; ?>" title="Get Directions" class="exit-directions">Get directions
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">
                                <defs>
                                    <path id="c" d="M7.79 13.29c.39.39 1.02.39 1.41 0l3.59-3.59a.996.996 0 0 0 0-1.41L9.2 4.7a.996.996 0 1 0-1.41 1.41L9.67 8H1c-.55 0-1 .45-1 1s.45 1 1 1h8.67l-1.88 1.88c-.39.39-.38 1.03 0 1.41zM16 0H2a2 2 0 0 0-2 2v3c0 .55.45 1 1 1s1-.45 1-1V3c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1H3c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1v3c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2z"/>
                                </defs>
                                <g fill="none" fill-rule="evenodd">
                                    <path d="M0 0h24v24H0z"/>
                                    <g transform="translate(3 3)">
                                        <mask id="d" fill="#fff">
                                            <use xlink:href="#c"/>
                                        </mask>
                                        <use fill="#ff5757" fill-rule="nonzero" xlink:href="#c"/>
                                        <g fill="#ff5757" mask="url(#d)">
                                            <path d="M-3-3h24v24H-3z"/>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </a>
                        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1057.633044960528!2d-2.244771608433899!3d53.48086317281041!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x819b51796ec549e6!2sActiveWin%20Media!5e0!3m2!1sen!2suk!4v1573643195064!5m2!1sen!2suk" width="300" height="300" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
                        <div class="contact-contact">
                            <div>
                                <h3>give us a call</h3>
	                            <?php $phoneReplace = str_replace(' ','', $globalPhone); ?>
                                <a href="tel:<?php echo $phoneReplace; ?>" title="<?php echo $globalPhone; ?>"><?php echo $globalPhone; ?></a>
                            </div>
                            <div>
                                <h3>send us an email</h3>
                                <a href="mailto:<?php echo $globalEmail; ?>?subject=ActiveWin Website Request" title="<?php echo $globalEmail; ?>"><?php echo $globalEmail; ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php
get_footer();
