<?php
$title = get_field('accordion_title');
$accordion = get_field('accordion');
?>

<?php
if( have_rows('accordion') ):
?>

<!--  Accordion -->
<div class="container">
    <div class="accordion">
        <h2><?php echo $title; ?></h2>

        <?php
            while ( have_rows('accordion') ) : the_row();
                $accordionTitle = get_sub_field('container_title');
                $accordionContent = get_sub_field('content');
        ?>
        <?php if ($accordionTitle) : ?>

            <div class="accordion-container">
                <button>
                    <h4><?php echo $accordionTitle; ?></h4>
                    <figure class="expand"></figure>
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><title>icon/arrow/down</title><g id="icon/arrow/down" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="arrow_drop_down-24px"><polygon id="Path" points="0 0 24 0 24 24 0 24"></polygon><path d="M3.77468182,10.4681546 L10.5422376,17.2357104 C11.5612904,18.2547632 13.2074526,18.2547632 14.2265054,17.2357104 L20.9940612,10.4681546 C22.6402235,8.82199238 21.4643933,6 19.1388625,6 L5.60375095,6 C3.2782202,6 2.1285196,8.82199238 3.77468182,10.4681546 Z" id="Path" fill="#DCDCDC" fill-rule="nonzero"></path></g></g>
                    </svg>
                </button>

                <article>
                    <?php echo $accordionContent; ?>
                </article>
            </div>

        <?php endif; ?>
        <?php endwhile; ?>

    </div>
</div>

<?php endif; ?>
<!--  Accordion END-->