<?php
$title = get_field('blog_title');
?>
<!-- Latest Blogs -->
<section id="homepageBlog">
    <div class="container">
        <h2><a href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>"><?php echo empty($title) ? "Blog" :  $title; ?></a></h2>
            <div class="row">
                <?php
                // WP_Query arguments
                $args = array (
                    'post_type'              => 'post',
                    'posts_per_page'        => '6'
                );
                // The Query
                $blogs= new WP_Query( $args );
                // The Loop
                if ( $blogs->have_posts() ) {
                    while ( $blogs->have_posts() ) {
                        $blogs->the_post();
                        $post_date = get_the_date( 'F j Y' );
                        $categories = get_the_category();
                        ?>
                        <div class="col-12 col-md-12 col-lg-4">
                            <div class="row">
                                <div class="col-12 col-md-6 col-lg-12">
                                    <a href="<?php the_permalink(); ?>" aria-label="<?php the_title(); ?>">
                                        <div class="zoom-wrap">
                                            <div class="blog-image-box lazy"
                                                 data-bg="url(<?php the_post_thumbnail_url( 'medium' ); ?>)"></div>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-12 col-md-6 col-lg-12 blog-post-content">
                                    <?php if ( ! empty( $categories ) ) {
	                                    $category_link = get_category_link( $categories[0]->term_id );
	                                    echo '<a class="blog-post-link" href="'.esc_url( $category_link ).'" title="'.esc_html( $categories[0]->name ).'">'.esc_html( $categories[0]->name ).'</a>';
                                    } ?>
                                    <p class="blog-post-date">&nbsp; <?php echo $post_date; ?></p>
                                    <a class="blog-links" href="<?php the_permalink(); ?>" aria-label="<?php the_title(); ?>"><h3 class="blog-post-header"><?php the_title(); ?></h3></a>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                wp_reset_postdata(); ?>
            </div>
    </div>
</section>
<!-- End latest blogs -->