<?php
if (get_field('brochure_title')) :
    $title = get_field('brochure_title');
else :
    $title = "Request a brochure";
endif;
if (get_field('brochure_text')) :
    $text = get_field('brochure_text');
else :
    $text = "Sign up to our newsletter and keep up to date with our latest news, thoughts and events";
endif;
if (get_field('brochure_pp')) :
    $ppUrl = get_field('brochure_pp');
else :
    $ppUrl = "#";
endif;


?>
<!-- Request brochure -->
<section class="brochure-section">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-6">
                <img class="brochure-arrow" src="<?php echo get_template_directory_uri().'/img/brochure-arrow.svg';?>" alt="full-arrow">
                <img class="brochure-halfarrow" src="<?php echo get_template_directory_uri().'/img/brochure-halfarrow.svg';?>" alt="full-arrow">

                <h2 class="brochure-header"><?php echo $title; ?></h2>
                <p class="brochure-text"><?php echo $text; ?></p>
            </div>
            <div class="col-12 col-lg-6">
                    <form id="requestBrochure">
                        <div class="row">
                            <div class="col-12 col-md-6 col-lg-6 brochure-email-input">
                                <p class="brochure-email"><b>Email*</b></p>
                                <input class="brochure-email-border" type="text" name="email-input" id="email-input">
                                <span id="email-validation"></span>
                            </div>
                            <div class="col-12 col-md-6 col-lg-6 brochure-sign-wrap">
                                <button type="submit" class="brochure-sign-button">SIGN UP!</button>
                            </div>
                        </div>
                    </form>
                    <div class="col-12 eprivacy-info">
                        <p class="brochure-text">Your email address is stored securely and will never be shared with any third parties. For further details, please read our <a href="<?php echo $ppUrl; ?>" class="brochure-privacy-policy" title="Privacy Policy">Privacy Policy</a></p>
                    </div>
            </div>

        </div>
    </div>
</section>
<!-- End Request brochure -->