<?php
$title = get_field('careers_title');
$text = get_field('careers_text');
$alternate = get_field('careers_alternate', false, false);
?>
<!-- Career listings -->
<section class="careers-hiring" id="career-openings">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-4 col-xl-5">
                <h2 class="careers-h2-hiring" style="margin-top:0;"><?php echo empty($title) ? "Careers" :  $title; ?></h2>
                <?php echo $text; ?>
            </div>
            <div class="col-12 col-lg-8 col-xl-7">
                <?php
                // WP_Query arguments
                $args = array (
                    'post_type'              => array( 'careers' ),
                    'post_status'            => array( 'publish' ),
                    'posts_per_page'        => '-1',
                );
                $careers= new WP_Query( $args );
                if ( $careers->have_posts() ) {
                    $count = 0;
	                while ( $careers->have_posts() ) {
	                    $count++;
		                $careers->the_post();
		                $jobLocation = get_field('job_location', get_the_ID()); ?>
                        <a href="<?php the_permalink(); ?>" aria-label="<?php the_title(); ?>">
                            <div class="job-roles<?php if($count == 1) { echo " job-role-listing";}?>">
                                <h3 class="job-header"> <?php the_title();?> </h3>
                                <?php
                                if ($jobLocation) : ?>
                                    <p class="job-description">
                                        <?php echo $jobLocation; ?> <img class="fa-long-arrow-alt-right" src="<?php echo get_template_directory_uri().'/img/icon-arrow-right.svg';?>">
                                    </p>
                                <?php else : ?>
                                    <p class="job-description">
		                                <img class="fa-long-arrow-alt-right" src="<?php echo get_template_directory_uri().'/img/icon-arrow-right.svg';?>">
                                    </p>
                                <?php endif; ?>
                            </div>
                        </a>
                    <?php }
                } else { ?>
                        <div class="job-roles job-role-listing">
                            <p class="p-3 p-md-5"><?php echo $alternate; ?></p>
                        </div>
                <?php }
                ?>
            </div>
        </div>
    </div>
</section>
<!-- End of Careers -->