<?php
$url = get_field('case_studies_url');
$workLimit = get_field('case_studies_limit');
if ($workLimit == 0 || $workLimit == null){
	$workLimit = "-1";
}
?>
<!-- Our work slider -->
<section id="ourWorkSlider" class="our-work-slider-margin">
    <div class="container">
        <div class="row">
            <!-- title -->
            <div class="col-lg-12 our-work-slider-title">
                <?php

                if( $url ):
	                $link_url = $url['url'];
	                $link_title = $url['title'];
	                $link_target = $url['target'] ? $url['target'] : '_self';
	                ?>
                    <h2><a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></h2>
                <?php endif; ?>

            </div>
            <?php

            // WP_Query arguments
            $args = array(
	            'post_type'      => array( 'case_study' ),
	            'post_status'    => array( 'publish' ),
	            'posts_per_page' => $workLimit,
	            'order'          => 'ASC',
	            'orderby'        => 'menu_order'
            );

            // The Query
            $caseStudies = new WP_Query( $args ); ?>

            <div class="slider-our-work-slider extra-space slider-box">
            <?php
                // The Loop
                if ( $caseStudies->have_posts() ) {
                    $count = 0;
                    while ( $caseStudies->have_posts() ) {
                        $count++;
                        $caseStudies->the_post();
                        if (!get_the_post_thumbnail_url(get_the_ID())) {
                            $caseImg = get_template_directory_uri().'/img/homepage-hero.jpg';
                        } else {
                            $caseImgMobile = get_field('mobile_hero_image', get_the_ID());
                            $caseImg = get_the_post_thumbnail_url(get_the_ID());
                            $size = 'medium';
                            $caseImgMobile = $caseImgMobile['sizes'][$size];
                        }
	                    if ( $caseImgMobile ) :
		                    $bgImg = $caseImgMobile;
	                    else :
		                    $bgImg = $caseImg;
	                    endif;
                        ?>
                        <a class="lazy our-work-slider-each our-work-slider-each-1 work-slider-<?php echo $count; ?>"
                           data-bg="url(<?php echo $bgImg; ?>)"
                           style="
                           <?php if(get_field('overlay_colour', get_the_ID())) : ?>
                                   background-color: <?php echo get_field('overlay_colour', get_the_ID()); ?>;
                            <?php else: ?>
                                   background-color: #002933;
                           <?php endif; ?>
                           <?php if(!get_field('disable_overlay', get_the_ID())) : ?>
                                   background-blend-mode: overlay;
                           <?php endif; ?>"
                           href="<?php the_permalink(); ?>" aria-label="<?php the_title(); ?>">
                            <?php print_r(get_field('text_colour')); ?>
                            <h4 <?php if(get_field('text_colour', get_the_ID())) : ?>
                                    style="color:<?php echo get_field('text_colour', get_the_ID()); ?>"
                            <?php endif; ?>>
                                <?php the_title(); ?>
                            </h4>
                            <p <?php if(get_field('text_colour', get_the_ID())) : ?>
                                style="color:<?php echo get_field('text_colour', get_the_ID()); ?>"
                            <?php endif; ?>>
                                <?php
                                if (get_the_excerpt()) {
                                    echo limit_excerpt(get_the_excerpt(), 15);
                                }
                                ?></p>
                            <p  <?php if(get_field('link_colour', get_the_ID())) : ?>
                                    style="color:<?php echo get_field('link_colour', get_the_ID()); ?>!important;"
                                    <?php endif; ?>class="slider-link" title="<?php the_title(); ?>">View the case study</p>
                        </a>
                        <?php
                    }
                }
                wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
    <div id="prev" class="prev">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="192" height="100" viewBox="0 0 192 100">
            <defs>
                <path id="e" d="M0 100l34.802-88.554C37.022 4.782 44.08-.25 51.474.01L192 .14V100H0z"/>
                <path id="f" d="M24.02 4.599H2c-1.1 0-2 .9-2 2s.9 2 2 2h22.02v3.58c0 .9 1.08 1.34 1.7.7l5.56-5.58c.38-.4.38-1.02 0-1.42L25.72.299c-.62-.64-1.7-.18-1.7.7v3.6z"/>
            </defs>
            <g fill="none" fill-rule="evenodd">
                <g>
                    <mask id="g" fill="#fff">
                        <use xlink:href="#e"/>
                    </mask>
                    <use class="hoverFill" fill="#FF2E51" xlink:href="#e"/>
                    <g class="hoverFill" fill="#ff5757" mask="url(#g)">
                        <path d="M0 0h192v100H0z"/>
                    </g>
                </g>
                <path d="M72 26h48v48H72z"/>
                <g transform="translate(80 44)">
                    <mask id="h" fill="#fff">
                        <use xlink:href="#f"/>
                    </mask>
                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#f"/>
                    <g fill="#FFF" mask="url(#h)">
                        <path d="M-8-18h48v48H-8z"/>
                    </g>
                </g>
            </g>
        </svg>
    </div>

    <div id="next" class="next">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="192" height="100" viewBox="0 0 192 100">
            <defs>
                <path id="z" d="M0 100l34.802-88.554C37.022 4.782 44.08-.25 51.474.01L192 .14V100H0z"/>
                <path id="x"
                      d="M24.02 4.599H2c-1.1 0-2 .9-2 2s.9 2 2 2h22.02v3.58c0 .9 1.08 1.34 1.7.7l5.56-5.58c.38-.4.38-1.02 0-1.42L25.72.299c-.62-.64-1.7-.18-1.7.7v3.6z"/>
            </defs>
            <g fill="none" fill-rule="evenodd">
                <g>
                    <mask id="y" fill="#fff">
                        <use xlink:href="#e"/>
                    </mask>
                    <use class="hoverFill" fill="#FF2E51" xlink:href="#e"/>
                    <g class="hoverFill" fill="#ff5757" mask="url(#g)">
                        <path d="M0 0h192v100H0z"/>
                    </g>
                </g>
                <path d="M72 26h48v48H72z"/>
                <g transform="translate(80 44)">
                    <mask id="w" fill="#fff">
                        <use xlink:href="#f"/>
                    </mask>
                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#f"/>
                    <g fill="#FFF" mask="url(#h)">
                        <path d="M-8-18h48v48H-8z"/>
                    </g>
                </g>
            </g>
        </svg>
    </div>
</section>
<!-- End of our work slider -->