<?php
$title = get_field('clients_title');

if (!isset($limit)) :
	$limit = get_field('clients_limit');
    if (!$limit) :
        $limit = '-1';
    endif;
endif;
?>
<!-- Start of Clients -->
<section id="clients">
    <div class="container">
        <h2><?php echo empty($title) ? "Clients" :  $title; ?></h2>
        <div class="row">
                <?php
                // WP_Query arguments
                $args = array (
                    'post_type'              => array( 'client' ),
                    'post_status'            => array( 'publish' ),
                    'posts_per_page'         => $limit,
                    'order'          => 'ASC',
                    'orderby'        => 'menu_order'
                );

                // The Query
                $clients = new WP_Query( $args );

                // The Loop
                if ( $clients->have_posts() ) {
                    while ( $clients->have_posts() ) {
                        $clients->the_post();
                        $url = get_field('client_website',  get_the_ID()); ?>
                        <div class="col-6 col-sm-3">
                            <?php if ($url) :
	                            $name = get_the_title();
	                            echo "<a href=\"$url\" rel=\"nofollow noreferrer\" target=\"_blank\" aria-label=\"$name\">";
	                            the_post_thumbnail( 'small', array( "class" => "lazy" ) );
                            echo "</a>";
                            else :
	                            the_post_thumbnail('small');
                            endif;
                                ?>
                        </div>
                        <?php
                    }
                }
                wp_reset_postdata(); ?>
        </div>
    </div>
</section>

<!-- End of clients -->