<?php

$title = get_field('cta_title');
$content = get_field('cta_content');
$cta = get_field('cta_link');
?>
<section class="cta-container">
    <div class="container">
        <div class="cta-blank">
            <div class="angle"></div>

            <?php if ($title) : ?>
            <h2><?php echo $title; ?></h2>
            <?php endif; ?>

            <?php if ($content) : ?>
                <p><?php echo $content; ?></p>
            <?php endif; ?>

            <?php if ($cta) :
                $ctaUrl = $cta['url'];
                $ctaTitle = $cta['title'];
                $ctaTarget = $cta['target'] ? $cta['target'] : '_self'; ?>
                <a class="button ghost-button" href="<?php echo esc_url( $ctaUrl ); ?>"
                   aria-label="<?php echo esc_html( $ctaTitle ); ?>"
                   target="<?php echo esc_attr( $ctaTarget ); ?>"><?php echo esc_html( $ctaTitle ); ?></a>
            <?php endif; ?>
        </div>
    </div>
</section>