<?php
$title = get_field('team_block_title');


// WP_Query arguments
$args = array(
    'post_type' => array('team'),
    'post_status' => array('publish'),
    'nopaging' => true,
    'order' => 'ASC',
    'orderby' => 'menu_order',
    'meta_query' => array(
	    array(
		    'key'     => 'include_meet_the_team',
		    'value'   => '"1"',
		    'compare' => 'LIKE'
	    )
    )
);


// The Query
$team = new WP_Query($args);
if ( $team->have_posts() ) :
?>
<section id="teamSlider" class="team-slider-margin">
    <div class="container">
        <div class="row">
            <!-- title -->
            <div class="col-lg-12 team-slider-title">
                <h2><?php echo empty($title) ? "Meet the team" :  $title; ?></h2>
            </div>

            <!-- Meet the team slider content Test -->
            <div class="slider-team-slider extra-space team-slider-box" id="meet-team-slider">
                <?php
                // The Loop

                    while ( $team->have_posts() ) {
                        $team->the_post();
                        $jobTitle = get_field('team_title',get_the_ID());
                        $bio = get_field('team_bio',get_the_ID());
                        ?>
                        <div class="team-slider-each">
                            <img class="lazy" src="<?php echo get_the_post_thumbnail_url(); ?>"
                                 alt="<?php the_title(); ?>">
                            <h4><?php the_title();?></h4>
                            <?php if ($jobTitle) :
                                echo "<p><strong>$jobTitle</strong></p>";
                            endif;
                            if ($bio) :
                                echo "<p>$bio</p>";
                            endif; ?>
                        </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <div id="prev" class="prev">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="192" height="100" viewBox="0 0 192 100">
            <defs>
                <path id="e" d="M0 100l34.802-88.554C37.022 4.782 44.08-.25 51.474.01L192 .14V100H0z"/>
                <path id="f" d="M24.02 4.599H2c-1.1 0-2 .9-2 2s.9 2 2 2h22.02v3.58c0 .9 1.08 1.34 1.7.7l5.56-5.58c.38-.4.38-1.02 0-1.42L25.72.299c-.62-.64-1.7-.18-1.7.7v3.6z"/>
            </defs>
            <g fill="none" fill-rule="evenodd">
                <g>
                    <mask id="g" fill="#fff">
                        <use xlink:href="#e"/>
                    </mask>
                    <use class="hoverFill" fill="#FF2E51" xlink:href="#e"/>
                    <g class="hoverFill" fill="#ff5757" mask="url(#g)">
                        <path d="M0 0h192v100H0z"/>
                    </g>
                </g>
                <path d="M72 26h48v48H72z"/>
                <g transform="translate(80 44)">
                    <mask id="h" fill="#fff">
                        <use xlink:href="#f"/>
                    </mask>
                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#f"/>
                    <g fill="#FFF" mask="url(#h)">
                        <path d="M-8-18h48v48H-8z"/>
                    </g>
                </g>
            </g>
        </svg>

    </div>

    <div id="next" class="next">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="192" height="100" viewBox="0 0 192 100">
            <defs>
                <path id="e" d="M0 100l34.802-88.554C37.022 4.782 44.08-.25 51.474.01L192 .14V100H0z"/>
                <path id="f" d="M24.02 4.599H2c-1.1 0-2 .9-2 2s.9 2 2 2h22.02v3.58c0 .9 1.08 1.34 1.7.7l5.56-5.58c.38-.4.38-1.02 0-1.42L25.72.299c-.62-.64-1.7-.18-1.7.7v3.6z"/>
            </defs>
            <g fill="none" fill-rule="evenodd">
                <g>
                    <mask id="g" fill="#fff">
                        <use xlink:href="#e"/>
                    </mask>
                    <use class="hoverFill" fill="#FF2E51" xlink:href="#e"/>
                    <g class="hoverFill" fill="#ff5757" mask="url(#g)">
                        <path d="M0 0h192v100H0z"/>
                    </g>
                </g>
                <path d="M72 26h48v48H72z"/>
                <g transform="translate(80 44)">
                    <mask id="h" fill="#fff">
                        <use xlink:href="#f"/>
                    </mask>
                    <use fill="#FFF" fill-rule="nonzero" xlink:href="#f"/>
                    <g fill="#FFF" mask="url(#h)">
                        <path d="M-8-18h48v48H-8z"/>
                    </g>
                </g>
            </g>
        </svg>

    </div>

</section>
<?php endif;
wp_reset_postdata();
?>