<?php
/**
 * Block Name: Services
 *
 * This is the template that displays the services block.
 */
$servicesLimit = get_field('services_limit');
if ($servicesLimit == 0 || $servicesLimit == null){
	$servicesLimit = "-1";
}
?>
<style>
	#services p {
		min-height:auto;
	}	
	
	#services a.button{
		color:#fff;
	}
	
	#services a.button:hover{
		color:#fff;
		text-decoration:underline;
	}
	
	.accordion .accordion-container button {
		background:none;
	}
	
	.accordion .accordion-container {
		border-bottom:solid 2px #dcdcdc;
		padding-top: 15px;
	}
	
	.accordion .accordion-container.open article {
		margin-bottom:3em;
	}
</style>
<section id="services" class="servicesHomepage">
    <div class="container">
        <?php $servicesTitle = get_field('services_title'); ?>
        <?php if (is_front_page()){ ?>
        <h2>
            <?php echo empty($servicesTitle) ? "Services" :  $servicesTitle; ?>
        </h2>
        <?php } else {
            if ($servicesTitle){
                echo "<h2>$servicesTitle</h2>";
            }
        } ?>

        <?php
        $args = array(
            'post_type'      => 'page',
            'posts_per_page' => $servicesLimit,
            'post_parent'    => '24',
            'order'          => 'ASC',
            'orderby'        => 'menu_order'
        );

        $parent = new WP_Query( $args );
        if ( $parent->have_posts() ) : ?>
            <div class="accordion">
						<?php $count = 0; while ( $parent->have_posts() ) : $parent->the_post(); $count++;?>
				<div class="accordion-container">
                <button>
                    <h4><?php the_title(); ?></h4>
                    <figure class="expand"></figure>
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><title>icon/arrow/down</title><g id="icon/arrow/down" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="arrow_drop_down-24px"><polygon id="Path" points="0 0 24 0 24 24 0 24"></polygon><path d="M3.77468182,10.4681546 L10.5422376,17.2357104 C11.5612904,18.2547632 13.2074526,18.2547632 14.2265054,17.2357104 L20.9940612,10.4681546 C22.6402235,8.82199238 21.4643933,6 19.1388625,6 L5.60375095,6 C3.2782202,6 2.1285196,8.82199238 3.77468182,10.4681546 Z" id="Path" fill="#DCDCDC" fill-rule="nonzero"></path></g></g>
                    </svg>
                </button>

                <article>
                    <p>
											<?php
									if (get_the_excerpt()) {
										echo limit_excerpt(get_the_excerpt(), 35);
									}
									?>
										</p>
										<a class="button" href="<?php the_permalink(); ?>" aria-label="read more on <?php the_title(); ?>">Find out
									more <i class="fas fa-long-arrow-alt-right"></i></a>
                </article>
            </div>
							
							
						<?php endwhile; ?>
			</div>

        <?php endif; wp_reset_postdata(); ?>
    </div>
</section>