<?php
$animate     = get_field( 'stat_counter_animation' );
$stat1       = get_field('stat_counter_1');
$stat1Desc   = get_field ('stat_counter_1_description');
$stat1Arrow  = get_field ('stat_counter_1_arrow');
$stat1Suffix = get_field( 'stat_counter_1_suffix' );
$stat2       = get_field('stat_counter_2');
$stat2Desc   = get_field ('stat_counter_2_description');
$stat2Arrow  = get_field ('stat_counter_2_arrow');
$stat2Suffix = get_field( 'stat_counter_2_suffix' );
$stat3       = get_field('stat_counter_3');
$stat3Desc   = get_field ('stat_counter_3_description');
$stat3Arrow  = get_field ('stat_counter_3_arrow');
$stat3Suffix = get_field( 'stat_counter_3_suffix' );

if ( ! $animate ) :
	$animation = " animate-stats";
else :
	$animation = null;
endif;
if ( $stat1 || $stat2 || $stat3 ) :
?>
<section class="stats-component<?php echo $animation; ?>" id="stat-counter">
    <div class="cta-blank-stats">
        <div class="container">
            <div class="row">
                <img class="stats-arrow" src="<?php echo get_template_directory_uri() . '/img/stats-arrow.svg'; ?>"
                     alt="stats-arrow">
				<?php if ( $stat1 ) : ?>
                    <div class="col-12 col-md-4">
                        <h2 class="stats-header"><span class="count <?php echo $stat1Arrow; ?>"
                                                       data-count="<?php echo $stat1; ?>"> <?php if ( ! $animation ) : echo $stat1; else: echo '0'; endif; ?></span><?php echo $stat1Suffix; ?>
                        </h2>
                        <p class="stats-text"><?php echo $stat1Desc; ?></p>
                    </div>
				<?php endif; ?>
				<?php if ( $stat2 ) : ?>
                    <div class="col-12 col-md-4">
                        <h2 class="stats-header"><span class="count <?php echo $stat2Arrow; ?>"
                                                       data-count="<?php echo $stat2; ?>"> <?php if ( ! $animation ) : echo $stat2; else: echo '0'; endif; ?></span><?php echo $stat2Suffix; ?>
                        </h2>
                        <p class="stats-text"><?php echo $stat2Desc; ?></p>
                    </div>
				<?php endif; ?>
				<?php if ( $stat3 ) : ?>
                    <div class="col-12 col-md-4">
                        <h2 class="stats-header"><span class="count <?php echo $stat3Arrow; ?>"
                                                       data-count="<?php echo $stat3; ?>"> <?php if ( ! $animation ) : echo $stat3; else: echo '0'; endif; ?></span><?php echo $stat3Suffix; ?>
                        </h2>
                        <p class="stats-text"><?php echo $stat3Desc; ?></p>
                    </div>
				<?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>