<?php

$title = get_field('team_cta_title');
$content = get_field('team_cta_content');
$cta = get_field('team_cta_link');
$currentPage = get_the_ID();
$post_object = get_field('team_cta_team_member');
if ($post_object) : ?>
<section class="blog-testimonials">
    <div class="container">
        <div class="row blog-testimonials-border">
            <div class="col-sm-12 col-md-5 col-lg-5">
                <div class="blog-image-testimonials">

                            <?php $post = $post_object;
                            setup_postdata( $post );
                            $image = get_field('team_lead_gen_image', $post->ID);
                            if (!$content) :
	                            $content = get_field('team_lead_gen_text', $post->ID);
                            endif;
                    echo '<img src="' . $image['url'] . '" alt="' . get_the_title( $post->ID ) . '" class="blog-testimonials-profile-pic lazy">'; ?>
                </div>
                <img src="<?php echo get_template_directory_uri().'/img/testimonials-arrow.svg';?>" alt="avatar" class="testimonials-arrow">
            </div>

            <div class="col-sm-12 col-md-7 col-lg-7">
                <?php if ($title) :
                    echo "<h3 class=\"blog-testimonials-header\">$title</h3>";
                endif; ?>
                <?php if ($content) :
                    echo "<p class=\"blog-testimonials-text\">$content</p>";
                endif; ?>
                <?php if ($cta) :
                    $ctaUrl = $cta['url'].'?team='.get_the_title($post->ID);
                    $ctaTitle = $cta['title'];
                    $ctaTarget = $cta['target'] ? $cta['target'] : '_self';
	                echo "<a class=\"button button-ghost\" href=\"$ctaUrl\" aria-label=\"$ctaTitle\">$ctaTitle</a>";
                endif; ?>
            </div>
        </div>
    </div>
</section>
	<?php
	wp_reset_postdata();
else :
	echo 'nothing to see here';
endif;?>