<?php
$testimonial = get_field('testimonial');
$type = get_field('testimonial_types');

if ($testimonial){
	$post = $testimonial;
	setup_postdata( $post );

$name = get_field('testimonial_name', $post->ID );
$title = get_field('testimonial_title', $post->ID );
$quote = get_field('testimonial_quote', $post->ID );
$tesType = get_field('testimonial_type', $post->ID);
$url = get_field('testimonial_url', $post->ID);

?>
<!-- Careers testimonials -->
<section id="careersTestimonials">
    <div class="container">
        <div class="careers-testimonials-border">
            <div class="col-12 <?php if (get_the_post_thumbnail_url( $post->ID )) : ?>col-md-7 <?php else : ?> col-md-12 <?php endif; ?>careers-testimonials-content">
                <p class="careers-testimonials-text">
                    "<?php echo $quote; ?>"
                </p>
                <p class="careers-testimonials-name"><b><?php echo $name; ?></b>  <?php echo $title;?><?php echo $url; ?></p>
                <?php if ($url) : ?>
                    <p class="careers-testimonials-text"><a href="<?php echo $url; ?>" target="_blank"><?php echo $url; ?></a></p>
                <?php endif; ?>
            </div>
            <?php if (get_the_post_thumbnail_url( $post->ID )) : ?>
            <div class="col-12 col-md-5 column-image-testimonials">
                <div class="testimonials-image-cropper">
                    <img src="<?php echo get_the_post_thumbnail_url( $post->ID ); ?>" alt="avatar"
                         class="testimonials-profile-pic lazy">
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- End of Careers testimonials -->
<?php
	wp_reset_postdata();
} else {
	$args = array(
		'post_type'      => 'testimonial',
		'orderby'        => 'rand',
		'posts_per_page' => '1',
		'meta_query' => array(
			array(
				'key'     => 'testimonial_type',
				'value'   => $type,
				'compare' => 'LIKE'
			)
		)
	);

	$testimonials = new WP_Query( $args );

	while ( $testimonials->have_posts() ) : $testimonials->the_post();
		$name = get_field('testimonial_name',  get_the_ID() );
		$title = get_field('testimonial_title',  get_the_ID() );
		$quote = get_field('testimonial_quote',  get_the_ID() );
        $url = get_field('testimonial_url', get_the_ID());
		?>
        <section class="careersTestimonials">
            <div class="container">
                <div class="careers-testimonials-border">
                    <div class="col-12 <?php if (get_the_post_thumbnail_url( get_the_ID() )) : ?>col-md-7 <?php else : ?> col-md-12 pr-1 <?php endif; ?>careers-testimonials-content">
                        <p class="careers-testimonials-text">
                            "<?php echo $quote; ?>"
                        </p>
                        <p class="careers-testimonials-name"><b><?php echo $name; ?></b>  <?php echo $title;?></p>
                        <?php if ($url) : ?>
                            <p class="careers-testimonials-text"><a href="<?php echo $url; ?>" target="_blank"><?php echo $url; ?></a></p>
                        <?php endif; ?>
                    </div>
                    <?php if (get_the_post_thumbnail_url( get_the_ID() )) : ?>
                    <div class="col-12 col-md-5 column-image-testimonials">
                        <div class="testimonials-image-cropper">
                            <img src="<?php echo get_the_post_thumbnail_url(get_the_ID());?>" alt="avatar" class="testimonials-profile-pic">
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
	<?php
	endwhile;
	wp_reset_postdata();
}?>

