<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package activewin
 */
$categories = get_the_category();
$post_date  = get_the_date( 'F j Y' );
$mobileHero = get_field( 'mobile_hero_image' );
$mobileHero = $mobileHero['url'];

?>
    <style>
        <?php if (get_the_post_thumbnail_url()) : ?>
        .work-box-<?php echo $postCount;?> {
            background-image: url('<?php echo get_the_post_thumbnail_url(); ?>');
            <?php if(get_field('overlay_colour')) : ?>
                background-color: <?php echo get_field('overlay_colour'); ?>;
                <?php else: ?>
                background-color: #002933;
            <?php endif; ?>
            <?php if(!get_field('disable_overlay')) : ?>
                background-blend-mode: overlay;
            <?php endif; ?>
        }
        <?php endif ; ?>
        <?php if ($mobileHero) : ?>
        @media (max-width: 1023px) {
            .work-box-<?php echo $postCount;?> {
                background-image: url('<?php echo $mobileHero; ?>');

                <?php if(get_field('overlay_colour')) : ?>
                background-color: <?php echo get_field('overlay_colour'); ?>;
                <?php else: ?>
                    background-color: #002933;
                <?php endif; ?>
                <?php if(!get_field('disable_overlay')) : ?>
                    background-blend-mode: overlay;
                <?php endif; ?>
            }
        }
        <?php endif; ?>
    </style>
<?php
if ($postCount > 0) : ?>

    <div class="col-sm-12 col-md-6">
        <a href="<?php the_permalink();?>" class="case-study-box work-box-<?php echo $postCount;?>">
            <h3><?php the_title(); ?></h3>
            <p><?php if (get_the_excerpt()) {
		            echo limit_excerpt(get_the_excerpt(), 15);
	            }?></p>
            <p class="case-study-link" >View the Case Study</p>
        </a>
    </div>
<?php else : ?>
    <!-- main post -->
    <div class="col-12">
        <a href="<?php the_permalink();?>" class="case-study-box work-box-<?php echo $postCount;?>">
            <h3><?php the_title(); ?></h3>
            <p><?php echo limit_excerpt(get_the_excerpt(), 15);?></p>
            <p class="case-study-link" >View the Case Study</p>
        </a>
    </div>
    <!-- main post -->
<?php endif; ?>
