<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package activewin
 */
$categories = get_the_category();

$post_date = get_the_date();
if ($postCount > 0) :
    if ($postCount == 5) :
            echo '</div>';
        echo '</div>';
//        get_template_part( 'template-parts/blocks/block', 'brochure' );
        echo '<div class="container">';
            echo '<div class="row" id="more-blog-posts">';
    endif;
    ?>
    <div class="col-12 col-md-12 col-lg-4">
        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="row">
                <div class="col-12 col-md-6 col-lg-12">
                    <a href="<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php the_title(); ?>">
                        <div class="zoom-wrap">
                            <div class="blog-image-box lazy" data-bg="url(<?php echo get_the_post_thumbnail_url(); ?>)">
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-12 col-md-6 col-lg-12 blog-post-content">
                    <?php if ( ! empty( $categories ) ) {
	                    $category_link = get_category_link( $categories[0]->term_id );
	                    echo '<a class="blog-post-link" href="' . esc_html( $category_link ) . '" aria-label="' . esc_html( $categories[0]->name ) . '">' . esc_html( $categories[0]->name ) . '</a>';
                    } ?><p class="blog-post-date">&nbsp; <?php echo $post_date; ?></p>
                    <a class="blog-links" href="<?php echo esc_url( get_permalink() ); ?>"
                       aria-label="<?php the_title(); ?>"><h3 class="blog-post-header"><?php the_title(); ?></h3></a>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <!-- main post -->
    <div class="col-12 col-md-12 col-lg-8">
        <a href="<?php echo esc_url( get_permalink() ); ?>">
            <div class="zoom-wrap-main">
                <div class="blog-post-mainimage lazy" data-bg="url(<?php echo get_the_post_thumbnail_url(); ?>)"></div>
            </div>
        </a>
        <div class="blog-post-content">
            <?php if ( ! empty( $categories ) ) {
	            $category_link = get_category_link( $categories[0]->term_id );
	            echo '<a class="blog-post-link" href="' . esc_html( $category_link ) . '" aria-label="' . esc_html( $categories[0]->name ) . '">' . esc_html( $categories[0]->name ) . '</a>';
            } ?><p class="blog-post-date">&nbsp; <?php echo $post_date; ?></p>
            <a class="blog-links" href="<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php the_title(); ?>">
                <h3 class="blog-post-mainheader"><?php the_title(); ?></h3></a>
        </div>
    </div>
    <!-- main post -->
<?php endif; ?>
