<?php
/**
 * Template Name: Work
 */

get_header();
?>
    <main id="main" class="content">
        <section class="padding-start blog-first-section work-section">
            <div class="container">
                <div class="row category-dropdown">
                    <!-- ourwork dropdown list -->
                    <div class="col-12 text-center">
                        <div class="ourwork-dropdown">
                            <p class="showing-droplist">Showing</p>
                            <div class="dropdown">
                                <div class="select">
                                    <span>all categories</span>
                                    <i class="fa fa-chevron-down"></i>
                                </div>
                                <div class="dropdown-menu">
                                    <?php
                                    if (!is_home()) :
	                                    echo '<a href="' . get_home_url() . '" alt="View all blog posts" aria-label="View all blog posts"><p>All Categories</p></a>';
                                    endif;
                                    $categories = get_terms( 'case_study_categories', array(
                                        'orderby' => 'name',
                                        'order'   => 'ASC',
                                    ) );
                                    foreach( $categories as $category ) {
                                        $category_link = sprintf(
	                                        '<a href="%1$s" alt="%2$s" aria-label="%2$s"><p>%3$s</p></a>',
                                            esc_url( get_category_link( $category->term_id ) ),
                                            esc_attr( sprintf( __( 'View all posts in %s'), $category->name ) ),
                                            esc_html( $category->name )
                                        );
                                        echo $category_link;
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php
                    $args = array('post_type'=>array('posts', 'case_study'));
                    query_posts($args);
                    if ( have_posts() ) :
                        $postCount = 0;

                        /* Start the Loop */
                        while ( have_posts() ) :
                            the_post();
                            /*
                             * Include the Post-Type-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                             */
                            include(locate_template( 'template-parts/content-work.php', false, false) );
                            $postCount ++;
                        endwhile;
                        the_posts_navigation();
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif;
                    ?>
                </div>
            </div>
        </section>
	    <?php get_template_part( 'template-parts/blocks/block', 'clients' ); ?>
    </main>
<?php
get_footer();
