<?php

$form_title = get_the_title();
$form_id = str_replace(' ', '-', strtolower(preg_replace('/[^[:alnum:][:space:]]/u', '', $form_title)));

echo '<form id="'.$form_id.'-form" class="content-form form-builder validate-form" data-path="'.get_bloginfo('template_directory').'" enctype="multipart/form-data">'; 
	echo '<fieldset>';
		
		if (get_field('form_title') == true) {
			echo '<div class="editable-content">';	
				echo '<h3 class="title">'.$form_title.'</h3>';
			echo '</div>';		
		}
		
		if (get_field('form_intro_text')) {
			echo '<div class="intro editable-content">';
				the_field('form_intro_text');
			echo '</div>';
		}
		
		if (have_rows('form_fields')) {

			$field = 0;
			
			while (have_rows('form_fields')) {
				
				the_row();
					
				$field_id = 'field-'.get_the_date('YmdHi').'-'.$field++;
					
				$field_type = get_row_layout();
				$field_class = get_row_layout();
				$field_label = get_sub_field('label');
				$field_name = str_replace(' ', '-', strtolower($field_label));

				$required_text = false;
				$required_attr = false;
				if (get_sub_field('required') == true) {
					$required_text = ' *';
					$required_attr = 'required';
				}

				echo'<div class="field '.$field_type.'">';
				
					//Multi Radio/Checkboxes
					if ($field_type == 'multicheckbox' || $field_type == 'multiradio') {
						
						if ($field_type == 'multicheckbox') $input_type = 'checkbox';
						if ($field_type == 'multiradio') $input_type = 'radio';

						echo '<p class="label">'.$field_label.$required_text.'</p>';
						
						if (get_sub_field('options')) {
							
							$option = 0;

							echo '<ul class="options">';
							
								while (has_sub_field('options')) {
								
									$field_id = $field_id.'-'.$option++;
								
									echo '<li class="option">';
										echo '<input type="'.$input_type.'" name="'.$field_type.'__'.$field_name.'[value][]" id="'.$field_id.'" value="'.get_sub_field('option').'" '.$required_attr.' />';
										echo '<label for="'.$field_id.'">'.get_sub_field('option').'</label>';
									echo '</li>';
									
								}
								
							echo '</ul>';
						
						}
							
					}
					else {
						
						//Checkbox
						if ($field_type == 'checkbox') {
							echo '<input type="checkbox" name="'.$field_type.'__'.$field_name.'[value]" id="'.$field_id.'" value="Yes" '.$required_attr.' />';
						}

						//Label
						echo '<label for="'.$field_id.'">'.$field_label.($field_type == 'date' ? ' (dd/mm/yyyy)' : '').$required_text.'</label>';
						
						//Inputs
						if ($field_type != 'checkbox') {
							
							
							if ($field_type == 'textarea') {
								
								//Textarea
									echo '<textarea title="'.$field_label.'" name="'.$field_type.'__'.$field_name.'[value]" id="'.$field_id.'" rows="'.get_sub_field('rows').'" '.$required_attr.'></textarea>';	
								
							}
							elseif ($field_type == 'select') {
								
								//Select
								echo '<select title="'.$field_label.'" name="'.$field_type.'__'.$field_name.'[value]" id="'.$field_id.'" '.$required_attr.'>';
								
									echo '<option value="">'.$field_label.$required_text.'</option>';
									
									if (get_sub_field('options')) {
										while (has_sub_field('options')) {
											echo '<option value="'.get_sub_field('option').'">'.get_sub_field('option').'</option>';	
										}
									}
									
								echo '</select>';
								
							}
							else {
								
								//Date Placeholder
								$field_js = false;
								if ($field_type == 'date') {
									$field_type = 'text';
								}

								//File Restrictions
								$file_attr = false;
								if ($field_type == 'file') {
									$file_types = implode(',', get_sub_field('types'));
									$file_size = get_sub_field('size').'000';
									$file_attr = 'data-types="'.str_replace('.', '', $file_types).'" data-size="'.$file_size.'"';
								}

								//Text, Email, Tel, Date Input
								if ($field_type == 'email') {
									$field_name = 'address';		
								}
								echo'<input class="'.$field_class.'-input" title="'.$field_label.'" type="'.$field_type.'" name="'.$field_type.'__'.$field_name.'[value]" id="'.$field_id.'" value="" '.$file_attr.' '.$required_attr.' />';

								//File Restrictions
								if ($field_type == 'file') {
									
									if ($file_size < 999999) {
										$file_text = round($file_size / 1000, 2).'KB';
									}
									else {
										$file_text = round($file_size / 1000000, 2).'MB';												
									}
								
									echo '<input type="hidden" name="'.$field_type.'__'.$field_name.'[accepted]" value="'.str_replace('.', '', $file_types).'" />';
									echo '<input type="hidden" name="'.$field_type.'__'.$field_name.'[limit]" value="'.$file_size.'" />';
									echo '<p class="info">('.str_replace(',', ', ', $file_types).' | '.$file_text.' max.)</p>';
									
								}

							}
						
						}
						
					}

					//Label Text
					echo '<input type="hidden" name="'.$field_type.'__'.$field_name.'[label]" value="'.$field_label.'" />';
					
				echo'</div>';

			}
			
		}

		//Honeypot
		echo '<div class="field honeypot">';
			echo '<label>Favourite Place</label>';
			echo '<input type="text" name="favourite-place" value="" />';
		echo '</div>';

		echo '<input type="hidden" name="site-title" value="'.get_bloginfo('name').'" />';
		echo '<input type="hidden" name="form-subject" value="'.get_field('form_email_subject').'" />';
		echo '<input type="hidden" name="form-recipient" value="'.get_field('form_recipient_email').'" />';
		echo '<input type="hidden" name="form-sender" value="'.get_field('form_sender_email').'" />';
		echo '<input type="hidden" name="form-page-url" value="'.home_url($wp->request).'" />';
		
		if (get_field('form_user_confirmation') == true && get_field('form_user_subject') && get_field('form_user_message')) {
			echo '<input type="hidden" name="form-user-subject" value="'.get_field('form_user_subject').'" />';
			echo '<input type="hidden" name="form-user-message" value="'.htmlspecialchars(get_field('form_user_message')).'" />';
		}

		echo '<div class="field controls">';
			echo '<p class="info">*required field</p>';
			echo '<button class="button theme-a submit">'.get_field('form_button_text').'</button>';
		echo '</div>';

	echo '</fieldset>';
	
	echo '<p class="success">'.get_field('form_success_message').'</p>';
	
echo '</form>';

?>