<?php


//Data Vars
	$exclude_fields = array('site-title', 'form-subject', 'form-recipient', 'form-sender', 'form-user-subject', 'form-user-message', 'form-page-url', 'favourite-place');
	$attachments = false;
	$form_errors = false;


//Validate AJAX Submission
	if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) AND strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
	    $form_errors[] = 'Request must be Ajax POST.';
	}


//Validate Uploads
	if ($_FILES) {
		
		//Create Directory
		$file_dir = $_SERVER['DOCUMENT_ROOT'].'/wp-content/form-uploads';
		if (!file_exists($file_dir)) {
		    mkdir($file_dir, 0777, true);
		}
		
		$i = 0;

		//Validate Files
		foreach ($_FILES as $key => $val) {
			
			if (isset($_POST[$key])) {
					
				$i++;
				
				$file_error = $val['error']['value'];
				
				if ($file_error != 4) {
				
					if ($file_error != 0) {
						
						$form_errors[] = 'File Error ('.$file_error.'), please upload file(s) again.';
						
					}
					else {
					
						//File Attributes
						$file_name = $val['name']['value'];
						$file_tmp_name = $val['tmp_name']['value'];
						$file_size = $val['size']['value'];
						$file_types = explode(',', $_POST[$key]['accepted']);
						$file_limit = $_POST[$key]['limit'];
						
						$file_name = str_replace(' ', '-', $file_name);
						
						$target_file = $file_dir.'/['.date('dmyHis').'-'.$i.']-'.basename($file_name);
						$upload_success = 1;
						
						//Check Type
						$file_extension = pathinfo($target_file, PATHINFO_EXTENSION);
						if (!in_array($file_extension, $file_types)) {
						    $upload_success = 0;
							$form_errors[] = '"'.$file_name.'" is an invalid file type, valid file types are "'.$_POST[$key]['accepted'].'".';
						}    
						
						//Check Size
						if ($upload_success == 1 && $file_size > $file_limit) {
						    $upload_success = 0;
						    $form_errors[] = '"'.$file_name.'" is '.round($file_size / 1000000, 2).'MB, this exceeds file size limit of '.round($file_limit / 1000000, 2).'MB.';
						}
						
						//Success
						if ($upload_success == 1) {
	
							//Upload File
							move_uploaded_file($file_tmp_name, $target_file);
							
							//Attach & Email File
							$attachments[] = $target_file;
							
						}
					
					}
				
				}
			
			}
			else {
			
				$form_errors[] = 'Accepted file types and size not found.';	
				
			}	
			
		}
		
	}
	
	
//Return Errors & Die
	if ($form_errors) {
		echo json_encode($form_errors);
		die();
	}


//Send Emails	
	$parse_uri = explode('wp-content', $_SERVER['SCRIPT_FILENAME']);
	require_once($parse_uri[0].'wp-load.php');

	//Headers
	$headers[] = 'MIME-Version: 1.0';
	$headers[] = 'Content-Type: text/html; charset=UTF-8';
	$headers[] = 'Reply-To: '.$_POST['form-sender'];
	$headers[] = 'From: '.$_POST['site-title'].' <'.$_POST['form-sender'].'>';
		
	//Client Email
	$client_content = '';

	//Fields
	foreach ($_POST as $key => $field) {
		
		//Exclude File Fields
		if (strpos($key, 'file__') === false) {
		
			//Exclude Hidden Fields
			if (!in_array($key, $exclude_fields) && $field['value']) {
				
				//Separate Radios/Checks
				if (is_array($field['value'])) {
					$client_content .= '<p><strong>'.$field['label'].':</strong><br />'.implode('<br />', $field['value']).'</p>';
				}
				else {
					$client_content .= '<p><strong>'.$field['label'].':</strong><br />'.$field['value'].'</p>';
				}
				
			}
		
		}
		
	}
	
	$client_content .= '<p><br />Sent from: '.$_POST['form-page-url'].'</p>';
	
	$client_email = wp_mail($_POST['form-recipient'], $_POST['form-subject'], $client_content, implode("\r\n", $headers), $attachments);
	
	//User Email
	if (isset($_POST['form-user-subject']) && !empty($_POST['form-user-subject']) && isset($_POST['form-user-message']) && !empty($_POST['form-user-message'])) {

		$user_content .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
		$user_content .= '<html xmlns="http://www.w3.org/1999/xhtml"><head><title>'.$_POST['form-subject'].'</title></head><body>';
		$user_content .= stripslashes($_POST['form-user-message']);
		$user_content .= '</body></html>';

		$user_email = wp_mail($_POST['email__address']['value'], $_POST['form-user-subject'], $user_content, implode("\r\n", $headers));
	
	}


//Email Sending
	if ($client_email) {
		
		//Delete Files
		if ($attachments) {
			foreach ($attachments as $attachment => $file) {
				unlink($file);
			}
		}

	}
	else {
		
		//Return Error
		echo json_encode(array('Email sending failed.'));
		
	}


?>
