jQuery(document).ready(function() {

//Fields

	//Placeholders
	jQuery('.content-form .text, .content-form .textarea, .content-form .email, .content-form .tel, .content-form .date').each(function() {
		var labelText = jQuery(this).find('label').text();
		jQuery(this).find('input[type!="hidden"], textarea').attr('placeholder', labelText);
	});

	//Custom Select
	if (jQuery('.content-form .select select').length) {
		jQuery('.content-form .select select').customSelect();
	}
	
	//Custom Upload
	if (jQuery('.content-form input.file-input').length) {
		
		jQuery('input.file-input').each(function() {
				
			var fileInput = jQuery(this),
				fileInputID = jQuery(this).attr('id'),
				fileLabel = jQuery('label[for="'+fileInputID+'"]'),
				fileLabelText = fileLabel.text();
			
			fileLabel.addClass('custom-upload').html('<span class="file-name">'+fileLabelText+'</span><span class="file-select">Browse</span>');
			
			fileInput.change(function() {
				var fileInputVal = jQuery(this).val(),
					fileName = jQuery(this).val().split(/\\/).pop();
				if (fileInputVal == '') {
					fileName = fileLabelText;
				}
				fileLabel.find('.file-name').addClass('selected').text(fileName);
			});	

		});
		
	
	}
	
	
//Validation

	jQuery('.validate-form').find('.controls .submit').click(function() {
		
		//Vars
		var formButton = jQuery(this),
			formEl = formButton.closest('form'),
			formID = formEl.attr('id'),
			formPath = formEl.attr('data-path'),
			mailerPath = formPath+'/assets/forms/form-builder-mailer.php';

		//Validate Form
		jQuery.extend(jQuery.validator.messages, {
		    required: 'Please complete this field.',
		});
	
		formEl.validate({
			ignoreTitle: true,
			errorPlacement: function(error, element) {
				jQuery(element).closest('.field').append(error).addClass('error-field');
			},
			errorElement: 'div',
			errorClass: 'error',
			rules: {
				email: {
					email: true
				}
			}			
		});

		//Validate Dates
		if (jQuery('input.date-input').length) {
			
			jQuery('#'+formID).rules('add', {
				dateISO: true
			});
			
		}

		//Validate Files
		if (formEl.find('input.file-input').length) {
			
			formEl.find('input.file-input').each(function() {
				
				var	formFile = jQuery(this).attr('id'),
					formFileTypes = jQuery(this).attr('data-types'),
					formFileSize = jQuery(this).attr('data-size');
					
				jQuery.validator.addMethod('filesize', function (value, element, param) {
				    return this.optional(element) || (element.files[0].size <= param)
				});

				jQuery('#'+formFile).rules('add', {
					extension: formFileTypes,
					filesize: formFileSize,
					messages: {
						extension: 'File type must be '+formFileTypes+'.',
		                filesize: 'File size must be less than '+formFileSize/1000000+'MB ('+formFileSize/1000+'KB).'
		            }
				});

			});
			
		}
		
		//Submit Form
		if (formEl.valid() == true && formEl.find('.honeypot input').val() == '') {
			
			formEl.find('.controls p.error').remove();
			formButton.prop('disabled', true);

			if (formEl.hasClass('non-builder')) {
				
				if (formEl.hasClass('script-submission')) {
					
					formEl.submit();

					return true;
					
				}
				else {
				
					jQuery.ajax({
						type: 'POST',
						url: formPath+'/assets/forms/'+formID+'-mailer.php',
						data: formEl.serialize(),
						cache: false,
						success: function() {
							formEl.find('fieldset').fadeOut(500,function(){
								formEl.find('p.success').fadeIn(500);
							});
						}
					});
					
				}
			
			}
			else {
				
				jQuery.ajax({
					type: 'POST',
					url: formPath+'/assets/forms/form-builder-mailer.php',
					data: new FormData(formEl[0]),
					enctype: 'multipart/form-data',
					contentType: false,
					processData: false,
					success: function(response) {
						
						if (response) {
								
							jQuery.each(response, function(key, val) {
								formEl.find('.controls').prepend('<p class="error file">'+val+'</p>');
							});
							
							formButton.prop('disabled', false);
							
						}
						else {
							
							formEl.find('fieldset').fadeOut(500,function(){
								formEl.find('p.success').fadeIn(500);
							});
							
						}					
	
					}
				});
			
			}

		}
		else {
			
			formEl.find('.controls p.error').remove();
			formEl.find('.controls').prepend('<p class="error">Please check all fields are completed correctly.</p>');
			
		}
		
		return false;
		
	});
	

});