jQuery(document).ready(function() {


	//Get Theme Path
	var themePath = jQuery('body').attr('data-theme-path');

	//Scroll Events
	var controller = new ScrollMagic.Controller();

	
	//Header
	new ScrollMagic.Scene({
		    triggerElement:'window',
		    triggerHook: 0,
		})
		//.addIndicators()
		.setClassToggle('#header', 'active')
		.offset(20)
		.addTo(controller);


	//Navigation
	jQuery('#header .nav-toggle').click(function(){
		jQuery('body').toggleClass('nav-active');
		return false;
	});


	//Animated Scrolling
	jQuery('.scroll').click(function(){
		var scrollToEl = jQuery(this).attr('href');
		jQuery('html, body').animate({
			scrollTop: jQuery(scrollToEl).offset().top - 100
		}, 1000);
		return false;
	});


	//Remove empty content
	jQuery('p').each(function() {
	    var emptyP = jQuery(this);
	    if(emptyP.html().replace(/\s|&nbsp;/g, '').length == 0)
	    emptyP.remove();
	});


	//Content Tables
    jQuery('.editable-content table').each(function() {
        jQuery(this).wrap('<div class="table-wrap"></div>');
    }); 


	//Content Iframes
    jQuery('iframe[src*="youtube.com"], iframe[src*="vimeo.com"]').each(function() {
        var url = jQuery(this).attr('src');
        jQuery(this).attr('src',url+'?rel=0').width('100%').height('100%').wrap('<div class="video-wrap"><div class="video"></div></div>');
    }); 

    jQuery('iframe[src*="https://www.google.com/maps/"]').each(function() {
        jQuery(this).width('100%').height('100%').wrap('<div class="map-wrap"></div>');
    }); 


	//Video Lightbox
	jQuery('.video-link').magnificPopup({
		disableOn: 0,
		type: 'iframe',
		mainClass: 'mfp-fade',
		removalDelay: 160,
		preloader: false,
		fixedContentPos: false
	});


	//Animated Text
	if (jQuery('#banner .typewrite').length) {
		
		var TxtType = function(el, toRotate, period) {
	        this.toRotate = toRotate;
	        this.el = el;
	        this.loopNum = 0;
	        this.period = parseInt(period, 10) || 2000;
	        this.txt = '';
	        this.tick();
	        this.isDeleting = false;
	    };
	
	    TxtType.prototype.tick = function() {
		    
	        var i = this.loopNum % this.toRotate.length;
	        var fullTxt = this.toRotate[i];
	
	        if (this.isDeleting) {
		        this.txt = fullTxt.substring(0, this.txt.length - 1);
	        }
	        else {
		        this.txt = fullTxt.substring(0, this.txt.length + 1);
	        }
	
	        this.el.innerHTML = '<span class="wrap">'+this.txt+'&nbsp;</span>';
	
	        var that = this;
	        var delta = 200 - Math.random() * 100;
	
	        if (this.isDeleting) {
		        delta /= 2;
		    }
	
	        if (!this.isDeleting && this.txt === fullTxt) {
		        delta = this.period;
		        this.isDeleting = true;
	        }
	        else if (this.isDeleting && this.txt === '') {
		        this.isDeleting = false;
		        this.loopNum++;
		        delta = 500;
	        }
	
	        setTimeout(function() {
		        that.tick();
	        }, delta);
	        
	    };
	
	    window.onload = function() {
		    
	        var elements = document.getElementsByClassName('typewrite');
	        
	        for (var i=0; i<elements.length; i++) {
	            var toRotate = elements[i].getAttribute('data-type');
	            var period = elements[i].getAttribute('data-period');
	            if (toRotate) {
	              new TxtType(elements[i], JSON.parse(toRotate), period);
	            }
	        }

	        var css = document.createElement("style");
	        css.type = "text/css";
	        document.body.appendChild(css);
	        
	    };	
	
	}
	
	
});
