<?php


//Initial Theme Setup
	if (!function_exists('custom_theme_setup')) {
		
		function custom_theme_setup () {
			
			//Delete Sample Page and Post
		    $default_page = get_page_by_title('Sample Page');
		    wp_delete_post($default_page->ID, $bypass_trash = true);
		    $default_post = get_posts(array('title' => 'Hello World!'));
		    wp_delete_post($default_post[0]->ID, $bypass_trash = true);
	
			//Create Home Page
			if (!get_page_by_title('Home')) {
				$homepage = wp_insert_post(
					array(
						'post_title'     => 'Home',
						'post_name'      => 'home',
						'post_content'   => '',
						'post_status'    => 'publish',
						'post_author'    => 1,
						'post_type'      => 'page'
					 )
				);
				update_option('show_on_front', 'page');
				update_option('page_on_front', $homepage);
			}

			//Disable Month/Year Media Library
			update_option('uploads_use_yearmonth_folders', false);

			//Create Default Permalinks
		    global $wp_rewrite;
		    $wp_rewrite->set_permalink_structure('/%category%/%postname%/');
		    $wp_rewrite->flush_rules();
	
		}
		add_action('after_switch_theme', 'custom_theme_setup');
		
	}


//Disable Options for Client Accounts
	function admin_role_options() {
	
		$caps = array(
			'manage_options',
			'update_core',
			'activate_plugins',
			'delete_plugins',
			'edit_plugins',
			'install_plugins',
			'update_plugins',
			'delete_themes',
			'edit_themes',
			'install_themes',
			'switch_themes',
			'update_themes',
			'export',
			'import'
		);
	
	    $role = get_role('administrator');
		foreach ($caps as $cap) {
		    $role->remove_cap($cap);
	    }
	    
	    $user = new WP_User(7);
		foreach ($caps as $cap) {
		    $user->add_cap($cap);
	    }
	
	    update_option('admin_role_options', 'done');

	}
//	add_action('user_register', 'admin_role_options');


//Remove Admin Links
	function custom_admin_menu_links() {
		if (get_current_user_id() != 7) {
		    remove_menu_page('options-general.php');
		    remove_menu_page('plugins.php');
		    remove_menu_page('tools.php');
		}		
		remove_menu_page('edit.php');		
	}
//	add_action('admin_menu', 'custom_admin_menu_links');


//Remove Admin Bar Links
	function remove_admin_bar_links() {
	    global $wp_admin_bar;
	    $wp_admin_bar->remove_menu('wp-logo');       
	    $wp_admin_bar->remove_menu('about');         
	    $wp_admin_bar->remove_menu('wporg');         
	    $wp_admin_bar->remove_menu('documentation'); 
	    $wp_admin_bar->remove_menu('support-forums');
	    $wp_admin_bar->remove_menu('feedback');      
	    $wp_admin_bar->remove_menu('updates');       
	    $wp_admin_bar->remove_menu('comments');      
	    $wp_admin_bar->remove_menu('new-content');   
	    $wp_admin_bar->remove_menu('customize');    
		$wp_admin_bar->remove_menu('wpseo-menu');
	}
//	add_action('wp_before_admin_bar_render', 'remove_admin_bar_links');


//Disable Yoast 'Make Primary'
	add_filter('wpseo_primary_term_taxonomies', '__return_empty_array');


//Move Yoast Meta Box
	function yoast_to_bottom() {
		return 'low';
	}
	add_filter( 'wpseo_metabox_prio', 'yoast_to_bottom');


//Hide Category Description
	function wpse_hide_cat_descr() {
	   echo '<style type="text/css">';
		    echo '#edittag {max-width:none;}';
		    echo '.term-description-wrap {display:none;}';
	   echo '</style>';
	} 
	add_action('admin_head-term.php', 'wpse_hide_cat_descr');
	add_action('admin_head-edit-tags.php', 'wpse_hide_cat_descr');


?>
