<?php

function custom_post_types_taxes() {
	
	//Custom Post Type
	register_post_type(
		'profile-post',
		array(
			'description' => 'Profiles',
			'labels' => array(
				'name' => 'Profiles',
				'singular_name' => 'Profile',
				'menu_name' => 'Profiles',
				'parent_item_colon' => 'Parent Profile',
				'all_items' => 'All Profiles',
				'view_item' => 'View Profile',
				'add_new_item' => 'Add New Profile',
				'add_new' => 'Add New',
				'edit_item'	=> 'Edit Profile',
				'update_item' => 'Update Profile',
				'search_items' => 'Search Profiles',
				'not_found' => 'No Profiles found',
				'not_found_in_trash' => 'No Profiles found in Bin',
			),
			'supports' => array('title', 'editor', 'revisions'),
			'hierarchical' => false,
			'public' => true,
			'show_ui' => true,
			'show_in_menu' => true,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'menu_position' => 10,
			'can_export' => true,
			'has_archive' => false,
			'exclude_from_search' => false,
			'publicly_queryable' => true,
			'capability_type' => 'post',
			'menu_icon' => 'dashicons-groups',
			'rewrite' => array(
				'slug' => 'meet-the-team'
			)
		)
	);
	
	register_post_type(
		'work-post',
		array(
			'description' => 'Work',
			'labels' => array(
				'name' => 'Work',
				'singular_name' => 'Work',
				'menu_name' => 'Work',
				'parent_item_colon' => 'Parent Work',
				'all_items' => 'All Work',
				'view_item' => 'View Work',
				'add_new_item' => 'Add New Work',
				'add_new' => 'Add New',
				'edit_item'	=> 'Edit Work',
				'update_item' => 'Update Work',
				'search_items' => 'Search Work',
				'not_found' => 'No Work found',
				'not_found_in_trash' => 'No Work found in Bin',
			),
			'supports' => array('title', 'editor', 'revisions'),
			'hierarchical' => false,
			'public' => true,
			'show_ui' => true,
			'show_in_menu' => true,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'menu_position' => 10,
			'can_export' => true,
			'has_archive' => false,
			'exclude_from_search' => false,
			'publicly_queryable' => true,
			'capability_type' => 'post',
			'menu_icon' => 'dashicons-video-alt',
			'rewrite' => array(
				'slug' => 'our-work'
			)
		)
	);
	
}
add_action('init', 'custom_post_types_taxes', 0);

?>