<?php


//Remove Outdated Link Attributes
	add_action('after_setup_theme', function() {
		add_theme_support('html5', ['script', 'style']);
	});


//Navigation
	register_nav_menus( array(
	    'primary' => 'Primary Navigation',
	    'secondary' => 'Secondary Navigation'
	));
	
	
//Navigation Titles
	add_filter('wp_nav_menu', function($nav_menu, $args) {
	
	    if (empty($args->heading))
	        return $nav_menu;
	
	    $title = esc_html($args->menu->name);
	    $heading = sprintf($args->heading, $title);
	
	    return $heading.$nav_menu;
	    
	}, 10, 2);


//Body Classes
	function add_custom_body_class($classes) {
		
	    if (is_page()) {
	        global $post;
	        if ($parents = get_post_ancestors($post->ID)) {
	            foreach ((array)$parents as $parent) {
	                if ($page = get_page($parent)) {
	                    $classes[] = "{$page->post_name}";
	                }
	            }
	        }
	        $classes[] = "{$post->post_name}";
	    }
	    
	    if (is_front_page()) {
	        $classes[] = 'front-page';
	    }

		if (is_user_logged_in()) {
			global $current_user;
			$user_role = array_shift($current_user->roles);
			$classes[] = 'role-'. $user_role;
		}
		
	    if (is_singular('post')) {
	        global $post;
	        foreach((get_the_category($post->ID)) as $category) {
	            $classes[] = 'single-cat-'.$category->category_nicename;
	        }
	    }
	    
	    $browsers = ['is_iphone', 'is_chrome', 'is_safari', 'is_NS4', 'is_opera', 'is_macIE', 'is_winIE', 'is_gecko', 'is_lynx', 'is_IE', 'is_edge'];
	    $classes[] = join(' ', array_filter($browsers, function ($browser) {
	        return $GLOBALS[$browser];
	    }));
		
	    return $classes;
	    
	}
	add_filter('body_class', 'add_custom_body_class');	


//Custom Archive Title
	function custom_archive_title($title) {
		$titles = array('Category: ', 'Tag: ', 'Month: ', 'Author: ');
	    $title = str_replace($titles, '', $title);
	    return $title;
	}
	add_filter('get_the_archive_title', 'custom_archive_title');

	
//Pagination
	function custom_pagination($pages = '', $range = 2) {  
	
		$showitems = ($range * 2)+1;
	
	    global $paged;
	
		if (empty($paged)) {
			$paged = 1;
		}
		
		if ($pages == '') {
	
			global $wp_query, $all_posts;
			
			$pages = $all_posts ? $all_posts->max_num_pages : $wp_query->max_num_pages;
	
			if (!$pages) {
				$pages = 1;
			}
	
		}
	
		if (1 != $pages) {
		
			echo '<ul class="pagination">';
			
				echo ($paged > 2 && $paged > $range+1 && $showitems < $pages) ? '<li><a class="icon first" href="'.get_pagenum_link(1).'">First</a></li>' : '';
				echo ($paged > 1 && $showitems < $pages) ? '<li><a class="icon prev" href="'.get_pagenum_link($paged - 1).'">Previous</a></li>' : '';
				
				for ($i=1; $i <= $pages; $i++) {
					if (1 != $pages && (!($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems)) {
						echo ($paged == $i) ? '<li><span class="current">'.$i.'</span></li>' : '<li><a href="'.get_pagenum_link($i).'" class="inactive">'.$i.'</a></li>';
					}
				}
				
				echo ($paged < $pages && $showitems < $pages) ? "<li><a class='icon next' href='".get_pagenum_link($paged + 1)."'>Next</a></li>" : '';  
				echo ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) ? '<li><a class="icon last" href="'.get_pagenum_link($pages).'">Last</a></li>' : '';
			
			echo '</ul>';
		
		}
	     
	}


//Image Caption
	function custom_image_caption($current_html, $attr, $content) {

	    extract(shortcode_atts(array(
	        'id'    => '',
	        'align' => 'alignnone',
	        'width' => '',
	        'caption' => ''
	    ), $attr));

	    if (1 > (int) $width || empty($caption)) {
	        return $content;
	    }

	    if ($id) $id = 'id="'.esc_attr($id).'" ';
	    
	    $max_width = $width + 20;

	    return '<div '.$id.' class="wp-caption '.esc_attr($align).'" style="max-width:'.$max_width.'px">'.do_shortcode($content).'<p class="wp-caption-text">'.$caption.'</p></div>';

	}
	add_filter('img_caption_shortcode', 'custom_image_caption', 10, 3);

		
?>