<?php


//Modify WYSIWYG
	function custom_mce_formats($init) {
		$init['block_formats'] = 'Heading 1=h1;Heading 2=h2;Heading 3=h3;Paragraph=p';
		return $init;
	}
	add_filter('tiny_mce_before_init', 'custom_mce_formats' );
	
	
//Custom Styles
	function custom_mce_buttons($buttons) {
		array_unshift($buttons, 'styleselect');
		return $buttons;
	}
	add_filter('mce_buttons_2', 'custom_mce_buttons');
	
	function custom_wysiwyg_styles($init_array) {
		
		$style_formats = array(  
			array(  
				'title' => 'Button',  
				'selector' => 'a',
				'classes' => 'button theme-a',
				'wrapper' => false,
			),
			array(  
				'title' => 'Intro Text',  
				'inline' => 'span',
				'classes' => 'intro-text',
				'wrapper' => true,
			),
			array(  
				'title' => 'Orange Text',  
				'inline' => 'span',
				'classes' => 'highlighted-text',
				'wrapper' => true,
			),
		);  
		$init_array['style_formats'] = json_encode($style_formats);
		  
		return $init_array;  
	  
	} 
	add_filter('tiny_mce_before_init', 'custom_wysiwyg_styles');


//Clean HTML
	function clean_post_content($content) {
	
		$content = preg_replace('/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content);
		$content = preg_replace('/<p>\s*(<iframe .*>*.<\/iframe>)\s*<\/p>/iU', '\1', $content);
		$content = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $content);
		$content = preg_replace('/<font[^>]+>/', '', $content);
		
		$post_cleaners = array(
		    '<p></p>' => '',
		    '<p> </p>' => '',
		    '<p>&nbsp;</p>' => '',
		    '<span></span>' => '',
		    '<span> </span>' => '',
		    '<span>&nbsp;</span>' => '',
		    '<b>' => '',
		    '</b>' => '',
		    '<i>' => '',
		    '</i>' => '',
		    '<font>' => '',
		    '</font>' => ''
		);
		
		$content = strtr($content, $post_cleaners);
		
		return $content;
	
	}
	add_filter('the_content', 'clean_post_content');
	add_filter('acf_the_content', 'clean_post_content');


//Remove Pasted Classes
	function custom_tinymce_classes($in) {
		$in['paste_preprocess'] = "function(pl,o){ o.content = o.content.replace(/class=\"p[0-9]+\"/g,''); }";
		return $in;
	}
	add_filter('tiny_mce_before_init', 'custom_tinymce_classes');


//WYSIWYG CSS
	function custom_editor_styles() {
	    add_editor_style( get_template_directory_uri().'/assets/css/wysiwyg.css' );
	}
	add_action('admin_init', 'custom_editor_styles');
	

?>