<?php
	
if (have_rows('layout_blocks')) {
	
	while (have_rows('layout_blocks')) {
		
	    the_row();

		//Content
		if (get_row_layout() == 'content_block') {

			$type = get_sub_field('content_type');

			if (get_sub_field('blocks')) {

				$cols = count(get_sub_field('blocks'));
				$col = 0;
				
				echo '<section class="layout-section content-section theme-a '.$type.'">';
					echo '<div class="wrapper">';

						echo '<div class="cols-wrap cols-'.$cols.'">';
	
							while (has_sub_field('blocks')) {
								
								$col++;
						
								echo '<div class="col col-'.$col.' editable-content">';
									the_sub_field('content');
								echo '</div>';
								
							}
	
						echo '</div>';
						
					echo '</div>';
				echo '</section>';

			}
				
		}
		
		//Form
		if (get_row_layout() == 'form_block') {

			echo '<section class="layout-section form-section theme-a">';
				echo '<div class="wrapper">';
				
					echo '<div class="cols-wrap cols-2">';

						echo '<div class="col col-1 editable-content">';
							the_sub_field('content');
						echo '</div>';
						
						echo '<div class="col col-2=">';

							if ($form = get_sub_field('form')) {
								$post = $form;
								setup_postdata($post);
								get_template_part('assets/forms/form-builder-fe');
								wp_reset_postdata();
							}

						echo '</div>';

					echo '</div>';

				echo '</div>';
			echo '</section>';

		}

		//Icons
		if (get_row_layout() == 'icons_block') {

			echo '<section class="layout-section icons-section theme-a">';
				echo '<div class="wrapper">';
				
					if (get_sub_field('icons')) {
		
						echo '<ul class="icons-list">';
						
							while (has_sub_field('icons')) {
								
								echo '<li>';
								
									echo '<div class="wrap">';
									
										if ($image = get_sub_field('image')) echo '<img class="icon" width="320" height="320" src="'.$image.'" alt="" />';
										if ($title = get_sub_field('title')) echo '<h3>'.$title.'</h3>';
										the_sub_field('text');
									
									echo '</div>';
								
								echo '</li>';
								
							}	
		
						echo '</ul>';
		
					}

				echo '</div>';
			echo '</section>';

		}

		//Jumps
		if (get_row_layout() == 'jumps_block') {

			echo '<section class="layout-section jumps-section theme-a">';
				echo '<div class="wrapper">';
				
					if (get_sub_field('jumps')) {
		
						echo '<ul class="jumps-list">';
						
							while (has_sub_field('jumps')) {
								
								echo '<li>';
								
									echo '<a href="'.get_sub_field('link').'" class="wrap" '.(get_sub_field('image') ? 'style="background-image:url('.get_sub_field('image').');"' : '').'>';
										echo '<h2>'.get_sub_field('title').'</h2>';
									echo '</a>';
								
								echo '</li>';
								
							}	
		
						echo '</ul>';
		
					}

				echo '</div>';
			echo '</section>';

		}

		//Work
		if (get_row_layout() == 'work_block') {

			echo '<section class="layout-section work-section theme-a">';
			
				echo '<div class="wrapper">';
					if ($title = get_sub_field('title')) echo '<h2>'.$title.'</h2>';
				echo '</div>';
				
				if (get_sub_field('work')) {
	
					echo '<ul class="work-list">';
					
						while (has_sub_field('work')) {
							
							if ($work = get_sub_field('work')) {
								$post = $work;
								setup_postdata($post);
								get_template_part('partials/work-post');
								wp_reset_postdata();
							}

						}	
	
					echo '</ul>';
	
				}

			echo '</section>';

		}

	}

}	
	
?>