<?php

/**
 * --------------------------------------------------
 * 404 PAGE
 * --------------------------------------------------
 * This page is used to output the 404 page
 * on this site.
 */

// Include the header.
get_header();

?>

<section data-view="404">

	<div class="banner relative bg-smoke py-16 md:py-20 px-6">
		<div class="container relative z-10">
			<?php render_title('Page Not Found', 'h1', 'text-left text-secondary mx-auto text-xl md:text-4xl animate-fadeIn'); ?>
		</div>
	</div>

	<div class="container wysiwyg">

		<div class="w-8/12 mx-auto py-12 md:py-32 md:px-8">

			<?php render_title('Sorry, the page you requested could not be found', 'h2', 'text-left text-secondary mx-auto text-xl md:text-3xl'); ?>

			<p>This might be because:</p>
			<ul class="pb-10">
				<li>You have typed the web address incorrectly, or</li>
				<li>the page you were looking for may have been moved, updated or deleted.</li>
			</ul>

			<?php render_title('You may also try...', 'h2', 'text-left text-secondary mx-auto text-xl md:text-3xl'); ?>

			<div class="menu-404">
				<?php 
				wp_nav_menu(array(
					"theme_location" => "404-page"
				));
				?>
			</div>
		</div>
	</div>
</section>

<?php

// Include the footer.
get_footer();

?>