<?php
/**
 * Theme Global Variables
 */

define("VIEWS", get_stylesheet_directory() . "/resources/views/");
define("BLOCKS", get_stylesheet_directory() . "/resources/views/blocks/");
define("GOOGLE_MAPS_API_KEY", "AIzaSyB0lxYP9rzQjd3StzgeFn98hi1hjvUfCWc");

/**
 * Theme setup.
 */
function ejweddingsandevents_setup() {
	add_theme_support( 'title-tag' );

	register_nav_menus(
		array(
			'desktop-menu' => __( 'Desktop Menu', 'ejweddingsandevents' ),
			'mobile-menu' => __( 'Mobile Menu', 'ejweddingsandevents' ),
			
			// 'footer-one' => __( 'Footer Menu One', 'ejweddingsandevents' ),
			// 'footer-two' => __( 'Footer Menu Two', 'ejweddingsandevents' ),

            '404-page' => __( '404 Page', 'ejweddingsandevents' ),
		)
	);

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		)
	);

	add_theme_support( 'align-wide' );
    add_theme_support( 'custom-logo' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'wp-block-styles' );

	add_editor_style( 'css/editor-style.css' );
}
add_action( 'after_setup_theme', 'ejweddingsandevents_setup' );



/**
 * Enqueue theme assets.
 */
function residentnorth_enqueue_scripts() {
	$theme = wp_get_theme();

	wp_enqueue_style( 'residentnorth', get_theme_asset( 'css/app.css' ), array(), $theme->get( 'Version' ) );

	wp_enqueue_script( 'residentnorth', get_theme_asset( 'js/app.js' ), array(), $theme->get( 'Version' ) );
	wp_enqueue_script( 'jQuery', get_theme_asset( 'js/jquery-3.7.1.min.js' ), array(), $theme->get( 'Version' ) );
    wp_enqueue_script( 'in-view', get_theme_asset( 'js/in-view-min.js' ), array(), $theme->get( 'Version' ) );

    $hasVideoBlock = false;
    $requireSwiper = false;
    $requireCounter = false;

    // Load Resources based on page blocks. 
    if ($blocks = have_rows('blocks', get_the_ID())) {

        while (have_rows('blocks', get_the_ID())) {
            the_row();

            if (get_row_layout() == "video") {
                $hasVideoBlock = true;
            }

            if (get_row_layout() == "stats") {
                $requireCounter = true;
            }

            if (get_row_layout() == "blog" || get_row_layout() == "pricing" || get_row_layout() == "panels" || get_row_layout() == "image" || get_row_layout() == "testimonials") {

                if (get_row_layout() == "panels") {
                    if (get_sub_field('layout') == "slider") {
                        $requireSwiper = true;
                    }
                } else if (get_row_layout() == "image") {
                    if (get_sub_field('layout') == "slider") {
                        $requireSwiper = true;
                    }
                } else {
                    $requireSwiper = true;
                }
            }

            // Check if there is a global.
            if (get_row_layout() == "global") {
                $blocks = get_fields(get_sub_field('block'))['blocks'];
                foreach ($blocks as $block) {

                    if ($block['acf_fc_layout'] == "video") {
                        $hasVideoBlock = true;
                    }

                    if ($block['acf_fc_layout'] == "stats") {
                        $requireCounter = true;
                    }

                    if ($block['acf_fc_layout'] == "blog" || $block['acf_fc_layout'] == "pricing" || $block['acf_fc_layout'] == "image" || $block['acf_fc_layout'] == "testimonials") {
                        $requireSwiper = true;
                    }
                }
            }
        }

    }

    if ($hasVideoBlock) {
        wp_enqueue_script( 'fancybox', get_theme_asset( 'js/fancybox.umd.js' ), array(), $theme->get( 'Version' ) );
    }

    if ($requireSwiper || is_singular('property')) {
        wp_enqueue_script( 'swiper', get_theme_asset( 'js/swiper-bundle.min.js' ), array('jQuery'), $theme->get( 'Version' ), true );
    }

    if ($requireCounter) {
        wp_enqueue_script( 'js-counter', get_theme_asset( 'js/jquery.countTo.js' ), array(), $theme->get( 'Version' ) );
    }

    // Remove Mega Menu Stylesheet
    wp_dequeue_style( 'open-sans' );
    wp_dequeue_style('wpmm_css');
    wp_dequeue_style('wp_megamenu_generated_css');
    wp_dequeue_style('featuresbox_css');
    wp_dequeue_style('postgrid_css');
    wp_dequeue_script('featuresbox-style');
    wp_dequeue_script('postgrid-style-js-extra');
    wp_dequeue_script('postgrid-style');
}
add_action( 'wp_enqueue_scripts', 'residentnorth_enqueue_scripts' );



/**
 * Remove Ninja Forms Styling
 */
add_action('nf_display_enqueue_scripts', function () {
    wp_dequeue_style('nf-font-awesome');
    wp_dequeue_style('nf-display');
    wp_dequeue_style('display-structure');
    wp_dequeue_style('nf-mp-display-css');
});



/**
 * Add custom image sizes.
 */
function set_image_sizes($sizes) {

    // Remove WordPress Image Sizes
    // unset($sizes['thumbnail']);

    // Add them images sizes.
    add_image_size("logo", 160, 140, false);
    add_image_size("icon", 46, 46, false);

    add_image_size("square", 360, 360, true);
    add_image_size("square-large", 700, 700, true);
    add_image_size("content-width", 896, null, false);

    add_image_size("property_gallery", 1310, 640, false);
    add_image_size("featured_image_portrait", 1310, 640, false);
    add_image_size("featured_image_landscape", 1310, 640, false);

    // Name New Images Sizes
    return array_merge($sizes, array(
        // 'id' => __('Name'),
        'content-width' => __('Post Content'),
    ));
}

function add_images_to_block_editor( $sizes ) {
    return array_merge( $sizes, array(
        // 'id' => __('Name'),
        'content-width' => __('Post Content'),
    ));
}
add_filter( 'image_size_names_choose', 'add_images_to_block_editor' );
set_image_sizes(get_intermediate_image_sizes());



/**
 * Get asset path.
 * @param string  $path Path to asset.
 * @return string
 */
function get_theme_asset( $path ) 
{
	if ( wp_get_environment_type() === 'production' ) {
		return get_stylesheet_directory_uri() . '/' . $path;
	}

	return add_query_arg( 'time', time(),  get_stylesheet_directory_uri() . '/' . $path );
}



/**
 * Get an image from the theme.
 */
function render_image($imageObject, $size = "full", $lazy = true, $class = null)
{
	$renderedImage = "";

    if ($lazy == true) {
        $lazy = wp_get_loading_attr_default( 'wp_get_attachment_image' );
    } else {
        $lazy = "none";
    }

    if (is_null($imageObject))
        return false;

    if (is_array($imageObject)) {
        $renderedImage = wp_get_attachment_image(
            $imageObject['ID'],
            $size,
            false,
            array( 
                'loading' => $lazy,
                'class' => $class,
                'draggable' => 'false'
            ),
        );
    }
    if (empty($renderedImage)) {
        $placeholderSize = "800";
        if ($size !== "full") {
            $placeholderSize = $size[0] . "x" . $size[1];
        }
        $renderedImage = "<img src='https://via.placeholder.com/$placeholderSize' alt='No Image Found' class='$class'/>";
    }

    if (strpos($renderedImage, ".svg") !== false) {
        $renderedImage = preg_replace(
            array('/width="\d+"/i', '/height="\d+"/i'),
            array("", ""),
            $renderedImage);
    }

	echo $renderedImage;
}



/**
 * Include a view file.
 *
 * @param [type] $path
 * @param [type] $extention
 * @param [type] $once
 * @param [type] $data
 * @return void
 */
function view($path = null, $extention = null, $once = null, $data = null) 
{

    if (is_null($path)) {
        return false;
    }
    
    if (!is_null($extention)) {
        $path = $path . $extention;
    } else {
        $path = str_replace(".", "/", $path) . ".php";
    }

    if (!is_null($once)) {
        include_once(VIEWS . $path);
        return true;
    }

    include(VIEWS . $path);
}



/**
 * Render Title
 */
function render_title($data, $type = null, $class = null, $animate = null) {
    if (!empty($data)) {

        // Default title type.
        if (!isset($type) || $type == null) {
            $type = 'h2';
        }
    
        if ($class !== null) {
            $class = ' class="' . $class . '"';
        }

        if ($animate !== null) {
            $animate = ' data-animate="' . $animate . '"';
        }
    
        // Check for shortcode and render.
        if (substr_count($data, '[') === 1 && substr_count($data, ']') === 1) {
            $data = do_shortcode($data);
        }
    
        echo '<' . $type . $class . $animate . '>' . $data . '</' . $type . '>'; 
    }
}



/**
 * Render Content
 * 
 * @param string $data
 * @param string $wrapClass
 * @param string $$paragraphClass
 */
function render_content($data, $wrapClass = null, $paragraphClass =  null, $animate = null)
{
    $return = "";

    if (!empty($data)) {

        if ($animate !== null) {
            $animate = ' data-animate="' . $animate . '"';
        }

        $return .= "<div class='" . trim("wysiwyg " . $wrapClass) . "' {$animate}>";

            // Apply content filter to content.
            $data = apply_filters('the_content', $data);
        
            if ($paragraphClass !== null) {
                    $return .= preg_replace('/<p([^>]+)?>/', "<p class='{$paragraphClass}'>", $data);
            } else {
                $return .= $data;
            }

        $return .= "</div>";
    }

    echo $return;
}



/**
 * Determine text colour using the 
 * background colour provided.
 *
 * @param String $background
 * @return String
 */
function determin_text_colour($background, $type = null)
{
    // Check if the block has an override in place,
    // this is normally set by image backgrounds.
    if ($background == "bg-image" && !empty(get_sub_field('text_colour')) && !isset($type)) {
        return get_sub_field('text_colour');
    }
    if (!empty($background)) {

        if ($background == "bg-black"  || $background == "bg-secondary") {
            return "text-white";
        }
        if ($background == "bg-primary" || $background == "bg-white" || $background == "bg-transparent") {
            return "text-black";
        }
    }
    return "text-black";
}





/**
 * Determine class for text alignment
 * to ensure it's encluding in the 
 * CSS style sheet.
 * 
 * @param String $alignment
 * @return String
 */
function determin_text_alignment($alignment) 
{
    $return = "text-left";
    if ($alignment == "text-center") {
        $return = "text-center";
    }
    if ($alignment == "text-right") {
        $return = "text-right";
    }
    return $return;
}



/**
 * Determin the backgound colour or 
 * image for a block.
 * 
 * @return Object
 */
function determin_background() {

    $return = [
        'id' => "",
        "colour" => "",
        "style" => "",
        "styleClass" => "",
        "size" => "cover",
        "alt" => "",
    ];

    $backgroundColour = get_sub_field('background_colour');

    if ($backgroundColour == "bg-image") {
        $imageObject = get_sub_field('background_image');

        $return['id'] = $imageObject['id'];
        $return['alt'] = $imageObject['alt'];

        // Image positions.
        $x = ""; $y = ""; $size = "";
        if (!empty($pos = get_sub_field('background_alignment'))) {
            if (!empty($pos['x_position'])) {
                $x = " background-position-x: " . $pos['x_position'] . ";";
            }
            if (!empty($pos['y_position'])) {
                $y = " background-position-y: " . $pos['y_position'] . ";";
            }
            if (!empty($pos['size'])) {
                $return['size'] = $pos['size'];
                $size = " background-size: " . $pos['size'] . ";";
            }
        }

        $return["colour"] = 'bg-black';
        $return['imageUrl'] = $imageObject['url'];
        $return["style"] = 'style="background-image: url(\'' . $imageObject['url'] . '\');' . $x . $y . $size . '"';
        $return["styleClass"] = 'background-image: url(\'' . $imageObject['url'] . '\');' . $x . $y . $size;
    } else {
        $return["colour"] = $backgroundColour;
    }
    return $return;
}




/**
 * Render a button
 * 
 * @param Array $data
 * @return mixed
 * TODO: Rewrite this logic
 */
function render_buttons($data) 
{
    if (empty($data) || empty($data['buttons'])) {
        return;
    }

    // Correct array format when using option clone fields.
    if (isset($data['buttons']['clone_buttons'])) {
        $data['buttons'] = $data['buttons']['clone_buttons'];
    }

    if (!isset($data['size'])) {
        $data['size'] = null;
    }

    if (!isset($data['class'])) {
        $data['class'] = null;
    }

    $return = "";
    $wrapClass = (!empty($data['wrapClass'])) ? $data['wrapClass'] . " " : "flex flex-wrap items-center justify-start";

    $animate = "";
    if (isset($data['animate']) && $data['animate'] !== null) {
        $animate = ' data-animate="' . $data['animate'] . '"';
        $wrapClass .= " animate";
    }

    $icon = '<svg class="ml-4 h-6 fill-inherit text-inherit" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.--><path d="M509.7 261.7c3.1-3.1 3.1-8.2 0-11.3l-152-152c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L484.7 248 8 248c-4.4 0-8 3.6-8 8s3.6 8 8 8l476.7 0L346.3 402.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l152-152z"/></svg>';
    if (isset($data['icon']) && $data['icon'] !== null) {
        $icon = $data['icon'];
    }
    
    $return .= "<div class='{$wrapClass}' {$animate}>";
    foreach (reset($data) as $button) :

        // Set the link target.
        $target = "";
        if (isset($button['link']['target'])) {
            $target = "target='{$button['link']['target']}'";
        }

        // Get the button classes.
        $class = determin_button_styles($button, $data['size'], $data['class']); 

        // Remove classes.
        if (isset($data['remove_class']) && !empty($data['remove_class'])) {
            $class = str_replace(explode(" ", $data['remove_class']), array(""), $class);
        }
        
        if (count(reset($data)) > 1) {
            $class .= " mr-4";
        }
        
        if (isset($data['link']) && $data['link'] == false) {
            $return .= "
                <span class='{$class}'>{$button['link']['title']}</span>
            ";
        } else {
            $return .= "
            <a 
                href='{$button['link']['url']}'
                role='button' 
                aria-pressed='false'
                {$target}
                class='{$class} ease-in-out duration-700'
            >
                <span>{$button['link']['title']}</span>
                {$icon}
            </a>";
        }

    endforeach;

    echo $return .= "</div>";
}



/**
 * Determin button style classes 
 * based on data.
 * 
 * @param mixed $data
 * @return String
 */
function determin_button_styles($data, $size = null, $class = null) 
{
    // If the button has provided manual classes.
    $class = (isset($class) && $class) ? $class . " " : "";

    // Change the font size based on button size.
    $buttonClass = " inline-block text-center text-base flex items-center";
    if (isset($size) && $size == "small") {
        $buttonClass .= " px-6 py-2 mb-2 no-underline hover:underline";
    } else {
        $buttonClass .= " px-6 py-4 mb-4 no-underline leading-none hover:underline";
    }

    // If is text button.
    if ($data['style'] == "text") {
        $buttonClass = str_replace(array("px-6", "py-4", 'mb-4'), array("", "", ""), $buttonClass);
    }

    // Is style is solid or keyline.
    if ($data['style'] == "solid" || $data['style'] == "keyline") {
        $styleBase = "";
    } else {
        $styleBase = "";
    }

    $colourBase = "";
    if ($data['style'] == "solid") {
        switch ($data['colour']) {
            case "primary":
                $colourBase = "bg-primary text-black hover:text-black hover:bg-white fill-black hover:fill-black";
                break;
            case "secondary":
                $colourBase = "bg-secondary text-black hover:text-white hover:bg-black fill-black hover:fill-white";
                break;
            case "white":
                $colourBase = "bg-white text-black hover:text-white hover:bg-black fill-black hover:fill-black";
                break;
            default: 
                $colourBase = "bg-black text-white hover:text-white hover:bg-primary fill-white hover:fill-white";
                break;
        }
    } else if ($data['style'] == "keyline") {
        switch ($data['colour']) {
            case "primary":
                $colourBase = "border border-solid border-primary text-primary hover:border-black hover:text-white hover:bg-black fill-primary hover:fill-white";
                break;
            case "secondary":
                $colourBase = "border border-solid border-secondary text-secondary hover:border-black hover:text-white hover:bg-black fill-secondary hover:fill-white";
                break;
            case "white":
                $colourBase = "border border-solid border-white text-white hover:border-black hover:text-black hover:bg-primary fill-white hover:fill-black";
                break;
            default: 
                $colourBase = "border border-solid border-black text-black hover:border-black hover:text-white hover:bg-black fill-black hover:fill-white";
                break;
        }
    } else {
        switch ($data['colour']) {
            case "primary":
                $colourBase = "text-primary fill-primary hover:pl-6";
                break;
            case "secondary":
                $colourBase = "text-secondary fill-secondary hover:pl-6";
                break;
            case "white":
                $colourBase = "text-white fill-white hover:pl-6";
                break;
            default: 
                $colourBase = "text-black fill-black hover:pl-6";
                break;
        }
    }
    
    return trim($class . " " . $styleBase . " " . trim($buttonClass) . " " . $colourBase);
}



/**
 * Include shortcodes for theme.
 */
// include('resources/views/components/shortcodes.php');



/**
 * Setup the ACF options page.
 */
if (function_exists('acf_add_options_page')) 
{
	
	// Main options page registation.
    acf_add_options_page([
        'page_title' => __('Customise Theme'),
        'menu_slug' => 'customise-theme',
        'capability' => 'edit_posts',
        'position' => '2',
        'icon_url' => 'dashicons-art',
        'update_button' => __('Update Theme', 'acf'),
        'updated_message' => __("Theme settings updated.", 'acf'),
    ]);

	// Post settings options page registation.
    acf_add_options_sub_page(array(
        'page_title'  => __('Posts Settings'),
        'menu_title'  => __('Posts Settings'),
        'parent_slug' => 'edit.php',
    ));
}



/**
 * Save ACF fields to file.
 */
function acf_json_save_point( $path ) 
{
	$path = get_stylesheet_directory() . '/resources/acf-json';
    return $path;
}
add_filter('acf/settings/save_json', 'acf_json_save_point');



/**
 * Load ACF fields from file.
 */
function acf_json_load_point( $paths ) 
{
    unset($paths[0]);
    $paths[] = get_stylesheet_directory() . '/resources/acf-json';
    return $paths;
}
add_filter('acf/settings/load_json', 'acf_json_load_point');



/**
 * Set the Google API key for ACF.
 */
function my_acf_init()
{
    acf_update_setting('google_api_key', GOOGLE_MAPS_API_KEY);
}
add_action('acf/init', 'my_acf_init');



/**
 * Add edit button on archives to edit ACF fields.
 */
function custom_button_example($wp_admin_bar) {
    if (is_archive() && !is_tax()) {
        $args = array (
            'id' => 'edit-archive',
            'title' => 'Edit ' . ucwords(str_replace("-", " ", get_post_type())) . ' Archive',
            'href' => '/wp-admin/edit.php?post_type=' . get_post_type() . '&page=' . get_post_type() . '-settings',
            'meta' => array(
                'class' => 'custom-button-class'
            )
        );
        $wp_admin_bar->add_node($args);
    }
}
add_action('admin_bar_menu', 'custom_button_example', 80);



/**
 * Social icons.
 * Uses fields from ACF in the 'Customise Theme' settings. 
 */
function render_social_icons($wrapClass = null, $iconClass = null, $svgClass = null)
{
    if (function_exists('acf_add_options_page')) {
        $profiles = get_field('option_social_profiles', 'option');

        if (is_null($wrapClass)) {
            $wrapClass = "list-none pl-0 mb-0 flex items-center justify-start";
        }
        
        if (is_null($iconClass)) {
            $iconClass = "ease-in-out duration-300 rounded-full text-lg flex items-center justify-center mx-0 p-2 text-white hover:text-green hover:no-underline";
        }

        if (!empty($profiles) && count($profiles) > 0) {
            $html = "<ul class='social-icons {$wrapClass} '>";

            foreach ($profiles as $key => $profile) {
                if ($profile['enable'] == true) {
                    $icon = get_social_icon($profile['profile']['label'], $svgClass);
                    $html .= "<li class='mb-0'>
                        <a href='{$profile['link']}' class='{$iconClass}' title='Connect with us on {$profile['profile']['label']}'>
                        {$icon}
                        </a>
                    </li>";
                }
            }

            $html .= "</ul>";

            echo $html;
        }
        return;
    }
}



/**
 * Select the correct social icon as SVG.
 *
 * @param [type] $label
 * @param [type] $svgClass
 * @return void
 */
function get_social_icon($label, $svgClass) {
    $icon = "";
    $label = strtolower($label);

    if ($svgClass == null) {
        $svgClass = "";
    }

    switch ($label) {
        case "twitter":
            $icon = '<svg class="'.$svgClass.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"/></svg>';
            break;
        case "facebook":
            $icon = '<svg class="'.$svgClass.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><!--! Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"/></svg>';
            break;
        case "linkedin":
            $icon = '<svg class="'.$svgClass.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--! Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg>';
            break;
        case "youtube":
            $icon = '<svg class="'.$svgClass.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><!--! Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>';
            break;
        case "instagram":
            $icon = '<svg class="'.$svgClass.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--! Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>';
            break;
        default :
            $icon = "";
            break;
    }
    return $icon;
}



/**
 * Allow the upload of SVG and CSV files.
 */
function add_mime_types( $existing_mimes ) 
{
    
	// Add CSV files uploads.
	$existing_mimes['csv'] = 'text/csv';
    
	// Add SVG file uploads. 
	$existing_mimes['svg'] = 'image/svg+xml';

    return $existing_mimes;
}
add_filter( 'mime_types', 'add_mime_types' );



/**
 * Admin Style Corrections with ACF Fields
 */
function add_custom_admin_css() {
    global $pagenow;
    echo '
        <style>
        .select2-container {
            z-index: 1100 !important;
        }
        .wp-core-ui select {
            border-color: #8c8f94;
        }
        .acf-fc-layout-handle {
            background-color: #e6e1fa;
        }
        </style>
    ';
}
add_action('admin_head', 'add_custom_admin_css');



/**
 * Return plain titles for WordPress templates titles.
 * Example: Categories, Archives, Tags and Authors
 */
function return_plain_titles($title) 
{
    if (is_category()) {
        // If is category page.
        $title = single_cat_title( '', false );
    } elseif (is_tag()) {
        // If is tag page.
        $title = single_tag_title( '', false );
    } elseif (is_tax()) {
        // If is taxonomy page.
        $title = single_term_title(null, false);
    } elseif (is_author()) {
        // If is author page.
        $title = '<span class="vcard">' . get_the_author() . '</span>' ;
    } elseif (is_post_type_archive()) {
        // If is archive page.
        $title = post_type_archive_title( '', false );
    }
    return $title;
}
add_filter( 'get_the_archive_title', 'return_plain_titles');



/**
 * Ninja Forms: Submit action.
 */
add_action( 'ninja_forms_processing_to_', 'handle_form_processing_action' );
function handle_form_processing_action( $form_data ) {
    // Continue here...
}



/**
 * Remove Ninja Forms "append a form" panel.
 */
function hide_ninja_forms_metaboxes() {
    $screen = get_current_screen();
	if ( !$screen ) {
		return;
	}

    // Hide the "Append a Ninja Form" meta box.
	remove_meta_box('nf_admin_metaboxes_appendaform', $screen->id, 'side');
}
add_action('add_meta_boxes', 'hide_ninja_forms_metaboxes', 20);



/**
 * Add Custom Options to Paragraph Style Selector
 */
add_filter('tiny_mce_before_init', function($init_array) {

    $init_array['formats'] = json_encode([
        // add new format to formats
        'lead' => [
            'selector' => 'p',
            'block'    => 'p',
            'classes'  => 'lead uppercase tracking-wider font-normal',
        ],
    ], JSON_THROW_ON_ERROR);

    $block_formats = [
        'Paragraph=p',
        'Lead=lead',
        'Heading 2=h2',
        'Heading 3=h3',
        'Heading 4=h4',
        'Heading 5=h5',
        'Heading 6=h6',
    ];

    $init_array['block_formats'] = implode(';', $block_formats);

    return $init_array;
});



/**
 * Order Taxonomy with children.
 */
function get_taxonomy_hierarchy( $taxonomy, $parent = 0, $hideEmpty = true) {
    $args = array( 
        'taxonomy' => $taxonomy, 
        'hide_empty' => $hideEmpty, 
        'parent' => $parent,
    );
    $terms = get_terms($args);
    
    $return = array();
    foreach( $terms as $term ) {
        $term->children = get_taxonomy_hierarchy( $taxonomy, $term->term_id );
        $return[ $term->term_id ] = $term;
    }
    return $return;
}



/**
 * SET POST PER PAGE BY POST TYPE
 * Post Utility
 */
function set_posts_per_page_for_cpt($query)
{
    // Offset for blog first page.
    // if (!is_admin() && $query->is_main_query() && $query->is_home() && !$query->is_paged()) {
    //     $query->set( 'offset', '1' );
    // }

    // Offset for blog paged.
    // if (!is_admin() && $query->is_main_query() && $query->is_home() && $query->is_paged()) {
    //     $page = $query->query['paged'] - 1;
    //     $posts_per_page = get_option( 'posts_per_page' );
    //     $query->set( 'offset', ($page * $posts_per_page) + 1);
    // }

    // if (!is_admin() && $query->is_main_query() && is_post_type_archive('faqs')) {
    //     $query->set('posts_per_page', '12');
    // }
}
add_action('pre_get_posts', 'set_posts_per_page_for_cpt');



/**
 * Get the current template name.
 */
function get_template_name() {
    global $template;
    return str_replace('.php', '', basename($template));
}



/**
 * Customise YouTube Embed
 *
 * This function enabled the YouTube API on the videos and 
 * added the required responsive classes from TailWind.
 * 
 * The video API allows you to control what happens when the
 * video ends or controls are used.
 */
function customise_youtube_oembed( $html ) {

    // Check if this is a YouTube Embed and it's an iFrame.
    if (stripos( $html, 'youtube.com' ) !== FALSE && stripos( $html, 'iframe' ) !== FALSE ) {
        $html = str_replace( '<iframe', '<iframe class="mt-10 mb-10 w-full h-full aspect-video" type="text/html" ', $html );
        $html = str_replace( '?feature=oembed', '?feature=oembed&enablejsapi=1', $html );
    }
    return $html;
}
add_filter( 'embed_oembed_html', 'customise_youtube_oembed');



/**
 * Debrand WordPress
 * @author Joe Curran <joe.curran@purpleorbit.co.uk>
 */

// Disable WordPress Admin Bar for all users
// add_filter( 'show_admin_bar', '__return_false' );

remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');

// Disable XML RPC
add_filter( 'xmlrpc_enabled', '__return_false' );

// Remove Windows Live Writer
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');

// Remove WordPress Version Numbers
remove_action('wp_head', 'wp_generator');

// Remove WordPress dns-prefetch
remove_action('wp_head', 'wp_resource_hints', 2);

// Remove the REST API endpoint
remove_action('rest_api_init', 'wp_oembed_register_route');

// Don't filter oEmbed results
remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);

// Remove REST Output link (rel='https://api.w.org/)
remove_action('wp_head', 'rest_output_link_wp_head');

// Remove oEmbed discovery links.
remove_action('wp_head', 'wp_oembed_add_discovery_links');

// Remove oEmbed-specific JavaScript from the front-end and back-end.
remove_action('wp_head', 'wp_oembed_add_host_js');

// Remove links to geeral feeds such as categories
remove_action('wp_head', 'feed_links', 2);

// Remove links to extra feeds such as categories
remove_action('wp_head', 'feed_links_extra', 3);

// Remove the index link
remove_action('wp_head', 'index_rel_link');

// Remove prev page link
remove_action('wp_head', 'parent_post_rel_link', 10, 0);

// Remove start page link
remove_action('wp_head', 'start_post_rel_link', 10, 0);

// Display relational links for the posts adjacent to the current post.
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);

// Remove shortlink from the header
remove_action('wp_head', 'wp_shortlink_wp_head', 10);

// Remove the shortlink redirect
remove_action('template_redirect', 'wp_shortlink_header', 11);

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

// Set the main editor to the classic editor.
// add_filter('use_block_editor_for_post', '__return_false', 10);

// Set the classic editor on set post types. 
function disable_gutenberg_editor_per_posttype( $use_block_editor, $post_type ) {
	if ( $post_type === 'page' || $post_type === 'testimonial' ) {
		return false;
	}
	return $use_block_editor;
}
add_filter( 'use_block_editor_for_post_type', 'disable_gutenberg_editor_per_posttype', 10, 2 );

/**
 * Disable /feed/ URL's and assositated pages. 
 */
function disable_feed_urls() {
    header('HTTP/1.0 404 Not Found', true, 404);
    die(); 
}

add_action('do_feed', 'disable_feed_urls', 1);
add_action('do_feed_rdf', 'disable_feed_urls', 1);
add_action('do_feed_rss', 'disable_feed_urls', 1);
add_action('do_feed_rss2', 'disable_feed_urls', 1);
add_action('do_feed_atom', 'disable_feed_urls', 1);
add_action('do_feed_rss2_comments', 'disable_feed_urls', 1);
add_action('do_feed_atom_comments', 'disable_feed_urls', 1);

/**
 * Disable the links to feed in the head.
 */
remove_action( 'wp_head', 'feed_links_extra', 3 );
remove_action( 'wp_head', 'feed_links', 2 );

// Remove dashicons in frontend to non-admin 
function wpdocs_dequeue_dashicon() {
    if (is_user_logged_in()) {
        return;
    }
    wp_deregister_style('dashicons');
}
add_action( 'wp_enqueue_scripts', 'wpdocs_dequeue_dashicon' );

// Remove rankmath comments from html
add_filter( 'rank_math/frontend/remove_credit_notice', '__return_true' );

// Remove rankmath thank you message
add_action( 'rank_math/whitelabel', '__return_true');

/**
 * Disable user details via the WordPress API
 */
function disable_custom_rest_endpoints( $endpoints ) {
    $routes = array( '/wp/v2/users', '/wp/v2/users/(?P<id>[\d]+)' );

    foreach ( $routes as $route ) {
        if ( empty( $endpoints[ $route ] ) ) {
            continue;
        }

        foreach ( $endpoints[ $route ] as $i => $handlers ) {
            if ( is_array( $handlers ) && isset( $handlers['methods'] ) &&
                'GET' === $handlers['methods'] ) {
                unset( $endpoints[ $route ][ $i ] );
            }
        }
    }

    return $endpoints;
}
add_filter( 'rest_endpoints', 'disable_custom_rest_endpoints' );

/**
 * Block User-enumeration
 */
if (!is_admin()) {
	if (preg_match('/author=([0-9]*)/i', $_SERVER['QUERY_STRING'])) die();
	add_filter('redirect_canonical', 'block_user_enumeration', 10, 2);
}

function block_user_enumeration($redirect, $request) {
	if (preg_match('/\?author=([0-9]*)(\/*)/i', $request)) die();
	else return $redirect;
}
