(() => {
  // resources/js/app.js
  window.addEventListener("load", () => {
    const body = document.querySelector("body");
    const header = document.querySelector("header");
    if (header !== null && header !== void 0) {
      const hamburger = document.querySelector(".hamburger input");
      if (hamburger !== null && hamburger !== void 0) {
        hamburger.addEventListener("change", () => {
          if (hamburger.checked == true) {
            body.dataset.menuState = "1";
            header.dataset.menuState = "1";
          } else {
            body.dataset.menuState = "0";
            header.dataset.menuState = "0";
            const menuItemsWithChildren = document.querySelectorAll("li.menu-item-has-children");
            menuItemsWithChildren.forEach((element) => {
              element.dataset.state = "0";
            });
          }
        });
      }
    }
    const menu = document.querySelector('[data-menu="mobile-menu"]');
    if (menu !== null && menu !== void 0) {
      const menuLinks = menu.querySelectorAll("li");
      menuLinks.forEach((element) => {
        const link = element.querySelector("a");
        if (link.href == "#") {
          link.addEventListener("click", (event) => {
            event.preventDefault();
          });
        }
        if (element.classList.contains("menu-item-has-children")) {
          element.dataset.state = 0;
          let trigger = document.createElement("span");
          element.querySelector("a").after(trigger);
          trigger.addEventListener("click", () => {
            if (element.dataset.state == "0")
              element.dataset.state = "1";
            else
              element.dataset.state = "0";
          });
        }
      });
    }
  });
  window.addEventListener("load", () => {
    if (document.querySelector("header[data-scrolled]")) {
      const header = document.querySelector("header[data-scrolled]");
      let prev = 0;
      if (window.scrollY > 1)
        header.dataset.scrolled = "1";
      window.addEventListener("scroll", () => {
        const header2 = document.querySelector("header[data-scrolled]");
        if (window.scrollY > 30) {
          header2.dataset.scrolled = "1";
        } else {
          header2.dataset.scrolled = "0";
        }
        prev = window.scrollY;
      });
    }
  });
  window.addEventListener("load", () => {
    let accordionGroups = document.querySelectorAll("[data-accordion]");
    if (accordionGroups !== null && accordionGroups !== void 0) {
      accordionGroups.forEach((group) => {
        let closeAll = group.hasAttribute("close-all") ? true : false;
        let rows = group.querySelectorAll("[data-accordion-target]");
        rows.forEach((row) => {
          row.addEventListener("click", (e) => {
            e.preventDefault();
            if (closeAll) {
              if (row.hasAttribute("expanded")) {
                row.removeAttribute("expanded");
                row.setAttribute("aria-expanded", false);
                document.querySelector(row.dataset.accordionTarget).removeAttribute("expanded");
              } else {
                rows.forEach((row2) => {
                  row2.removeAttribute("expanded");
                  row2.setAttribute("aria-expanded", false);
                  row2.parentNode.parentNode.querySelector(".body").removeAttribute("expanded");
                });
                row.setAttribute("expanded", true);
                row.setAttribute("aria-expanded", true);
                document.querySelector(row.dataset.accordionTarget).setAttribute("expanded", true);
              }
            } else {
              if (row.hasAttribute("expanded")) {
                row.removeAttribute("expanded");
                row.setAttribute("aria-expanded", false);
                document.querySelector(row.dataset.accordionTarget).removeAttribute("expanded");
              } else {
                row.setAttribute("expanded", true);
                row.setAttribute("aria-expanded", true);
                document.querySelector(row.dataset.accordionTarget).setAttribute("expanded", true);
              }
            }
          });
        });
      });
    }
  });
  window.addEventListener("load", () => {
    const tables = document.querySelectorAll("table");
    tables.forEach((table, index) => {
      if (table.dataset.table === "responsive")
        return;
      else
        table.dataset.table = "responsive";
      const rows = table.querySelectorAll("tr");
      const cellsPerRow = rows[0].childElementCount;
      let titles = [];
      let titleCells = rows[0].querySelectorAll("td");
      if (titleCells.length === 0) {
        titleCells = rows[0].querySelectorAll("th");
      }
      titleCells.forEach((cell, index2) => {
        if (cell.childElementCount === 0) {
          titles[index2] = cell.innerHTML;
        } else {
          titles[index2] = cell.innerHTML.replace(/(<([^>]+)>)/ig, "");
        }
      });
      rows.forEach((row, index2) => {
        var empty = 0;
        if (index2 === 0)
          return;
        const cells = row.querySelectorAll("td");
        cells.forEach((cell, index3) => {
          if (cell.innerHTML == "&nbsp;")
            cell.innerHTML = "";
          if (cell.children.length === 0 && cell.innerHTML.length === 0) {
            cell.classList.add("column-empty");
            empty++;
          }
          let label = document.createElement("span");
          label.classList.add("column-title");
          label.innerHTML = titles[index3];
          cell.prepend(label);
        });
        if (empty === cellsPerRow)
          row.remove();
      });
    });
  });
  document.addEventListener("DOMContentLoaded", function() {
    if (typeof Marionette != "undefined") {
      var myCustomFieldController = Marionette.Object.extend({
        initialize: function(options) {
          var submitChannel = Backbone.Radio.channel("submit");
          this.listenTo(submitChannel, "validate:field", this.validate);
          var fieldsChannel = Backbone.Radio.channel("phone");
          this.listenTo(fieldsChannel, "change:modelValue", this.validatePhone);
          this.listenTo(nfRadio.channel("listselect"), "render:view", this.renderCustomSelect);
          this.listenTo(nfRadio.channel("number"), "render:view", this.renderCustomNumber);
        },
        validatePhone: function(model) {
          if (model.get("type") == "phone" && model.get("value")) {
            var value = model.get("value");
            var regex = new RegExp(/^(?:(?:\(?(?:0(?:0|11)\)?[\s-]?\(?|\+)44\)?[\s-]?(?:\(?0\)?[\s-]?)?)|(?:\(?0))(?:(?:\d{5}\)?[\s-]?\d{4,5})|(?:\d{4}\)?[\s-]?(?:\d{5}|\d{3}[\s-]?\d{3}))|(?:\d{3}\)?[\s-]?\d{3}[\s-]?\d{3,4})|(?:\d{2}\)?[\s-]?\d{4}[\s-]?\d{4}))(?:[\s-]?(?:x|ext\.?|\#)\d{3,4})?$/);
            if (regex.test(value)) {
              var modelID = model.get("id");
              var errorID = "unvalid-phone";
              var fieldsChannel = Backbone.Radio.channel("fields");
              fieldsChannel.request("remove:error", modelID, errorID);
            } else {
              var modelID = model.get("id");
              var errorID = "unvalid-phone";
              var errorMessage = "Please enter a valid UK phone number.";
              var fieldsChannel = Backbone.Radio.channel("fields");
              fieldsChannel.request("add:error", modelID, errorID, errorMessage);
            }
          }
        },
        renderCustomNumber: function(field) {
          field.el.querySelector("input").setAttribute("pattern", "\\d*");
        },
        renderCustomSelect: function(view) {
          view.el.classList.add("custom-select");
          var field = view.el.querySelector("select");
          field.classList.add("custom-select--original");
          var dropdown = document.createElement("div");
          dropdown.classList.add("custom-select--options");
          var label = document.createElement("div");
          label.classList.add("custom-select--label");
          label.innerHTML = field.options[field.selectedIndex].innerText;
          dropdown.appendChild(label);
          var optionsGroup = document.createElement("div");
          optionsGroup.classList.add("custom-select--options-group");
          var options = view.el.querySelector("select").options;
          for (let i = 0; i < options.length; i++) {
            const element = options[i];
            var customOptions = document.createElement("span");
            customOptions.classList.add("custom-select--option");
            customOptions.innerHTML = element.innerText;
            customOptions.setAttribute("data-value", element.value);
            optionsGroup.appendChild(customOptions);
          }
          dropdown.appendChild(optionsGroup);
          var customOptions = optionsGroup.childNodes;
          for (let i = 0; i < customOptions.length; i++) {
            const element = customOptions[i];
            element.addEventListener("click", function() {
              jQuery("#" + field.id).val(element.dataset.value).trigger("change");
              label.innerHTML = element.innerHTML;
              view.el.querySelector(".custom-select--options").classList.remove("custom-select--active");
            });
            document.addEventListener("mouseup", function(e) {
              if (!e.target.classList.contains("custom-select--options")) {
                view.el.querySelector(".custom-select--options").classList.remove("custom-select--active");
              }
            });
          }
          view.el.appendChild(dropdown);
          view.el.querySelector(".custom-select--label").addEventListener("click", function() {
            view.el.querySelector(".custom-select--options").classList.add("custom-select--active");
          });
        }
      });
      new myCustomFieldController();
    }
  }, false);
  document.addEventListener("DOMContentLoaded", () => {
    inView("[data-animate]").on("enter", (el) => {
      el.classList.add(...el.dataset.animate.split(" "));
    });
  });
  document.addEventListener("DOMContentLoaded", function() {
    jQuery(document).on("nfFormSubmitResponse", function(event, response, id) {
      window.dataLayer = window.dataLayer || [];
      window.dataLayer.push({
        event: "formSubmission",
        formID: response.id
      });
      console.log("Thank you for your form submission.", response);
    });
  }, false);
})();
