<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the background for the block.
$background = determin_background();

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');
$buttonAlignment = "justify-center";

// Change value when aligned left.
if ($textAlignment == "text-left") {
    $buttonAlignment = "justify-start";
}
// Change value when aligned right.
if ($textAlignment == "text-right") {
    $buttonAlignment = "justify-end";
}

// Animation Delay
$animationDelay = ['animate-delay-500', 'animate-delay-[750ms]', 'animate-delay-[1000ms]', 'animate-delay-[1250ms]', 'animate-delay-[1500ms]', 'animate-delay-[1750ms]']
?>

<div class="px-8 py-20 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>

    <div class="container max-w-4xl animate" data-animate="animate-fade-up animate-ease-in-out">
        <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
        <?php render_content(get_sub_field('content'), 'mt-6 mb-10', '') ; ?>
            
        <div data-accordion="<?php echo $position; ?>" <?php echo (get_sub_field('single_mode')) ? "close-all" : ""; ?> class="text-left">
            <?php foreach(get_sub_field('rows') as $key => $value) : ?>
                <div class="border-b border-solid border-smoke/20 animate" data-animate="animate-fade-up <?php echo (!empty($animationDelay[$key]) ? $animationDelay[$key] : 'animate-delay-[3000ms]'); ?> animate-ease-in-out">
                    <div class="head px-6 py-3 hover:bg-[#9493932b] ease-in-out duration-500">
                        <button type="button" class="flex items-center justify-between w-full font-medium text-left" data-accordion-target="#accordion-body-faqs-<?php echo $position; ?>-<?php echo $key; ?>" aria-expanded="false" aria-controls="accordion-body-faqs-<?php echo $position; ?>-<?php echo $key; ?>">
                            <h3 class="text-base font-bold mb-0"><?php echo $value['title']; ?></h3>
                            <div class="toggle-button h-8 w-8 rounded-full border border-smoke flex items-center justify-center ease-linear duration-500 delay-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26"viewBox="0 0 24 24">
                                    <g>
                                        <path d="M7.41 8.58L12 13.17l4.59-4.59L18 10l-6 6-6-6 1.41-1.42z" fill="currentColor"></path>
                                    </g>
                                </svg>
                            </div>
                        </button>
                    </div>
                    <div id="accordion-body-faqs-<?php echo $position; ?>-<?php echo $key; ?>" aria-labelledby="accordion-body-faqs-<?php echo $position; ?>-<?php echo $key; ?>" class="body text-base">
                        <?php render_content($value['content'], 'px-6 py-6 pr-12'); ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <?php render_buttons([
            "buttons" => get_sub_field('clone_buttons', 'option'),
            "wrapClass" => "flex mt-5 md:mt-10 " . $buttonAlignment,
        ]); ?>

    </div>

</div>