<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

?>

<div class="<?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container py-10 md:py-20 px-6 flex flex-col <?php echo (get_sub_field('media_side') == "left") ? "md:flex-row":"md:flex-row-reverse"; ?>">

        <div class="w-full md:w-6/12 mb-4 md:mb-0 animate" data-animate="animate-fade-up animate-delay-1000">
            <?php render_image(get_sub_field('image'), array(690, 690), true, 'object-cover w-full h-full'); ?>
        </div>
        <div class="w-full md:w-6/12 <?php echo (get_sub_field('media_side') == "left") ? "md:pl-20":"md:pr-20"; ?> flex flex-col justify-center animate" data-animate="animate-fade-up animate-delay-500">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('text-left ml-0 mb-6 ' . $titleFont . $titleStyle)); ?>
            <div class="bg-black h-[1px] w-10 mb-12"></div>
            <?php render_content(get_sub_field('content'), 'text-sm lg:text-base', 'text-left'); ?>
            <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex flex-wrap justify-center md:justify-start mt-6",
                ]); ?>
        </div>

    </div>
</div>