<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

?>

<div class="relative py-16 md:py-32 px-8 md:px-0 <?php echo $textColour; ?> <?php echo $background["colour"]; ?>" <?php echo $background["style"]; ?>>
    <div class="container relative z-10 animate" data-animate="animate-fade-up">
        <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('text-center mx-auto max-w-4xl mb-0 font-display font-bold ' . $titleFont . $titleStyle)); ?>
        <?php render_content(get_sub_field('content'), 'max-w-2xl mx-auto mt-4', 'text-sm md:text-base text-center'); ?>
        <?php if (!empty(get_sub_field('clone_buttons', 'option'))) {
            render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex justify-center mt-6",
            ]);
        } ?>
    </div>
</div>