<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

?>

<div class="relative py-16 md:py-32 h-screen overflow-hidden flex items-center justify-center px-8 md:px-0 <?php echo $textColour; ?> <?php echo $background["colour"]; ?>" <?php echo $background["style"]; ?>>

    <?php if (get_sub_field('enable_video_background')) : ?>
        <div class="absolute top-0 left-0 w-full h-full z-10">
            <video id="video-<?php echo $position; ?>" autoplay muted loop playsinline reload="auto" poster="<?php echo (!empty($background['imageUrl'])) ? $background['imageUrl'] : ""; ?>" class="w-full h-full object-cover">
                <source src="<?php echo get_sub_field('video_background_url'); ?>" type="video/mp4">
            </video>
        </div>
    <?php endif; ?>
    <?php if (get_sub_field('enable_video_background_muting')) : ?>
        <div class="absolute top-0 left-0 w-full h-full bg-black/40 z-20"></div>
    <?php endif; ?>

    <div class="container relative z-20">
        <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('text-center mx-auto text-4xl md:text-5xl max-w-5xl font-display font-bold ' . $titleFont . $titleStyle), 'animate-fade-up'); ?>
        <?php render_content(get_sub_field('content'), 'max-w-2xl mx-auto animate', 'text-sm md:text-base text-center font-medium', 'animate-fade-up animate-delay-1000'); ?>
        <?php if (!empty(get_sub_field('clone_buttons', 'option'))) {
            render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex justify-center mt-6 animate",
                "animate" => "animate-fade-up animate-delay-[1500ms]"
            ]);
        } ?>
    </div>
</div>