<?php

global $pageID;
global $pageName;

// Set the default page id.
if (!isset($pageID)) {
    if (is_home()) {
        $pageID = get_option('page_for_posts');
    } else if (is_tax() || is_category()) {
        $pageID = get_queried_object();
    } else {
        $pageID = get_the_id();
    }
}

// Set the default fallback field name.
if (!isset($pageName)) {
    $pageName = "blocks";
}

if (have_rows($pageName, $pageID)) {
    while (have_rows($pageName, $pageID)) {
        the_row();

        // Get the block position.
        $position = get_row_index();

        // Get the layout.
        $layout = get_sub_field('layout');
        if (empty($layout)) {
            $layout = "standard";
        }

        // Get the background for the block.
        if (get_row_layout() == "global") {
            $last_block = end(get_field('blocks', get_sub_field('block')));
            $background = $last_block['background_colour'];
        } else {
            $background = determin_background();
        }

        // Reset background images.
        if (isset($backgroundImage)) {
            unset($backgroundImage);
        }

        if (isset($backgroundOverlay)) {
            unset($backgroundOverlay);
        }

        // Load the block.
        include(BLOCKS . get_row_layout() . "/block.php");
    }
}
