<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

$paragraphColor = "";
if (get_sub_field('background_colour') == "bg-white") {
    $paragraphColor = "text-black";
} else {
    $paragraphColor = $textColour;
}

?>

<div class="relative <?php echo $background["colour"]; ?> text-center <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container z-20 relative mx-auto py-10 md:py-20">

        <div class="px-6">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  'text-2xl md:text-3xl uppercase'); ?>
            <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
        </div>

        <div class="relative w-full pl-6 pr-16 lg:px-10 overflow-hidden">
            <div class="swiper swiper-<?php echo $position; ?>">
                <div class="swiper-wrapper pt-6">
                    <?php 
                        $args = array(
                            'posts_per_page' => 6,
                            'post_type' => 'post',
                            'post_status' => 'publish',
                            'post__not_in' => array(get_the_id())
                        );
                        if (get_sub_field('display_mode') === "category" && !empty(get_sub_field('category'))) {
                            $args['cat'] = get_sub_field('category');
                        }
                        $posts = new WP_Query($args);

                        if ( $posts->have_posts() ) {
                            while ( $posts->have_posts() ) {
                                $posts->the_post();
                                echo '<div class="swiper-slide">';
                                view('blog.post', null, null, ["classes" => "bg-white text-black"]);
                                echo '</div>';
                            }
                        }
                        wp_reset_postdata();
                    ?>

                </div>
            </div>
            
            <div class="swiper-button-prev swiper-button-prev-<?php echo $position; ?> relative z-30"></div>
            <div class="swiper-button-next swiper-button-next-<?php echo $position; ?> relative z-30"></div>
        </div>

    </div>
</div>

<script>
    window.addEventListener('load', () => {
        const swiper = new Swiper('.swiper-<?php echo $position; ?>', {
            loop: true,
            draggable: true,
            slidesPerView: 1,
            spaceBetween: 20,
            grabCursor: true,
            createElements: true,

            breakpoints: {
                // when window width is >=
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 30
                },
                1024: {
                    slidesPerView: 2,
                    spaceBetween: 40
                },
                1140: {
                    slidesPerView: 3,
                    spaceBetween: 40
                }
            },

            // Navigation arrows
            navigation: {
                nextEl: '.swiper-button-next-<?php echo $position; ?>',
                prevEl: '.swiper-button-prev-<?php echo $position; ?>',
            },
        });
    });

</script>