<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

?>

<div class="<?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto py-10 md:py-20 px-6">

        <div class="flex flex-wrap">
            <div class="w-full md:w-8/12 md:pr-8 wysiwyg animate" data-animate="animate-fade-up animate-delay-1000">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle . "text-left text-3xl max-w-2xl")); ?>
            </div>
            <div class="w-full md:w-4/12 wysiwyg animate" data-animate="animate-fade-up animate-delay-[1500ms]">
                <?php render_content(get_sub_field('content'), null, "text-inherit text-sm md:text-base max-w-xl mx-auto") ; ?>
            </div>
        </div>

    </div>
</div>