<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

?>

<div class="<?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="max-w-5xl mx-auto py-10 md:py-20 px-6">

        <?php if (!empty(get_sub_field('title'))) : ?>
            <div class="w-full animate" data-animate="animate-fade-up">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle . "max-w-4xl mb-8")); ?>
            </div>
        <?php endif; ?>

        <div class="flex flex-wrap">
            <div class="w-full md:w-1/2 md:pr-8 wysiwyg animate" data-animate="animate-fade-up animate-delay-1000">
                <?php render_content(get_sub_field('content'), null, "text-inherit text-sm md:text-base max-w-xl mx-auto") ; ?>
            </div>
            <div class="w-full md:w-1/2 md:pl-8 wysiwyg animate" data-animate="animate-fade-up animate-delay-[1500ms]">
                <?php render_content(get_sub_field('content_dual'), null, "text-inherit text-sm md:text-base max-w-xl mx-auto") ; ?>
            </div>
        </div>

    </div>
</div>