<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

?>

<div class="py-10  md:py-20 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto px-6">

        <div class="flex flex-wrap">
            <div class="w-full md:w-8/12 md:pr-20 wysiwyg animate" data-animate="animate-fade-up">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('mb-0' . $titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-4', 'text-sm md:text-base'); ?>
                <?php if (!empty(get_sub_field('clone_buttons', 'option'))) {
                    render_buttons([
                        "buttons" => get_sub_field('clone_buttons', 'option'),
                        "wrapClass" => "flex justify-center mt-6",
                    ]);
                } ?>
            </div>
            <div class="w-full md:w-4/12 wysiwyg animate" data-animate="animate-fade-up animate-delay-1000">
                <?php render_image(get_sub_field('image'), 'full'); ?>
            </div>
        </div>

    </div>
</div>