<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Get the text alignment.
$title_alignment = "";
$text_alignment = get_sub_field('text_alignment');
$content_alignment = "";

if ($text_alignment == "text-center") {
    $title_alignment = "max-w-2xl mx-auto";
    $content_alignment = "justify-center";
    }
    
    if ($text_alignment == "text-right") {
    $title_alignment = "max-w-2xl ml-auto";
    $content_alignment = "justify-end";
}

?>

<div class="relative py-10 px-6 md:py-20 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

    <div class="max-w-4xl mx-auto relative z-20">
        <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm font-bold mb-4'); ?>
        <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" ", ['mb-6', $title_alignment, $titleFont, $titleStyle])); ?>
        <div class="bg-black h-[1px] w-40 mb-12 <?php echo $title_alignment; ?>"></div>
        <?php render_content(get_sub_field('content')) ; ?>
        <?php render_buttons([
            "buttons" => get_sub_field('clone_buttons', 'option'),
            "wrapClass" => "flex mt-6 " . $content_alignment,
        ]); ?>
    </div>
</div>



