<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

?>


<div class="<?php echo get_sub_field('background_colour'); ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>">
    <div class="container pb-20">

        <?php view('components/title', null, null, [
            "title" => get_sub_field('title'),
            "type" => get_sub_field('title_type'),
            "class" => 'mt-0 mb-12 font-bold text-center text-xl font-sans leading-none'
        ]); ?>

        <div class="features flex items-center justify-center flex-wrap md:-mx-10">
            <?php 
            $count = count(get_sub_field('features'));
            foreach (get_sub_field('features') as $key => $value) : ?>

                <div class="w-1/2 md:w-1/4 md:px-10 mb-6 md:mb-0">
                    <div class="text-lg font-bold text-center md-4 md:mb-0">
                        <div class="mb-6 flex justify-center">
                            <?php
                            if (!empty($value['icon']['url'])) {
                                render_image($value['icon'], array(120, 120)); 
                            }
                            ?>
                        </div>
                        <?php echo $value['title']; ?>
                    </div>
                    <?php if (!empty($value['content'])) : ?>
                        <p class="text-xs mb-0 leading-5"><?php echo strip_tags($value['content'], '<strong><b><u><i>'); ?></p>
                    <?php endif; ?>
                </div>

            <?php endforeach; ?>
        </div>

    </div>
</div>